/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.entity.projectile.ProjectileLogic;

public class SimpleEntityLaunchLogic<P extends Projectile>
implements ProjectileLogic<P> {
    protected final Supplier<EntityType<P>> projectileType;

    public SimpleEntityLaunchLogic(Supplier<EntityType<P>> projectileType) {
        this.projectileType = projectileType;
    }

    @Override
    public Optional<P> launch(ProjectileSource source) {
        if (!(source instanceof org.spongepowered.api.entity.Entity)) {
            return Optional.empty();
        }
        ServerLocation loc = ((org.spongepowered.api.entity.Entity)source).getServerLocation().add(0.0, ((Entity)source).func_213302_cg() / 2.0f, 0.0);
        if (source instanceof LivingEntity) {
            return this.createProjectile((LivingEntity)source, loc);
        }
        return this.createProjectile(source, this.projectileType.get(), loc);
    }

    protected Optional<P> createProjectile(LivingEntity source, ServerLocation loc) {
        return this.createProjectile((ProjectileSource)source, this.projectileType.get(), loc);
    }
}

