/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.minecraft.block.Block;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.Jukebox;
import org.spongepowered.api.block.transaction.BlockTransaction;
import org.spongepowered.api.block.transaction.Operations;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.CollideBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.api.event.entity.explosive.DetonateExplosiveEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeCommonEventFactory {
    public static int lastAnimationPacketTick = 0;
    public static int lastSecondaryPacketTick = 0;
    public static int lastPrimaryPacketTick = 0;
    @Nullable
    public static WeakReference<ServerPlayerEntity> lastAnimationPlayer;

    public static void callDropItemDispense(List<ItemEntity> items, PhaseContext<?> context) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DISPENSE);
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (ItemEntity item : items) {
                entities.add((Entity)item);
            }
            DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(frame.getCurrentCause(), entities);
            SpongeCommon.postEvent(dispense);
            if (!dispense.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(context, dispense);
            }
        }
    }

    public static void callDropItemDrop(ServerPlayerEntity player, List<ItemEntity> items, PhaseContext<?> context) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (ItemEntity item : items) {
                entities.add((Entity)item);
            }
            Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.empty(), ItemStackSnapshot.empty());
            ClickContainerEvent.Drop.Outside.Creative dispense = SpongeEventFactory.createClickContainerEventDropOutsideCreative(frame.getCurrentCause(), (Container)player.field_71070_bA, cursorTransaction, entities, Optional.empty(), Collections.emptyList());
            SpongeCommon.postEvent(dispense);
            if (!dispense.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(context, dispense);
            }
        }
    }

    public static void callDropItemCustom(List<Entity> items, PhaseContext<?> context) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(frame.getCurrentCause(), items);
            SpongeCommon.postEvent(event);
            if (!event.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(context, event);
            }
        }
    }

    public static void callDropItemCustom(List<Entity> items, PhaseContext<?> context, Supplier<Optional<User>> supplier) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
            DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(frame.getCurrentCause(), items);
            SpongeCommon.postEvent(event);
            if (!event.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(event, supplier);
            }
        }
    }

    public static void callDropItemClose(List<Entity> items, PhaseContext<?> context, Supplier<Optional<User>> supplier) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
            DropItemEvent.Close event = SpongeEventFactory.createDropItemEventClose(frame.getCurrentCause(), items);
            SpongeCommon.postEvent(event);
            if (!event.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(event, supplier);
            }
        }
    }

    public static boolean callSpawnEntitySpawner(List<Entity> entities, PhaseContext<?> context) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.WORLD_SPAWNER);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(frame.getCurrentCause(), entities);
            SpongeCommon.postEvent(event);
            if (!event.isCancelled() && event.getEntities().size() > 0) {
                boolean bl = EntityUtil.processEntitySpawnsFromEvent(context, event);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void callDropItemDestruct(List<Entity> entities, PhaseContext<?> context) {
        DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(PhaseTracker.getCauseStackManager().getCurrentCause(), entities);
        SpongeCommon.postEvent(destruct);
        if (!destruct.isCancelled()) {
            EntityUtil.processEntitySpawnsFromEvent(context, destruct);
        }
    }

    public static boolean callSpawnEntity(List<Entity> entities, PhaseContext<?> context) {
        PhaseTracker.getCauseStackManager().getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
        try {
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), entities);
            SpongeCommon.postEvent(event);
            return !event.isCancelled() && EntityUtil.processEntitySpawnsFromEvent(context, event);
        }
        catch (Exception e) {
            PrettyPrinter printer = new PrettyPrinter(60).add("Exception trying to create a Spawn Event").centre().hr().addWrapped("Something did not go well trying to create an event or while trying to throw a SpawnEntityEvent. My bet is it's gremlins", new Object[0]).add().add("At the very least here's some information about what's going to be directly spawned without an event:");
            printer.add("Entities:");
            for (Entity entity : entities) {
                printer.add(" - " + entity);
            }
            printer.add("PhaseContext:");
            context.printCustom(printer, 4);
            printer.add();
            printer.add("Exception:");
            printer.add(e);
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
            for (Entity entity : entities) {
                EntityUtil.processEntitySpawn(entity, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
            }
            return true;
        }
    }

    public static boolean callSpawnEntityCustom(List<Entity> entities, PhaseContext<?> context) {
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(PhaseTracker.getCauseStackManager().getCurrentCause(), entities);
        SpongeCommon.postEvent(event);
        return event.isCancelled() && EntityUtil.processEntitySpawnsFromEvent(context, event);
    }

    @Nullable
    public static <T extends net.minecraft.entity.Entity> CollideEntityEvent callCollideEntityEvent(net.minecraft.world.World world, @Nullable net.minecraft.entity.Entity sourceEntity, List<T> entities) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseContext<?> currentContext = phaseTracker.getPhaseContext();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (sourceEntity != null) {
                if (currentContext.getSource() != sourceEntity) {
                    frame.pushCause(sourceEntity);
                }
            } else {
                Object source = currentContext.getSource();
                if (source instanceof LocatableBlock) {
                    frame.pushCause(source);
                } else if (source instanceof BlockEntity) {
                    frame.pushCause(source);
                } else if (source instanceof Entity) {
                    frame.pushCause(source);
                }
            }
            currentContext.addCreatorAndNotifierToCauseStack(frame);
            List<Entity> spEntities = entities;
            CollideEntityEvent event = SpongeEventFactory.createCollideEntityEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), spEntities);
            SpongeCommon.postEvent(event);
            CollideEntityEvent collideEntityEvent = event;
            return collideEntityEvent;
        }
    }

    public static boolean handlePistonEvent(TrackedWorldBridge world, BlockPos pos, net.minecraft.block.BlockState blockstate, int eventId) {
        boolean extending = eventId == 0;
        Direction direction = (Direction)blockstate.func_177229_b((Property)DirectionalBlock.field_176387_N);
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)((Object)world)).state((BlockState)blockstate).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).build();
        HashSet<ServerLocation> locations = new HashSet<ServerLocation>();
        locations.add(ServerLocation.of((ServerWorld)((Object)world), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        PistonBlockStructureHelper movedBlocks = new PistonBlockStructureHelper((net.minecraft.world.World)((net.minecraft.world.server.ServerWorld)world), pos, direction, extending);
        movedBlocks.func_177253_a();
        Stream.concat(movedBlocks.func_177254_c().stream(), movedBlocks.func_177252_d().stream()).map(block -> ServerLocation.of((ServerWorld)((Object)world), block.func_177958_n(), block.func_177956_o(), block.func_177952_p())).collect(Collectors.toCollection(() -> locations));
        if (extending && movedBlocks.func_177252_d().isEmpty()) {
            List movedPositions = movedBlocks.func_177254_c();
            BlockPos offsetPos = movedPositions.isEmpty() ? pos.func_177972_a(direction) : ((BlockPos)movedPositions.get(movedPositions.size() - 1)).func_177972_a(direction);
            locations.add(ServerLocation.of((ServerWorld)((Object)world), offsetPos.func_177958_n(), offsetPos.func_177956_o(), offsetPos.func_177952_p()));
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            if (extending) {
                frame.addContext(EventContextKeys.PISTON_EXTEND, (ServerWorld)((Object)world));
            } else {
                frame.addContext(EventContextKeys.PISTON_RETRACT, (ServerWorld)((Object)world));
            }
            boolean bl = SpongeCommonEventFactory.callChangeBlockEventPre((ServerWorldBridge)((Object)world), (ImmutableList<ServerLocation>)ImmutableList.copyOf(locations), (Object)locatable).isCancelled();
            return bl;
        }
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerWorldBridge worldIn, BlockPos pos) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<ServerLocation>)ImmutableList.of((Object)ServerLocation.of((ServerWorld)((Object)worldIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), null);
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerWorldBridge worldIn, BlockPos pos, Object source) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<ServerLocation>)ImmutableList.of((Object)ServerLocation.of((ServerWorld)((Object)worldIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), source);
    }

    private static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerWorldBridge worldIn, ImmutableList<ServerLocation> locations, @Nullable Object source) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            User user;
            PhaseContext<?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
            if (source == null) {
                source = phaseContext.getSource() == null ? worldIn : phaseContext.getSource();
            }
            PlayerEntity player = null;
            frame.pushCause(source);
            if (source instanceof Player && ((PlatformEntityBridge)(player = (PlayerEntity)source)).bridge$isFakePlayer()) {
                frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
            }
            if (phaseContext.getCreator().isPresent()) {
                phaseContext.getCreator().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            } else if (player instanceof ServerPlayerEntityBridge && (user = ((ServerPlayerEntityBridge)player).bridge$getUser()) != null) {
                frame.addContext(EventContextKeys.CREATOR, user);
            }
            if (!phaseContext.shouldProvideModifiers()) {
                phaseContext.getSource(BlockBridge.class).ifPresent(bridge -> bridge.bridge$getTickFrameModifier().accept(frame, worldIn));
            }
            phaseContext.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            ChangeBlockEvent.Pre event = SpongeEventFactory.createChangeBlockEventPre(frame.getCurrentCause(), locations, (ServerWorld)((Object)worldIn));
            SpongeCommon.postEvent(event);
            ChangeBlockEvent.Pre pre = event;
            return pre;
        }
    }

    public static ChangeBlockEvent callChangeBlockEventModifyLiquidMix(net.minecraft.world.World worldIn, BlockPos pos, net.minecraft.block.BlockState state, @Nullable Object source) {
        BlockState fromState = (BlockState)worldIn.func_180495_p(pos);
        BlockState toState = (BlockState)state;
        boolean pushSource = false;
        if (source == null) {
            pushSource = true;
            source = new SpongeLocatableBlockBuilder().state(fromState).world((ServerWorld)worldIn).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).build();
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (!pushSource) {
                frame.pushCause(source);
            }
            frame.addContext(EventContextKeys.LIQUID_MIX, (ServerWorld)worldIn);
            ServerWorldProperties world = ((ServerWorld)worldIn).getProperties();
            Vector3i position = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            ServerLocation location = ServerLocation.of((ServerWorld)worldIn, position);
            ChangeBlockEvent.Pre event = SpongeEventFactory.createChangeBlockEventPre(frame.getCurrentCause(), Collections.singletonList(location), (ServerWorld)worldIn);
            SpongeCommon.postEvent(event);
            ChangeBlockEvent.Pre pre = event;
            return pre;
        }
    }

    public static ChangeBlockEvent callChangeBlockEventModifyLiquidBreak(net.minecraft.world.World worldIn, BlockPos pos, net.minecraft.block.BlockState targetState) {
        return SpongeCommonEventFactory.callChangeBlockEventModifyLiquidBreak(worldIn, pos, worldIn.func_180495_p(pos), targetState);
    }

    public static ChangeBlockEvent callChangeBlockEventModifyLiquidBreak(net.minecraft.world.World worldIn, BlockPos pos, net.minecraft.block.BlockState fromState, net.minecraft.block.BlockState toState) {
        PhaseContext<?> context = PhaseTracker.getInstance().getPhaseContext();
        net.minecraft.world.World source = context.getSource(LocatableBlock.class).orElse(null);
        if (source == null) {
            source = worldIn;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            frame.addContext(EventContextKeys.LIQUID_BREAK, (ServerWorld)worldIn);
            ServerWorldProperties world = ((ServerWorld)worldIn).getProperties();
            Vector3i position = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            SpongeBlockSnapshot from = SpongeBlockSnapshotBuilder.pooled().blockState(fromState).world((net.minecraft.world.server.ServerWorld)worldIn).position(position).build();
            SpongeBlockSnapshot to = SpongeBlockSnapshotBuilder.pooled().blockState(toState).world((net.minecraft.world.server.ServerWorld)worldIn).position(position).build();
            BlockTransaction transaction = new BlockTransaction(from, to, Operations.LIQUID_SPREAD.get());
            ChangeBlockEvent.All event = SpongeEventFactory.createChangeBlockEventAll(frame.getCurrentCause(), Collections.singletonList(transaction), (ServerWorld)worldIn);
            SpongeCommon.postEvent(event);
            ChangeBlockEvent.All all = event;
            return all;
        }
    }

    @Nullable
    public static NotifyNeighborBlockEvent callNotifyNeighborEvent(World world, BlockPos sourcePos, EnumSet<Direction> notifiedSides) {
        PhaseContext<?> context = PhaseTracker.getInstance().getPhaseContext();
        if (context.isWorldGeneration() || context.isRestoring()) {
            return null;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            BlockState blockstate = (BlockState)((net.minecraft.world.World)world).func_180495_p(sourcePos);
            LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)world).position(sourcePos.func_177958_n(), sourcePos.func_177956_o(), sourcePos.func_177952_p()).state(blockstate).build();
            if (context.getNotifier().isPresent()) {
                context.addCreatorAndNotifierToCauseStack(frame);
            } else {
                ChunkBridge mixinChunk = (ChunkBridge)((net.minecraft.world.server.ServerWorld)world).func_175726_f(sourcePos);
                mixinChunk.bridge$getBlockCreator(sourcePos).ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                mixinChunk.bridge$getBlockNotifier(sourcePos).ifPresent(user -> frame.addContext(EventContextKeys.NOTIFIER, user));
            }
            PhaseTracker.getCauseStackManager().pushCause(locatable);
            EnumMap<org.spongepowered.api.util.Direction, BlockState> neighbors = new EnumMap<org.spongepowered.api.util.Direction, BlockState>(org.spongepowered.api.util.Direction.class);
            for (Direction notificationSide : notifiedSides) {
                BlockPos offset = sourcePos.func_177972_a(notificationSide);
                org.spongepowered.api.util.Direction direction = DirectionFacingProvider.INSTANCE.getKey(notificationSide).get();
                net.minecraft.block.BlockState notificationState = ((net.minecraft.world.server.ServerWorld)world).func_180495_p(offset);
                neighbors.put(direction, (BlockState)notificationState);
            }
            NotifyNeighborBlockEvent event = SpongeEventFactory.createNotifyNeighborBlockEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), neighbors, neighbors);
            SpongeCommon.postEvent(event);
            NotifyNeighborBlockEvent notifyNeighborBlockEvent = event;
            return notifyNeighborBlockEvent;
        }
    }

    public static InteractEntityEvent.Primary callInteractEntityEventPrimary(ServerPlayerEntity player, ItemStack stack, net.minecraft.entity.Entity entity, Hand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext((PlayerEntity)player, stack, hand, null, entity, frame);
            InteractEntityEvent.Primary event = SpongeEventFactory.createInteractEntityEventPrimary(frame.getCurrentCause(), (Entity)entity);
            if (entity instanceof Player && !((ServerWorld)player.func_71121_q()).getProperties().pvp()) {
                event.setCancelled(true);
            }
            SpongeCommon.postEvent(event);
            InteractEntityEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractEntityEvent.Secondary callInteractEntityEventSecondary(ServerPlayerEntity player, ItemStack stack, net.minecraft.entity.Entity entity, Hand hand, @Nullable Vector3d hitVec) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext((PlayerEntity)player, stack, hand, null, entity, frame);
            InteractEntityEvent.Secondary event = hitVec == null ? SpongeEventFactory.createInteractEntityEventSecondaryOn(frame.getCurrentCause(), (Entity)entity) : SpongeEventFactory.createInteractEntityEventSecondaryAt(frame.getCurrentCause(), (Entity)entity, hitVec);
            SpongeCommon.postEvent(event);
            InteractEntityEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static InteractItemEvent.Primary callInteractItemEventPrimary(PlayerEntity player, ItemStack stack, Hand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, stack, hand, null, null, frame);
            InteractItemEvent.Primary event = SpongeEventFactory.createInteractItemEventPrimary(frame.getCurrentCause(), ItemStackUtil.snapshotOf(stack));
            SpongeCommon.postEvent(event);
            InteractItemEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractItemEvent.Secondary callInteractItemEventSecondary(PlayerEntity player, ItemStack stack, Hand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, stack, hand, null, null, frame);
            InteractItemEvent.Secondary event = SpongeEventFactory.createInteractItemEventSecondary(frame.getCurrentCause(), ItemStackUtil.snapshotOf(stack));
            SpongeCommon.postEvent(event);
            InteractItemEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static InteractBlockEvent.Primary callInteractBlockEventPrimary(CPlayerDiggingPacket.Action action, PlayerEntity player, ItemStack heldItem, BlockSnapshot blockSnapshot, Hand hand, @Nullable Direction side) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            InteractBlockEvent.Primary event;
            SpongeCommonEventFactory.applyCommonInteractContext(player, heldItem, hand, blockSnapshot, null, frame);
            org.spongepowered.api.util.Direction direction = side != null ? DirectionFacingProvider.INSTANCE.getKey(side).get() : org.spongepowered.api.util.Direction.NONE;
            switch (action) {
                case START_DESTROY_BLOCK: {
                    event = SpongeEventFactory.createInteractBlockEventPrimaryStart(frame.getCurrentCause(), blockSnapshot, direction);
                    break;
                }
                case ABORT_DESTROY_BLOCK: {
                    event = SpongeEventFactory.createInteractBlockEventPrimaryStop(frame.getCurrentCause(), blockSnapshot, direction);
                    break;
                }
                case STOP_DESTROY_BLOCK: {
                    event = SpongeEventFactory.createInteractBlockEventPrimaryFinish(frame.getCurrentCause(), blockSnapshot, direction);
                    break;
                }
                default: {
                    throw new IllegalStateException("unreachable code");
                }
            }
            SpongeCommon.postEvent(event);
            InteractBlockEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractBlockEvent.Secondary callInteractBlockEventSecondary(PlayerEntity player, ItemStack heldItem, Vector3d hitVec, BlockSnapshot targetBlock, org.spongepowered.api.util.Direction targetSide, Hand hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, heldItem, hand, targetBlock, null, frame);
            InteractBlockEvent.Secondary event = SpongeEventFactory.createInteractBlockEventSecondary(frame.getCurrentCause(), Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, targetBlock, hitVec, targetSide);
            SpongeCommon.postEvent(event);
            InteractBlockEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static void applyCommonInteractContext(PlayerEntity player, ItemStack stack, Hand hand, @Nullable BlockSnapshot targetBlock, @Nullable net.minecraft.entity.Entity entity, CauseStackManager.StackFrame frame) {
        if (((PlatformEntityBridge)player).bridge$isFakePlayer()) {
            frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
        } else {
            frame.pushCause(player);
            frame.addContext(EventContextKeys.CREATOR, ((ServerPlayerEntityBridge)player).bridge$getUser());
            frame.addContext(EventContextKeys.NOTIFIER, ((ServerPlayerEntityBridge)player).bridge$getUser());
        }
        if (!stack.func_190926_b()) {
            frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
        }
        frame.addContext(EventContextKeys.USED_HAND, (HandType)hand);
        if (targetBlock != null) {
            frame.addContext(EventContextKeys.BLOCK_HIT, targetBlock);
        }
        if (entity != null) {
            frame.addContext(EventContextKeys.ENTITY_HIT, (Entity)entity);
        }
    }

    public static void callNaturalMoveEntityEvent(net.minecraft.entity.Entity entity) {
        if (entity.field_70128_L) {
            return;
        }
        double deltaX = entity.field_70142_S - entity.func_226277_ct_();
        double deltaY = entity.field_70137_T - entity.func_226278_cu_();
        double deltaZ = entity.field_70136_U - entity.func_226281_cx_();
        double deltaChange = Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0) + Math.pow(deltaZ, 2.0);
        if (deltaChange < 0.00390625) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.NATURAL);
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (Entity)entity, new Vector3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U), new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()), new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()));
            if (SpongeCommon.postEvent(event)) {
                entity.func_70107_b(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U);
            } else {
                entity.func_70107_b(event.getDestinationPosition().getX(), event.getDestinationPosition().getY(), event.getDestinationPosition().getZ());
            }
        }
    }

    public static void callNaturalRotateEntityEvent(net.minecraft.entity.Entity entity) {
        if (entity.field_70128_L || entity.field_70125_A == entity.field_70127_C && entity.field_70177_z == entity.field_70126_B) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            RotateEntityEvent event = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), (Entity)entity, new Vector3d(entity.field_70127_C, entity.field_70126_B, 0.0f), new Vector3d(entity.field_70125_A, entity.field_70177_z, 0.0f));
            if (SpongeCommon.postEvent(event)) {
                entity.field_70125_A = entity.field_70127_C;
                entity.field_70177_z = entity.field_70126_B;
            } else {
                entity.field_70125_A = (float)event.getToRotation().getX();
                entity.field_70177_z = (float)event.getToRotation().getY();
            }
        }
    }

    public static DestructEntityEvent.Death callDestructEntityEventDeath(LivingEntity entity, @Nullable DamageSource source) {
        return SpongeCommonEventFactory.callDestructEntityEventDeath(entity, source, Audience.empty());
    }

    public static DestructEntityEvent.Death callDestructEntityEventDeath(LivingEntity entity, @Nullable DamageSource source, Audience originalChannel) {
        CreatorTrackedBridge creatorBridge;
        EntityDamageSource damageSource;
        Optional<User> sourceCreator = Optional.empty();
        boolean messageCancelled = false;
        if (source instanceof EntityDamageSource && (damageSource = (EntityDamageSource)source).func_76364_f() instanceof CreatorTrackedBridge && (creatorBridge = (CreatorTrackedBridge)damageSource.func_76364_f()) != null) {
            sourceCreator = creatorBridge.tracked$getCreatorReference();
        }
        Component originalMessage = SpongeAdventure.asAdventure(entity.func_110142_aN().func_151521_b());
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (source != null) {
                frame.pushCause(source);
            }
            sourceCreator.ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            DestructEntityEvent.Death event = SpongeEventFactory.createDestructEntityEventDeath(frame.getCurrentCause(), originalChannel, Optional.of(originalChannel), originalMessage, originalMessage, (Living)entity, entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c), false);
            SpongeCommon.postEvent(event);
            DestructEntityEvent.Death death = event;
            return death;
        }
    }

    public static boolean handleCollideBlockEvent(Block block, net.minecraft.world.World world, BlockPos pos, net.minecraft.block.BlockState state, net.minecraft.entity.Entity entity, org.spongepowered.api.util.Direction direction) {
        if (pos.func_177956_o() <= 0) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            EntityBridge spongeEntity;
            CollideBlockEvent event;
            boolean cancelled;
            frame.pushCause(entity);
            if (entity instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge spongeEntity2 = (CreatorTrackedBridge)entity;
                spongeEntity2.tracked$getCreatorReference().ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            }
            if (!(cancelled = SpongeCommon.postEvent(event = SpongeEventFactory.createCollideBlockEvent(frame.getCurrentCause(), (BlockState)state, ServerLocation.of((ServerWorld)world, VecHelper.toVector3d(pos)), direction))) && !pos.equals((Object)(spongeEntity = (EntityBridge)entity).bridge$getLastCollidedBlockPos())) {
                PhaseContext<?> context = PhaseTracker.getInstance().getPhaseContext();
                context.applyNotifierIfAvailable(notifier -> {
                    ChunkBridge spongeChunk = ((ActiveChunkReferantBridge)entity).bridge$getActiveChunk();
                    if (spongeChunk == null) {
                        spongeChunk = (ChunkBridge)world.func_175726_f(pos);
                    }
                    spongeChunk.bridge$addTrackedBlockPosition(block, pos, (User)notifier, PlayerTracker.Type.NOTIFIER);
                });
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static boolean handleCollideImpactEvent(net.minecraft.entity.Entity projectile, @Nullable ProjectileSource projectileSource, RayTraceResult movingObjectPosition) {
        RayTraceResult.Type movingObjectType = movingObjectPosition.func_216346_c();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(projectile);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, projectileSource == null ? UnknownProjectileSource.UNKNOWN : projectileSource);
            Optional<User> creator = PhaseTracker.getInstance().getPhaseContext().getCreator();
            creator.ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            ServerLocation impactPoint = ServerLocation.of((ServerWorld)projectile.field_70170_p, VecHelper.toVector3d(movingObjectPosition.func_216347_e()));
            boolean cancelled = false;
            if (movingObjectType == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockMovingObjectPosition = (BlockRayTraceResult)movingObjectPosition;
                BlockPos blockPos = blockMovingObjectPosition.func_216350_a();
                if (blockPos.func_177956_o() <= 0) {
                    boolean bl = false;
                    return bl;
                }
                BlockSnapshot targetBlock = ((ServerWorld)projectile.field_70170_p).createSnapshot(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                org.spongepowered.api.util.Direction side = DirectionFacingProvider.INSTANCE.getKey(blockMovingObjectPosition.func_216354_b()).get();
                CollideBlockEvent.Impact event = SpongeEventFactory.createCollideBlockEventImpact(frame.getCurrentCause(), impactPoint, targetBlock.getState(), targetBlock.getLocation().get(), side);
                cancelled = SpongeCommon.postEvent(event);
                if (!cancelled && creator.isPresent()) {
                    BlockPos targetPos = VecHelper.toBlockPos(impactPoint.getBlockPosition());
                    ChunkBridge spongeChunk = (ChunkBridge)projectile.field_70170_p.func_175726_f(targetPos);
                    spongeChunk.bridge$addTrackedBlockPosition((Block)targetBlock.getState().getType(), targetPos, creator.get(), PlayerTracker.Type.NOTIFIER);
                }
            } else if (movingObjectType == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult entityMovingObjectPosition = (EntityRayTraceResult)movingObjectPosition;
                ArrayList<Entity> entityList = new ArrayList<Entity>();
                entityList.add((Entity)entityMovingObjectPosition.func_216348_a());
                CollideEntityEvent.Impact event = SpongeEventFactory.createCollideEntityEventImpact(frame.getCurrentCause(), entityList, impactPoint);
                cancelled = SpongeCommon.postEvent(event);
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static InteractContainerEvent.Close callInteractInventoryCloseEvent(net.minecraft.inventory.container.Container container, ServerPlayerEntity player, ItemStackSnapshot lastCursor, ItemStackSnapshot newCursor, boolean clientSource) {
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
        InteractContainerEvent.Close event = SpongeEventFactory.createInteractContainerEventClose(PhaseTracker.getCauseStackManager().getCurrentCause(), ContainerUtil.fromNative(container), cursorTransaction);
        SpongeCommon.postEvent(event);
        if (event.isCancelled()) {
            if (clientSource && container.func_75139_a(0) != null && !(container instanceof PlayerContainer)) {
                player.field_71070_bA = container;
                Slot slot = container.func_75139_a(0);
                IInventory slotInventory = slot.field_75224_c;
                ITextComponent title = slotInventory instanceof INamedContainerProvider ? ((INamedContainerProvider)slotInventory).func_145748_c_() : null;
                slotInventory.func_174889_b((PlayerEntity)player);
                player.field_71135_a.func_147359_a((IPacket)new SOpenWindowPacket(container.field_75152_c, container.func_216957_a(), title));
                player.func_71120_a(container);
            }
            if (!event.getCursorTransaction().isValid()) {
                PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, event.getCursorTransaction().getOriginal());
            }
        } else {
            TrackedInventoryBridge mixinContainer = (TrackedInventoryBridge)player.field_71070_bA;
            mixinContainer.bridge$getCapturedSlotTransactions().clear();
            mixinContainer.bridge$setCaptureInventory(false);
            if (!event.getCursorTransaction().isValid()) {
                PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, event.getCursorTransaction().getOriginal());
            } else if (event.getCursorTransaction().getCustom().isPresent()) {
                PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, event.getCursorTransaction().getFinal());
            }
            if (!clientSource && player.field_71070_bA != null && player.field_71135_a != null) {
                player.func_71053_j();
            }
        }
        return event;
    }

    public static SetAITargetEvent callSetAttackTargetEvent(@Nullable Entity target, Agent agent) {
        SetAITargetEvent event = SpongeEventFactory.createSetAITargetEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), agent, Optional.ofNullable(target));
        SpongeCommon.postEvent(event);
        return event;
    }

    public static Optional<Explosion> detonateExplosive(ExplosiveBridge explosiveBridge, Explosion.Builder builder) {
        DetonateExplosiveEvent event = SpongeEventFactory.createDetonateExplosiveEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), builder, (Explosive)((Object)explosiveBridge), builder.build());
        if (!Sponge.getEventManager().post(event)) {
            org.spongepowered.api.world.explosion.Explosion explosion = event.getExplosionBuilder().build();
            if (explosion.getRadius() > 0.0f) {
                ((TrackedWorldBridge)((Object)((Explosive)((Object)explosiveBridge)).getWorld())).tracker$triggerInternalExplosion(explosion, e -> GeneralPhase.State.EXPLOSION.createPhaseContext(PhaseTracker.SERVER).explosion((Explosion)e));
            }
            return Optional.of((Explosion)explosion);
        }
        return Optional.empty();
    }

    @Nullable
    public static ItemStack throwDropItemAndConstructEvent(net.minecraft.entity.Entity entity, double posX, double posY, double posZ, ItemStackSnapshot snapshot, List<ItemStackSnapshot> original, CauseStackManager.StackFrame frame) {
        ItemStack item;
        PlayerEntityBridge mixinPlayer = entity instanceof PlayerEntityBridge ? (PlayerEntityBridge)entity : null;
        frame.pushCause(entity);
        DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(frame.getCurrentCause(), (List<ItemStackSnapshot>)ImmutableList.of((Object)snapshot), original);
        SpongeCommon.postEvent(dropEvent);
        if (dropEvent.isCancelled()) {
            if (mixinPlayer != null) {
                mixinPlayer.bridge$shouldRestoreInventory(true);
            }
            return null;
        }
        if (dropEvent.getDroppedItems().isEmpty()) {
            return null;
        }
        frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), ServerLocation.of((ServerWorld)entity.field_70170_p, posX, posY, posZ), new Vector3d(0.0f, 0.0f, 0.0f), EntityTypes.ITEM.get());
        frame.removeContext(EventContextKeys.SPAWN_TYPE);
        SpongeCommon.postEvent(event);
        if (event.isCancelled()) {
            if (mixinPlayer != null) {
                mixinPlayer.bridge$shouldRestoreInventory(true);
            }
            return null;
        }
        ItemStack itemStack = item = event.isCancelled() ? null : ItemStackUtil.fromSnapshotToNative(dropEvent.getDroppedItems().get(0));
        if (item == null) {
            if (mixinPlayer != null) {
                mixinPlayer.bridge$shouldRestoreInventory(true);
            }
            return null;
        }
        return item;
    }

    @Nullable
    public static PlaySoundEvent.Broadcast callPlaySoundBroadcastEvent(CauseStackManager.StackFrame frame, WorldBridge bridge, BlockPos pos, int effectID) {
        float volume;
        DefaultedRegistryReference<SoundType> soundType;
        if (effectID == 1023) {
            soundType = SoundTypes.ENTITY_WITHER_SPAWN;
            volume = 1.0f;
        } else if (effectID == 1028) {
            soundType = SoundTypes.ENTITY_ENDER_DRAGON_DEATH;
            volume = 5.0f;
        } else if (effectID == 1038) {
            soundType = SoundTypes.BLOCK_END_PORTAL_SPAWN;
            volume = 1.0f;
        } else {
            return null;
        }
        ServerLocation location = ServerLocation.of((ServerWorld)((Object)bridge), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        PlaySoundEvent.Broadcast event = SpongeEventFactory.createPlaySoundEventBroadcast(frame.getCurrentCause(), location, Sound.Source.HOSTILE, (SoundType)soundType.get(), 1.0f, volume);
        SpongeCommon.postEvent(event);
        return event;
    }

    public static PlaySoundEvent.Record callPlaySoundRecordEvent(Cause cause, JukeboxTileEntity jukebox, MusicDisc recordType, int data) {
        Jukebox apiJuke = (Jukebox)jukebox;
        ServerLocation location = (ServerLocation)apiJuke.getLocation();
        PlaySoundEvent.Record event = data == 0 ? SpongeEventFactory.createPlaySoundEventRecordStart(cause, apiJuke, location, recordType, Sound.Source.RECORD, recordType.getSound(), 1.0f, 4.0f) : SpongeEventFactory.createPlaySoundEventRecordStop(cause, apiJuke, location, recordType, Sound.Source.RECORD, recordType.getSound(), 1.0f, 4.0f);
        SpongeCommon.postEvent(event);
        return event;
    }

    public static PlaySoundEvent.AtEntity callPlaySoundAtEntityEvent(Cause cause, @Nullable PlayerEntity entity, WorldBridge worldMixin, double x, double y, double z, SoundCategory category, SoundEvent name, float pitch, float volume) {
        ServerLocation location = ServerLocation.of((ServerWorld)((Object)worldMixin), x, y, z);
        PlaySoundEvent.AtEntity event = SpongeEventFactory.createPlaySoundEventAtEntity(cause, location, Optional.ofNullable((ServerPlayer)entity), SpongeAdventure.asAdventure(category), (SoundType)name, pitch, volume);
        SpongeCommon.postEvent(event);
        return event;
    }

    public static PlaySoundEvent.NoteBlock callPlaySoundNoteBlockEvent(Cause cause, World world, BlockPos pos, SoundEvent soundEvent, InstrumentType instrument, NotePitch notePitch, Float pitch) {
        ServerLocation location = ServerLocation.of((ServerWorld)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        PlaySoundEvent.NoteBlock event = SpongeEventFactory.createPlaySoundEventNoteBlock(cause, instrument, location, notePitch, Sound.Source.RECORD, (SoundType)soundEvent, pitch.floatValue(), 3.0f);
        SpongeCommon.postEvent(event);
        return event;
    }
}

