/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import co.aikar.timings.Timing;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Engine;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.GenericEvent;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.container.ContainerBridge;
import org.spongepowered.common.event.AnnotatedEventListener;
import org.spongepowered.common.event.ClassEventListenerFactory;
import org.spongepowered.common.event.EventType;
import org.spongepowered.common.event.ListenerChecker;
import org.spongepowered.common.event.RegisteredListener;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.filter.FilterFactory;
import org.spongepowered.common.event.gen.DefineableClassLoader;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.EventListenerPhaseContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;
import org.spongepowered.common.util.EngineUtil;
import org.spongepowered.common.util.TypeTokenUtil;
import org.spongepowered.configurate.util.Types;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongeEventManager
implements EventManager {
    private static final TypeVariable<?> GENERIC_EVENT_TYPE = GenericEvent.class.getTypeParameters()[0];
    private final Object lock;
    protected final Logger logger;
    private final Multimap<Class<?>, RegisteredListener<?>> handlersByEvent;
    private final Map<ClassLoader, AnnotatedEventListener.Factory> classLoaders;
    private final Set<Object> registeredListeners;
    public final ListenerChecker checker;
    protected final LoadingCache<EventType<?>, RegisteredListener.Cache> handlersCache = Caffeine.newBuilder().initialCapacity(150).build(this::bakeHandlers);

    @Inject
    public SpongeEventManager(Logger logger) {
        this.logger = logger;
        this.lock = new Object();
        this.handlersByEvent = HashMultimap.create();
        this.classLoaders = new IdentityHashMap<ClassLoader, AnnotatedEventListener.Factory>();
        this.registeredListeners = new ReferenceOpenHashSet();
        this.checker = new ListenerChecker(ShouldFire.class);
        try {
            Field innerCache = this.handlersCache.getClass().getSuperclass().getDeclaredField("cache");
            innerCache.setAccessible(true);
            Object innerCacheValue = innerCache.get(this.handlersCache);
            Class<?> innerCacheClass = innerCacheValue.getClass();
            Field cacheData = innerCacheClass.getDeclaredField("data");
            cacheData.setAccessible(true);
            ConcurrentHashMap newBackingData = new ConcurrentHashMap(150, 0.75f, 1);
            cacheData.set(innerCacheValue, newBackingData);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            this.logger.warn("Failed to set event cache backing array, type was " + this.handlersCache.getClass().getName());
            this.logger.warn("  Caused by: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Event> RegisteredListener.Cache bakeHandlers(EventType<T> eventType) {
        ArrayList handlers = new ArrayList();
        Stream<Class> types = Types.allSuperTypesAndInterfaces(eventType.getType()).map(GenericTypeReflector::erase).filter(Event.class::isAssignableFrom);
        Object object = this.lock;
        synchronized (object) {
            Iterator it = types.iterator();
            while (it.hasNext()) {
                Class type = (Class)it.next();
                Collection listeners = this.handlersByEvent.get((Object)type);
                if (GenericEvent.class.isAssignableFrom(type)) {
                    Type genericType = Objects.requireNonNull(eventType.getGenericType());
                    for (RegisteredListener listener : listeners) {
                        Type genericType1 = Objects.requireNonNull(listener.getEventType().getGenericType());
                        if (!TypeTokenUtil.isAssignable(genericType, genericType1)) continue;
                        handlers.add(listener);
                    }
                    continue;
                }
                handlers.addAll(listeners);
            }
        }
        Collections.sort(handlers);
        return new RegisteredListener.Cache(handlers);
    }

    @Nullable
    private static String getHandlerErrorOrNull(Method method) {
        Class<?>[] parameters;
        int modifiers = method.getModifiers();
        ArrayList<String> errors = new ArrayList<String>();
        if (Modifier.isStatic(modifiers)) {
            errors.add("method must not be static");
        }
        if (!Modifier.isPublic(modifiers)) {
            errors.add("method must be public");
        }
        if (Modifier.isAbstract(modifiers)) {
            errors.add("method must not be abstract");
        }
        if (method.getDeclaringClass().isInterface()) {
            errors.add("interfaces cannot declare listeners");
        }
        if (method.getReturnType() != Void.TYPE) {
            errors.add("method must return void");
        }
        if ((parameters = method.getParameterTypes()).length == 0 || !Event.class.isAssignableFrom(parameters[0])) {
            errors.add("method must have an Event as its first parameter");
        }
        if (errors.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)", ", errors);
    }

    private void register(RegisteredListener<? extends Event> handler) {
        this.register(Collections.singletonList(handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(List<RegisteredListener<? extends Event>> handlers) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            for (RegisteredListener<? extends Event> handler : handlers) {
                Class<? extends Event> raw = handler.getEventType().getType();
                if (!this.handlersByEvent.put(raw, handler)) continue;
                changed = true;
                this.checker.registerListenerFor(raw);
            }
        }
        if (changed) {
            this.handlersCache.invalidateAll();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerListener(PluginContainer plugin, Object listenerObject) {
        void var8_11;
        String error;
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        Preconditions.checkNotNull((Object)listenerObject, (Object)"listener");
        if (this.registeredListeners.contains(listenerObject)) {
            this.logger.warn("Plugin {} attempted to register an already registered listener ({})", (Object)plugin.getMetadata().getId(), (Object)listenerObject.getClass().getName());
            Thread.dumpStack();
            return;
        }
        ArrayList<RegisteredListener<? extends Event>> handlers = new ArrayList<RegisteredListener<? extends Event>>();
        HashMap<Method, String> methodErrors = new HashMap<Method, String>();
        Class<?> handle = listenerObject.getClass();
        ClassLoader handleLoader = handle.getClassLoader();
        AnnotatedEventListener.Factory handlerFactory = this.classLoaders.get(handleLoader);
        if (handlerFactory == null) {
            DefineableClassLoader defineableClassLoader = new DefineableClassLoader(handleLoader);
            handlerFactory = new ClassEventListenerFactory("org.spongepowered.common.event.listener", new FilterFactory("org.spongepowered.common.event.filters", defineableClassLoader), defineableClassLoader);
            this.classLoaders.put(handleLoader, handlerFactory);
        }
        for (Method method : handle.getMethods()) {
            Listener listener = method.getAnnotation(Listener.class);
            if (listener == null) continue;
            error = SpongeEventManager.getHandlerErrorOrNull(method);
            if (error == null) {
                AnnotatedEventListener handler;
                Type eventType = method.getGenericParameterTypes()[0];
                try {
                    handler = handlerFactory.create(listenerObject, method);
                }
                catch (Exception e) {
                    this.logger.error("Failed to create handler for {} on {}", (Object)method, (Object)handle, (Object)e);
                    continue;
                }
                handlers.add(SpongeEventManager.createRegistration(plugin, eventType, listener, handler));
                continue;
            }
            methodErrors.put(method, error);
        }
        Class<?> clazz = handle;
        while (var8_11 != Object.class) {
            for (Method method : var8_11.getDeclaredMethods()) {
                if (method.getAnnotation(Listener.class) == null || methodErrors.containsKey(method) || (error = SpongeEventManager.getHandlerErrorOrNull(method)) == null) continue;
                methodErrors.put(method, error);
            }
            Class clazz2 = var8_11.getSuperclass();
        }
        for (Map.Entry method : methodErrors.entrySet()) {
            this.logger.warn("Invalid listener method {} in {}: {}", method.getKey(), (Object)((Method)method.getKey()).getDeclaringClass().getName(), method.getValue());
        }
        this.registeredListeners.add(listenerObject);
        this.register(handlers);
    }

    private static <T extends Event> RegisteredListener<T> createRegistration(PluginContainer plugin, Type eventClass, Listener listener, EventListener<? super T> handler) {
        return SpongeEventManager.createRegistration(plugin, eventClass, listener.order(), listener.beforeModifications(), handler);
    }

    private static <T extends Event> RegisteredListener<T> createRegistration(PluginContainer plugin, Type eventType, Order order, boolean beforeModifications, EventListener<? super T> handler) {
        Type genericType = null;
        Class<?> erased = GenericTypeReflector.erase(eventType);
        if (GenericEvent.class.isAssignableFrom(erased)) {
            genericType = TypeTokenUtil.typeArgumentFromSupertype(eventType, GenericEvent.class, 0);
        }
        return new RegisteredListener<T>(plugin, new EventType(erased, genericType), order, handler, beforeModifications);
    }

    @Override
    public void registerListeners(PluginContainer plugin, Object listener) {
        this.registerListener(plugin, listener);
    }

    @Override
    public <T extends Event> void registerListener(PluginContainer plugin, Class<T> eventClass, EventListener<? super T> listener) {
        this.registerListener(plugin, eventClass, Order.DEFAULT, listener);
    }

    @Override
    public <T extends Event> void registerListener(PluginContainer plugin, TypeToken<T> eventType, EventListener<? super T> listener) {
        this.registerListener(plugin, eventType, Order.DEFAULT, listener);
    }

    @Override
    public <T extends Event> void registerListener(PluginContainer plugin, Class<T> eventClass, Order order, EventListener<? super T> listener) {
        this.registerListener(plugin, eventClass, Order.DEFAULT, false, listener);
    }

    @Override
    public <T extends Event> void registerListener(PluginContainer plugin, TypeToken<T> eventType, Order order, EventListener<? super T> listener) {
        this.registerListener(plugin, eventType, Order.DEFAULT, false, listener);
    }

    @Override
    public <T extends Event> void registerListener(PluginContainer plugin, Class<T> eventClass, Order order, boolean beforeModifications, EventListener<? super T> listener) {
        this.registerListener(plugin, TypeToken.get(eventClass), Order.DEFAULT, false, listener);
    }

    @Override
    public <T extends Event> void registerListener(PluginContainer plugin, TypeToken<T> eventType, Order order, boolean beforeModifications, EventListener<? super T> listener) {
        this.register(SpongeEventManager.createRegistration(plugin, eventType.getType(), order, beforeModifications, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(Predicate<RegisteredListener<?>> unregister) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            Iterator itr = this.handlersByEvent.values().iterator();
            while (itr.hasNext()) {
                RegisteredListener handler = (RegisteredListener)itr.next();
                if (!unregister.test(handler)) continue;
                itr.remove();
                changed = true;
                this.checker.unregisterListenerFor(handler.getEventType().getType());
                this.registeredListeners.remove(handler.getHandle());
            }
        }
        if (changed) {
            this.handlersCache.invalidateAll();
        }
    }

    @Override
    public void unregisterListeners(Object listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.unregister(handler -> listener.equals(handler.getHandle()));
    }

    @Override
    public void unregisterPluginListeners(PluginContainer plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        this.unregister(handler -> plugin.equals(handler.getPlugin()));
    }

    protected RegisteredListener.Cache getHandlerCache(Event event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        Class<?> eventClass = event.getClass();
        EventType eventType = event instanceof GenericEvent ? new EventType(eventClass, (Type)Preconditions.checkNotNull((Object)((GenericEvent)event).getParamType().getType())) : new EventType(eventClass, null);
        return (RegisteredListener.Cache)this.handlersCache.get(eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean post(Event event, List<RegisteredListener<?>> handlers) {
        Engine engine = EngineUtil.determineEngine();
        if (engine == null) {
            for (RegisteredListener<?> handler : handlers) {
                try {
                    if (event instanceof AbstractEvent) {
                        ((AbstractEvent)event).currentOrder = handler.getOrder();
                    }
                    SpongeCommon.setActivePlugin(handler.getPlugin());
                    handler.handle(event);
                }
                catch (Throwable e) {
                    SpongeCommon.getLogger().error("Could not pass {} to {}", (Object)event.getClass().getSimpleName(), (Object)handler.getPlugin(), (Object)e);
                }
                finally {
                    SpongeCommon.setActivePlugin(null);
                }
            }
            if (event instanceof AbstractEvent) {
                ((AbstractEvent)event).currentOrder = null;
            }
            return event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled();
        }
        TimingsManager.PLUGIN_EVENT_HANDLER.startTimingIfSync();
        for (RegisteredListener<?> handler : handlers) {
            try {
                CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();
                Throwable throwable = null;
                try {
                    EventListenerPhaseContext context = this.createPluginContext(handler);
                    Throwable throwable2 = null;
                    try {
                        Timing timings = handler.getTimingsHandler();
                        Throwable throwable3 = null;
                        try {
                            frame.pushCause(handler.getPlugin());
                            if (context != null) {
                                context.buildAndSwitch();
                            }
                            timings.startTimingIfSync();
                            if (event instanceof AbstractEvent) {
                                ((AbstractEvent)event).currentOrder = handler.getOrder();
                            }
                            SpongeCommon.setActivePlugin(handler.getPlugin());
                            handler.handle(event);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (timings == null) continue;
                            if (throwable3 != null) {
                                try {
                                    timings.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            timings.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (context == null) continue;
                        if (throwable2 != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        context.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (frame == null) continue;
                    if (throwable != null) {
                        try {
                            frame.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    frame.close();
                }
            }
            catch (Throwable e) {
                this.logger.error("Could not pass {} to {}", (Object)event.getClass().getSimpleName(), (Object)handler.getPlugin().getMetadata().getId(), (Object)e);
            }
            finally {
                SpongeCommon.setActivePlugin(null);
            }
        }
        if (event instanceof AbstractEvent) {
            ((AbstractEvent)event).currentOrder = null;
        }
        return event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled();
    }

    @Nullable
    private EventListenerPhaseContext createPluginContext(RegisteredListener<?> handler) {
        if (PhaseTracker.getInstance().getPhaseContext().allowsEventListener()) {
            return (EventListenerPhaseContext)PluginPhase.Listener.GENERAL_LISTENER.createPhaseContext(PhaseTracker.getInstance()).source(handler.getPlugin());
        }
        return null;
    }

    @Override
    public boolean post(Event event) {
        try {
            if (event instanceof InteractContainerEvent) {
                ((ContainerBridge)((Object)((InteractContainerEvent)event).getContainer())).bridge$setInUse(true);
            }
            boolean bl = this.post(event, this.getHandlerCache(event).getListeners());
            return bl;
        }
        finally {
            if (event instanceof InteractContainerEvent) {
                ((ContainerBridge)((Object)((InteractContainerEvent)event).getContainer())).bridge$setInUse(false);
            }
        }
    }

    public boolean post(Event event, PluginContainer plugin) {
        List<RegisteredListener<?>> listeners = this.getHandlerCache(event).getListeners();
        List<RegisteredListener<?>> pluginListeners = listeners.stream().filter(l -> l.getPlugin() == plugin).collect(Collectors.toList());
        return this.post(event, pluginListeners);
    }
}

