/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.lifecycle;

import io.leangen.geantyref.TypeToken;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Game;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.lifecycle.ProvideServiceEvent;
import org.spongepowered.common.event.lifecycle.AbstractLifecycleEvent;

public abstract class AbstractProvideServiceEventImpl<T>
extends AbstractLifecycleEvent.GenericImpl<T>
implements ProvideServiceEvent<T> {
    private @Nullable Supplier<T> serviceFactory;

    public AbstractProvideServiceEventImpl(Cause cause, Game game, TypeToken<T> token) {
        super(cause, game, token);
    }

    @Override
    public void suggest(@NonNull Supplier<T> serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public @Nullable Supplier<T> getSuggestion() {
        return this.serviceFactory;
    }

    public void clear() {
        this.serviceFactory = null;
    }

    public static final class EngineScopedImpl<T>
    extends AbstractProvideServiceEventImpl<T>
    implements ProvideServiceEvent.EngineScoped<T> {
        private final Engine engine;

        public EngineScopedImpl(Cause cause, Game game, TypeToken<T> token, Engine engine) {
            super(cause, game, token);
            this.engine = engine;
        }

        @Override
        public Engine getEngine() {
            return this.engine;
        }

        public String toString() {
            return new StringJoiner(", ", EngineScopedImpl.class.getSimpleName() + "[", "]").add("cause=" + this.cause).add("token=" + this.token).add("engine=" + this.token).toString();
        }
    }

    public static final class GameScopedImpl<T>
    extends AbstractProvideServiceEventImpl<T>
    implements ProvideServiceEvent.GameScoped<T> {
        public GameScopedImpl(Cause cause, Game game, TypeToken<T> token) {
            super(cause, game, token);
        }

        public String toString() {
            return new StringJoiner(", ", GameScopedImpl.class.getSimpleName() + "[", "]").add("cause=" + this.cause).add("token=" + this.token).add("game=" + this.game).toString();
        }
    }
}

