/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class BlockChangeFlagManager {
    private final Map<String, SpongeBlockChangeFlag> flags = new LinkedHashMap<String, SpongeBlockChangeFlag>();
    private final Int2ObjectMap<SpongeBlockChangeFlag> maskedFlags = new Int2ObjectLinkedOpenHashMap(70);
    private static BlockChangeFlagManager INSTANCE = new BlockChangeFlagManager();
    private static final SpongeBlockChangeFlag PHYSICS_OBSERVER = new SpongeBlockChangeFlag("PHYSICS_OBSERVER", 2);
    private static final SpongeBlockChangeFlag DEFAULT = new SpongeBlockChangeFlag("PHYSICS_OBSERVER", 3);

    public static BlockChangeFlagManager getInstance() {
        return INSTANCE;
    }

    public static SpongeBlockChangeFlag fromNativeInt(int flag) {
        if (flag == 3) {
            return DEFAULT;
        }
        if (flag == 2) {
            return PHYSICS_OBSERVER;
        }
        BlockChangeFlagManager instance = BlockChangeFlagManager.getInstance();
        SpongeBlockChangeFlag spongeBlockChangeFlag = (SpongeBlockChangeFlag)instance.maskedFlags.get(flag);
        if (spongeBlockChangeFlag != null) {
            return spongeBlockChangeFlag;
        }
        SpongeBlockChangeFlag newFlag = new SpongeBlockChangeFlag(BlockChangeFlagManager.getFlagName(flag).toString(), flag);
        instance.register(newFlag);
        return newFlag;
    }

    public static SpongeBlockChangeFlag andNotifyClients(BlockChangeFlag flag) {
        int rawFlag = ((SpongeBlockChangeFlag)flag).getRawFlag();
        if ((rawFlag & 2) != 0) {
            return (SpongeBlockChangeFlag)flag;
        }
        return BlockChangeFlagManager.fromNativeInt(rawFlag & 0xFFFFFFFD);
    }

    private BlockChangeFlagManager() {
        this.registerDefaults();
    }

    public void registerDefaults() {
        for (int i = 0; i < 128; ++i) {
            StringJoiner builder = BlockChangeFlagManager.getFlagName(i);
            if (186 == i) {
                this.register(new SpongeBlockChangeFlag("NONE".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (3 == i) {
                this.register(new SpongeBlockChangeFlag("ALL".toLowerCase(Locale.ENGLISH), i));
                this.register(new SpongeBlockChangeFlag("NEIGHBOR_PHYSICS_OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (179 == i) {
                this.register(new SpongeBlockChangeFlag("NEIGHBOR".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (18 == i) {
                this.register(new SpongeBlockChangeFlag("PHYSICS".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (162 == i) {
                this.register(new SpongeBlockChangeFlag("OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (19 == i) {
                this.register(new SpongeBlockChangeFlag("NEIGHBOR_PHYSICS".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (131 == i) {
                this.register(new SpongeBlockChangeFlag("NEIGHBOR_OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            if (2 == i) {
                this.register(new SpongeBlockChangeFlag("PHYSICS_OBSERVER".toLowerCase(Locale.ENGLISH), i));
                continue;
            }
            this.register(new SpongeBlockChangeFlag(builder.toString().toLowerCase(Locale.ENGLISH), i));
        }
    }

    private static @NonNull StringJoiner getFlagName(int i) {
        StringJoiner builder = new StringJoiner("|");
        if ((i & 1) != 0) {
            builder.add(Flag.NOTIFY_NEIGHBOR.name);
        }
        if ((i & 2) != 0) {
            builder.add(Flag.NOTIFY_CLIENTS.name);
        }
        if ((i & 4) != 0) {
            builder.add(Flag.IGNORE_RENDER.name);
        }
        if ((i & 8) != 0) {
            builder.add(Flag.FORCE_RE_RENDER.name);
        }
        if ((i & 0x10) == 0) {
            builder.add(Flag.DENY_NEIGHBOR_SHAPE_UPDATE.name);
        }
        if ((i & 0x80) == 0) {
            builder.add(Flag.IGNORE_PHYSICS.name);
        }
        return builder;
    }

    private void register(SpongeBlockChangeFlag flag) {
        this.maskedFlags.put(flag.getRawFlag(), (Object)flag);
        this.flags.put(flag.getName(), flag);
    }

    public Collection<SpongeBlockChangeFlag> getValues() {
        return Collections.unmodifiableCollection(this.flags.values());
    }

    public static final class Factory
    implements BlockChangeFlag.Factory {
        private @Nullable BlockChangeFlag none;

        @Override
        public BlockChangeFlag empty() {
            if (this.none == null) {
                this.none = (BlockChangeFlag)BlockChangeFlagManager.getInstance().maskedFlags.get(0);
            }
            return this.none;
        }
    }

    public static final class Flag {
        public static final Flag NOTIFY_NEIGHBOR = new Flag("NEIGHBOR", 1);
        public static final Flag NOTIFY_CLIENTS = new Flag("NOTIFY_CLIENTS", 2);
        public static final Flag IGNORE_RENDER = new Flag("IGNORE_RENDER", 4);
        public static final Flag FORCE_RE_RENDER = new Flag("FORCE_RE_RENDER", 8);
        public static final Flag DENY_NEIGHBOR_SHAPE_UPDATE = new Flag("NEIGHBOR_SHAPE_UPDATE", 16);
        public static final Flag IGNORE_PHYSICS = new Flag("PHYSICS", 128);
        private static final ImmutableList<Flag> flags = ImmutableList.of((Object)NOTIFY_NEIGHBOR, (Object)NOTIFY_CLIENTS, (Object)IGNORE_RENDER, (Object)FORCE_RE_RENDER, (Object)DENY_NEIGHBOR_SHAPE_UPDATE, (Object)IGNORE_PHYSICS);
        private final String name;
        private final int mask;

        public static Collection<Flag> values() {
            return flags;
        }

        private Flag(String name, int mask) {
            this.name = name;
            this.mask = mask;
        }
    }
}

