/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.common.PhaseTrackerCategory;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseStack;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.plugin.PluginContainer;

public final class PhasePrinter {
    private static final boolean IN_DEVELOPMENT = ((Launch)Launch.getInstance()).isDeveloperEnvironment();
    static final String ASYNC_BLOCK_CHANGE_MESSAGE = "Sponge adapts the vanilla handling of block changes to power events and plugins such that it follows the known fact that block changes MUST occur on the server thread (even on clients, this exists as the InternalServer thread). It is NOT possible to change this fact and must be reported to the offending mod for async issues.";
    public static final String ASYNC_TRACKER_ACCESS = "Sponge adapts the vanilla handling of various processes, such as setting a block or spawning an entity. Sponge is designed around the concept that Minecraft is primarily performing these operations on the \"server thread\". Because of this Sponge is safeguarding common access to the PhaseTracker as the entrypoint for performing these sort of changes.";
    private static boolean hasPrintedEmptyOnce = false;
    private static boolean hasPrintedAboutRunnawayPhases = false;
    private static boolean hasPrintedAsyncEntities = false;
    private static int printRunawayCount = 0;
    private static final List<IPhaseState<@NonNull ?>> printedExceptionsForBlocks = new ArrayList();
    private static final List<IPhaseState<@NonNull ?>> printedExceptionsForEntities = new ArrayList();
    private static final List<Tuple<IPhaseState<@NonNull ?>, IPhaseState<@NonNull ?>>> completedIncorrectStates = new ArrayList();
    private static final List<IPhaseState<@NonNull ?>> printedExceptionsForState = new ArrayList();
    static final Set<IPhaseState<@NonNull ?>> printedExceptionsForUnprocessedState = new HashSet();
    static final Set<IPhaseState<@NonNull ?>> printedExceptionForMaximumProcessDepth = new HashSet();
    static final PhaseStack EMPTY = new PhaseStack();
    public static final BiConsumer<PrettyPrinter, PhaseContext<@NonNull ?>> CONTEXT_PRINTER = (printer, context) -> context.printCustom((PrettyPrinter)printer, 4);
    static final BiConsumer<PrettyPrinter, PhaseContext<@NonNull ?>> PHASE_PRINTER = (printer, context) -> {
        printer.add("  - Phase: %s", context.state);
        printer.add("    Context:");
        context.printCustom((PrettyPrinter)printer, 4);
        context.printTrace((PrettyPrinter)printer);
    };

    static void printNullSourceForBlock(net.minecraft.world.server.ServerWorld worldServer, BlockPos pos, Block blockIn, BlockPos otherPos, NullPointerException e) {
        PhaseTracker instance = PhaseTracker.getInstance();
        PrettyPrinter printer = new PrettyPrinter(60).add("Null Source Block from Unknown Source!").centre().hr().addWrapped("Hey, Sponge is saving the game from crashing or spamming because some source put up a \"null\" Block as it's source for sending out a neighbor notification. This is usually unsupported as the game will silently ignore some nulls by performing \"==\" checks instead of calling methods, potentially making an NPE. Because Sponge uses the source block to build information for tracking, Sponge has to save the game from crashing by reporting this issue. Because the source is unknown, it's recommended to report this issue to SpongeCommon's issue tracker on GitHub. Please provide the following information: ", new Object[0]).add().add(" %s : %s", "Source position", pos).add(" %s : %s", "World", ((ServerWorld)worldServer).getKey()).add(" %s : %s", "Source Block Recovered", blockIn).add(" %s : %s", "Notified Position", otherPos).add();
        PhasePrinter.printPhaseStackWithException(instance.stack, printer, e);
        printer.log(SpongeCommon.getLogger(), Level.WARN);
    }

    static void printUnexpectedBlockChange(ServerWorldBridge mixinWorld, BlockPos pos, BlockState currentState, BlockState newState) {
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Unexpected World Change Detected!").centre().hr().add("Sponge's tracking system is very dependent on knowing when\na change to any world takes place, however there are chances\nwhere Sponge does not know of changes that mods may perform.\nIn cases like this, it is best to report to Sponge to get this\nchange tracked correctly and accurately.").hr().add().add("%s : %s", "World", mixinWorld).add("%s : %s", "Position", pos).add("%s : %s", "Current State", currentState).add("%s : %s", "New State", newState).add().add("StackTrace:").add(new Exception());
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
    }

    static void printExceptionSpawningEntity(PhaseTracker tracker, PhaseContext<@NonNull ?> context, Throwable e) {
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose && !printedExceptionsForEntities.isEmpty() && printedExceptionsForEntities.contains(context.state)) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture or spawn an Entity!").centre().hr();
        PhasePrinter.printPhasestack(tracker, context, e, printer);
        printer.log(SpongeCommon.getLogger(), Level.ERROR);
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose) {
            printedExceptionsForEntities.add(context.state);
        }
    }

    static void printNullSourceBlockWithTile(BlockPos pos, Block blockIn, BlockPos otherPos, ResourceLocation type, boolean useTile, NullPointerException e) {
        PhaseTracker instance = PhaseTracker.getInstance();
        PrettyPrinter printer = new PrettyPrinter(60).add("Null Source Block on TileEntity!").centre().hr().addWrapped("Hey, Sponge is saving the game from crashing because a TileEntity is sending out a 'null' Block as it's source (more likely) and attempting to perform a neighbor notification with it. Because this is guaranteed to lead to a crash or a spam of reports, Sponge is going ahead and fixing the issue. The offending Tile is " + type.toString(), new Object[0]).add().add("%s : %s", "Source position", pos).add("%s : %s", "Source TileEntity", type).add("%s : %s", "Recovered using TileEntity as Source", useTile).add("%s : %s", "Source Block Recovered", blockIn).add("%s : %s", "Notified Position", otherPos);
        PhasePrinter.printPhaseStackWithException(instance.stack, printer, e);
        printer.log(SpongeCommon.getLogger(), Level.WARN);
    }

    static void printNullSourceBlockNeighborNotificationWithNoTileSource(BlockPos pos, Block blockIn, BlockPos otherPos, NullPointerException e) {
        PhaseTracker instance = PhaseTracker.getInstance();
        PrettyPrinter printer = new PrettyPrinter(60).add("Null Source Block on TileEntity!").centre().hr().addWrapped("Hey, Sponge is saving the game from crashing because a TileEntity is sending out a 'null' Block as it's source (more likely) and attempting to perform a neighbor notification with it. Because this is guaranteed to lead to a crash or a spam of reports, Sponge is going ahead and fixing the issue. The offending Tile is unknown, so we don't have any way to configure a reporting for you", new Object[0]).add().add("%s : %s", "Source position", pos).add("%s : %s", "Source TileEntity", "UNKNOWN").add("%s : %s", "Recovered using TileEntity as Source", "false").add("%s : %s", "Source Block Recovered", blockIn).add("%s : %s", "Notified Position", otherPos);
        PhasePrinter.printPhaseStackWithException(instance.stack, printer, e);
        printer.log(SpongeCommon.getLogger(), Level.WARN);
    }

    static void printPhaseStackWithException(PhaseStack stack, PrettyPrinter printer, Throwable e) {
        stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
        printer.add().add(" %s :", "StackTrace").add(e).add();
        PhasePrinter.generateVersionInfo(printer);
    }

    static void printBlockTrackingException(PhaseTracker tracker, PhaseContext<@NonNull ?> phaseData, IPhaseState<@NonNull ?> phaseState, Throwable e) {
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose && !printedExceptionsForBlocks.isEmpty() && printedExceptionsForBlocks.contains(phaseState)) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture a block change!").centre().hr();
        PhasePrinter.printPhasestack(tracker, phaseData, e, printer);
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose) {
            printedExceptionsForBlocks.add(phaseState);
        }
    }

    static void printPhasestack(PhaseTracker tracker, PhaseContext<@NonNull ?> phaseData, Throwable e, PrettyPrinter printer) {
        printer.addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, phaseData);
        printer.addWrapped(60, "%s :", "Phases remaining");
        tracker.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
        printer.add("Stacktrace:");
        printer.add(e);
    }

    public static void printMessageWithCaughtException(PhaseTracker tracker, String header, String subheader, Throwable e) {
        PhasePrinter.printMessageWithCaughtException(tracker.stack, header, subheader, tracker.getPhaseContext().state, tracker.getPhaseContext(), e);
    }

    public static void printMessageWithCaughtException(PhaseTracker tracker, String header, String subHeader, IPhaseState<@NonNull ?> state, PhaseContext<@NonNull ?> context, @Nullable Throwable t) {
        PhasePrinter.printMessageWithCaughtException(tracker.stack, header, subHeader, state, context, t);
    }

    public static void printMessageWithCaughtException(PhaseStack stack, String header, String subHeader, IPhaseState<@NonNull ?> state, PhaseContext<@NonNull ?> context, @Nullable Throwable t) {
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add(header).centre().hr().add("%s %s", subHeader, state).addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
        if (t != null) {
            printer.add("Stacktrace:").add(t);
            if (t.getCause() != null) {
                printer.add(t.getCause());
            }
        }
        printer.add();
        PhasePrinter.generateVersionInfo(printer);
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
    }

    static void printExceptionFromPhase(PhaseStack stack, Throwable e, PhaseContext<@NonNull ?> context) {
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose && !printedExceptionsForState.isEmpty()) {
            for (IPhaseState<?> iPhaseState : printedExceptionsForState) {
                if (context.state != iPhaseState) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception occurred during a PhaseState").centre().hr().add("Sponge's tracking system makes a best effort to not throw exceptions randomly but sometimes it is inevitable. In most cases, something else triggered this exception and Sponge prevented a crash by catching it. The following stacktrace can be used to help pinpoint the cause.").hr().add("The PhaseState having an exception: %s", context.state).add("The PhaseContext:");
        context.printCustom(printer, 4);
        PhasePrinter.printPhaseStackWithException(stack, printer, e);
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose) {
            printedExceptionsForState.add(context.state);
        }
    }

    static void printUnprocessedPhaseContextObjects(PhaseStack stack, IPhaseState<@NonNull ?> state, PhaseContext<@NonNull ?> context) {
        PhasePrinter.printMessageWithCaughtException(stack, "Failed to process all PhaseContext captured!", "During the processing of a phase, certain objects were captured in a PhaseContext. All of them should have been removed from the PhaseContext by this point", state, context, null);
    }

    static void printRunawayPhase(PhaseStack stack, IPhaseState<@NonNull ?> state, PhaseContext<@NonNull ?> context) {
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose && !hasPrintedAboutRunnawayPhases) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Switching Phase").centre().hr();
        printer.addWrapped(60, "Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!!", new Object[0]);
        printer.add("  %s : %s", "Entering State", state);
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        PhasePrinter.printPhaseStackWithException(stack, printer, new Exception("RunawayPhase"));
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose && printRunawayCount++ > SpongeConfigs.getCommon().get().phaseTracker.maximumPrintedRunawayCounts) {
            hasPrintedAboutRunnawayPhases = true;
        }
    }

    static void printRunnawayPhaseCompletion(PhaseStack stack, IPhaseState<@NonNull ?> state) {
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose && !hasPrintedAboutRunnawayPhases) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Completing Phase").centre().hr();
        printer.add("Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!! Sponge will stop printingafter three more times to avoid generating extra logs");
        printer.add();
        printer.add("%s : %s", "Completing phase", state);
        printer.add(" Phases Remaining:");
        PhasePrinter.printPhaseStackWithException(stack, printer, new Exception("RunawayPhase"));
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose && printRunawayCount++ > 3) {
            hasPrintedAboutRunnawayPhases = true;
        }
    }

    static void generateVersionInfo(PrettyPrinter printer) {
        for (PluginContainer pluginContainer : ((Launch)Launch.getInstance()).getLauncherPlugins()) {
            printer.add("%s : %s", pluginContainer.getMetadata().getName().get(), pluginContainer.getMetadata().getVersion());
        }
    }

    static void printIncorrectPhaseCompletion(PhaseStack stack, IPhaseState<@NonNull ?> prevState, IPhaseState<@NonNull ?> state) {
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose && !completedIncorrectStates.isEmpty()) {
            for (Tuple<IPhaseState<?>, IPhaseState<?>> tuple : completedIncorrectStates) {
                if (!tuple.getFirst().equals(prevState) || !tuple.getSecond().equals(state)) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Completing incorrect phase").centre().hr().add("Sponge's tracking system is very dependent on knowing when a change to any world takes place, however, we are attempting to complete a \"phase\" other than the one we most recently entered. This is an error usually on Sponge's part, so a report is required on the issue tracker on GitHub.").hr().add("Expected to exit phase: %s", prevState).add("But instead found phase: %s", state).add("StackTrace:").add(new Exception());
        printer.add(" Phases Remaining:");
        PhasePrinter.printPhaseStackWithException(stack, printer, new Exception("Incorrect Phase Completion"));
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose) {
            completedIncorrectStates.add(new Tuple(prevState, state));
        }
    }

    static void printEmptyStackOnCompletion(PhaseContext<@NonNull ?> context) {
        if (hasPrintedEmptyOnce) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Unexpectedly Completing An Empty Stack").centre().hr().addWrapped(60, "Sponge's tracking system is very dependent on knowing when a change to any world takes place, however, we have been told to complete a \"phase\" without having entered any phases. This is an error usually on Sponge's part, so a report is required on the issue tracker on GitHub.", new Object[0]).hr().add("StackTrace:").add(new Exception()).add("Phase being completed:");
        PHASE_PRINTER.accept(printer, context);
        printer.add();
        PhasePrinter.generateVersionInfo(printer);
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose) {
            hasPrintedEmptyOnce = true;
        }
    }

    static void printNonEmptyStack(PhaseStack stack) {
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Phases Not Completed").centre().hr();
        printer.add("One or more phases were started but were not properly completed by the end of the server tick. They will be automatically closed, but this is an issue that should be reported to Sponge.");
        stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseContext<?>)data));
        printer.add();
        PhasePrinter.generateVersionInfo(printer);
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
    }

    static void printAsyncBlockChange(TrackedWorldBridge mixinWorld, BlockPos pos, BlockState newState) {
        new PrettyPrinter(60).add("Illegal Async Block Change").centre().hr().addWrapped(ASYNC_BLOCK_CHANGE_MESSAGE, new Object[0]).add().add(" %s : %s", "World", mixinWorld).add(" %s : %d, %d, %d", "Block Pos", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).add(" %s : %s", "BlockState", newState).add().addWrapped("Sponge is not going to allow this block change to take place as doing so can lead to further issues, not just with sponge or plugins, but other mods as well.", new Object[0]).add().add(new Exception("Async Block Change Detected")).log(SpongeCommon.getLogger(), Level.ERROR);
    }

    static void printAsyncEntitySpawn(org.spongepowered.api.entity.Entity entity) {
        if (!SpongeConfigs.getCommon().get().phaseTracker.captureAsyncSpawningEntities) {
            if (!SpongeConfigs.getCommon().get().phaseTracker.verbose) {
                return;
            }
            if (!SpongeConfigs.getCommon().get().phaseTracker.verboseErrors && hasPrintedAsyncEntities) {
                return;
            }
            PrettyPrinter printer = new PrettyPrinter(60).add("Async Entity Spawn Warning").centre().hr().add("An entity was attempting to spawn off the \"main\" server thread").add().add("Details of the spawning are disabled according to the Sponge").add("configuration file. A stack trace of the attempted spawn should").add("provide information about how it was being spawned. Sponge is").add("currently configured to NOT attempt to capture this spawn and").add("spawn the entity at an appropriate time, while on the main server").add("thread.").add().add("Details of the spawn:").add("%s : %s", "Entity", entity).add("Stacktrace").add(new Exception("Async entity spawn attempt"));
            if (IN_DEVELOPMENT) {
                printer.print(System.err);
            } else {
                printer.log(SpongeCommon.getLogger(), Level.ERROR);
            }
            hasPrintedAsyncEntities = true;
            return;
        }
        PhaseTracker.ASYNC_CAPTURED_ENTITIES.add((Entity)entity);
        if (!SpongeConfigs.getCommon().get().phaseTracker.verbose) {
            return;
        }
        if (!SpongeConfigs.getCommon().get().phaseTracker.verboseErrors && hasPrintedAsyncEntities) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Async Entity Spawn Warning").centre().hr().add("An entity was attempting to spawn off the \"main\" server thread").add().add("Delayed spawning is ENABLED for Sponge.").add("The entity is safely captured by Sponge while off the main").add("server thread, and therefore will be spawned the next tick.").add("Some cases where a mod is expecting the entity back while").add("async can cause issues with said mod.").add().add("Details of the spawn:").add("%s : %s", "Entity", entity).add("Stacktrace").add(new Exception("Async entity spawn attempt"));
        if (IN_DEVELOPMENT) {
            printer.print(System.err);
        } else {
            printer.log(SpongeCommon.getLogger(), Level.ERROR);
        }
        hasPrintedAsyncEntities = true;
    }

    static boolean checkMaxBlockProcessingDepth(IPhaseState<@NonNull ?> state, PhaseContext<@NonNull ?> context, int currentDepth) {
        ConfigHandle<CommonConfig> globalConfigAdapter = SpongeConfigs.getCommon();
        PhaseTrackerCategory trackerConfig = globalConfigAdapter.get().phaseTracker;
        int maxDepth = trackerConfig.maxBlockProcessingDepth;
        if (currentDepth < maxDepth) {
            return false;
        }
        if (!trackerConfig.verbose && printedExceptionForMaximumProcessDepth.contains(state)) {
            return true;
        }
        printedExceptionForMaximumProcessDepth.add(state);
        String message = String.format("Sponge is still trying to process captured blocks after %s iterations of depth-first processing. This is likely due to a mod doing something unusual.", currentDepth);
        PhasePrinter.printMessageWithCaughtException(EMPTY, "Maximum block processing depth exceeded!", message, state, context, null);
        return true;
    }
}

