/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.collect.ImmutableList;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.LootContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.TrackerBlockEventDataBridge;
import org.spongepowered.common.bridge.util.concurrent.TrackedTickDelayedTaskBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;
import org.spongepowered.common.world.BlockChange;

public interface PhaseStateProxy<C extends PhaseContext<C>> {
    public IPhaseState<C> getState();

    public C asContext();

    default public BiConsumer<CauseStackManager.StackFrame, C> getFrameModifier() {
        return this.getState().getFrameModifier();
    }

    default public boolean isNotReEntrant() {
        return this.getState().isNotReEntrant();
    }

    default public boolean isInteraction() {
        return this.getState().isInteraction();
    }

    default public boolean isTicking() {
        return this.getState().isTicking();
    }

    default public boolean isWorldGeneration() {
        return this.getState().isWorldGeneration();
    }

    default public boolean includesDecays() {
        return this.getState().includesDecays();
    }

    default public boolean isEvent() {
        return this.getState().isEvent();
    }

    default public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> snapshotTransaction) {
        this.getState().postBlockTransactionApplication(blockChange, snapshotTransaction, this.asContext());
    }

    default public boolean tracksCreatorsAndNotifiers() {
        return this.getState().tracksCreatorsAndNotifiers();
    }

    default public boolean doesAllowEntitySpawns() {
        return this.getState().doesAllowEntitySpawns();
    }

    default public boolean doesDenyChunkRequests() {
        return this.getState().doesDenyChunkRequests(this.asContext());
    }

    default public boolean doesBlockEventTracking() {
        return this.getState().doesBlockEventTracking(this.asContext());
    }

    default public boolean isCollision() {
        return this.getState().isCollision();
    }

    default public boolean ignoresBlockEvent() {
        return this.getState().ignoresBlockEvent();
    }

    default public boolean ignoresBlockUpdateTick() {
        return this.getState().ignoresBlockUpdateTick(this.asContext());
    }

    default public boolean ignoresScheduledUpdates() {
        return this.getState().ignoresScheduledUpdates();
    }

    default public boolean alreadyCapturingBlockTicks() {
        return this.getState().alreadyCapturingBlockTicks(this.asContext());
    }

    default public boolean alreadyCapturingEntitySpawns() {
        return this.getState().alreadyCapturingEntitySpawns();
    }

    default public boolean alreadyCapturingEntityTicks() {
        return this.getState().alreadyCapturingEntityTicks();
    }

    default public boolean alreadyCapturingTileTicks() {
        return this.getState().alreadyCapturingTileTicks();
    }

    default public boolean requiresPost() {
        return this.getState().requiresPost();
    }

    default public boolean handlesOwnStateCompletion() {
        return this.getState().handlesOwnStateCompletion();
    }

    default public void associateNeighborStateNotifier(@Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
        this.getState().associateNeighborStateNotifier(this.asContext(), sourcePos, block, notifyPos, minecraftWorld, notifier);
    }

    default public void appendContextPreExplosion(ExplosionContext explosionContext) {
        this.getState().appendContextPreExplosion(explosionContext, this.asContext());
    }

    default public void appendNotifierPreBlockTick(ServerWorld world, BlockPos pos, LocationBasedTickContext<@NonNull ?> phaseContext) {
        this.getState().appendNotifierPreBlockTick(world, pos, this.asContext(), phaseContext);
    }

    default public void appendNotifierToBlockEvent(TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackerBlockEventDataBridge blockEvent) {
        this.getState().appendNotifierToBlockEvent(this.asContext(), mixinWorldServer, pos, blockEvent);
    }

    default public void capturePlayerUsingStackToBreakBlock(ItemStack itemStack, @Nullable ServerPlayerEntity playerIn) {
        this.getState().capturePlayerUsingStackToBreakBlock(itemStack, playerIn, this.asContext());
    }

    default public boolean allowsEventListener() {
        return this.getState().allowsEventListener();
    }

    default public boolean isRegeneration() {
        return this.getState().isRegeneration();
    }

    default public ChangeBlock createTransaction(SpongeBlockSnapshot originalBlockSnapshot, BlockState newState, BlockChangeFlag flags) {
        return this.getState().createTransaction(this.asContext(), originalBlockSnapshot, newState, flags);
    }

    default public boolean doesCaptureNeighborNotifications() {
        return this.getState().doesCaptureNeighborNotifications(this.asContext());
    }

    default public BlockChange associateBlockChangeWithSnapshot(BlockState newState, Block newBlock, BlockState currentState, SpongeBlockSnapshot snapshot, Block originalBlock) {
        return this.getState().associateBlockChangeWithSnapshot(this.asContext(), newState, newBlock, currentState, snapshot, originalBlock);
    }

    default public boolean shouldProvideModifiers() {
        return this.getState().shouldProvideModifiers(this.asContext());
    }

    default public boolean isRestoring() {
        return this.getState().isRestoring();
    }

    default public boolean shouldCreateWorldDirectories() {
        return this.getState().shouldCreateWorldDirectories(this.asContext());
    }

    default public boolean isConvertingMaps() {
        return this.getState().isConvertingMaps();
    }

    default public boolean allowsGettingQueuedRemovedTiles() {
        return this.getState().allowsGettingQueuedRemovedTiles();
    }

    default public void markTeleported() {
        this.getState().markTeleported(this.asContext());
    }

    default public Supplier<SpawnType> getSpawnTypeForTransaction(Entity entityToSpawn) {
        return this.getState().getSpawnTypeForTransaction(this.asContext(), entityToSpawn);
    }

    default public SpawnEntityEvent createSpawnEvent(GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<Entity, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        return this.getState().createSpawnEvent(this.asContext(), parent, collect, currentCause);
    }

    default public boolean recordsEntitySpawns() {
        return this.getState().recordsEntitySpawns(this.asContext());
    }

    default public void populateLootContext(LootContext.Builder lootBuilder) {
        this.getState().populateLootContext(this.asContext(), lootBuilder);
    }

    default public Operation getBlockOperation(SpongeBlockSnapshot original, BlockChange blockChange) {
        return this.getState().getBlockOperation(original, blockChange);
    }

    default public void foldContextForThread(TrackedTickDelayedTaskBridge returnValue) {
        this.getState().foldContextForThread(this.asContext(), returnValue);
    }

    default public void associateScheduledTickUpdate(NextTickListEntry<?> entry) {
        this.getState().associateScheduledTickUpdate(this.asContext(), entry);
    }
}

