/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.common.event.tracking.PhaseTracker;

public final class SpongeCauseStackFrame
implements CauseStackManager.StackFrame {
    private final PhaseTracker tracker;
    private final Map<EventContextKey<?>, Object> storedContextValues;
    private final Map<EventContextKey<?>, Object> storedContext;
    int old_min_depth;
    int lastCauseSize;
    @Nullable
    Exception stackDebug = null;

    SpongeCauseStackFrame(PhaseTracker tracker) {
        this.tracker = tracker;
        this.storedContextValues = new Object2ObjectOpenHashMap();
        this.storedContext = new Object2ObjectOpenHashMap();
    }

    public void clear() {
        this.storedContextValues.clear();
        this.storedContext.clear();
        this.lastCauseSize = -1;
        this.old_min_depth = -1;
        this.stackDebug = null;
    }

    public SpongeCauseStackFrame set(int oldDepth, int size) {
        this.old_min_depth = oldDepth;
        this.lastCauseSize = size;
        return this;
    }

    public boolean isStored(EventContextKey<?> key) {
        return this.storedContextValues.containsKey(key);
    }

    public Set<Map.Entry<EventContextKey<?>, Object>> getStoredValues() {
        return this.storedContextValues.entrySet();
    }

    public boolean hasStoredValues() {
        return !this.storedContextValues.isEmpty();
    }

    public void store(EventContextKey<?> key, Object existing) {
        this.storedContextValues.put(key, existing);
    }

    void storeOriginalContext(EventContextKey<?> key, @Nullable Object value) {
        if (!this.storedContext.containsKey(key)) {
            this.storedContext.put(key, value);
        }
    }

    Map<EventContextKey<?>, Object> getOriginalContextDelta() {
        return this.storedContext;
    }

    @Override
    public Cause getCurrentCause() {
        return this.tracker.getCurrentCause();
    }

    @Override
    public EventContext getCurrentContext() {
        return this.tracker.getCurrentContext();
    }

    @Override
    public CauseStackManager.StackFrame pushCause(Object value) {
        this.tracker.pushCause(Objects.requireNonNull(value, "value"));
        return this;
    }

    @Override
    public Object popCause() {
        return this.tracker.popCause();
    }

    @Override
    public <T> CauseStackManager.StackFrame addContext(EventContextKey<T> key, T value) {
        this.tracker.addContext(Objects.requireNonNull(key, "key"), Objects.requireNonNull(value, "value"));
        return this;
    }

    @Override
    public <T> Optional<T> removeContext(EventContextKey<T> key) {
        return this.tracker.removeContext(Objects.requireNonNull(key, "key"));
    }

    @Override
    public void close() {
        this.tracker.popCauseFrame(this);
    }
}

