/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.pipeline;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class WorldPipeline
implements BlockPipeline {
    private final Supplier<Chunk> chunkSupplier;
    private final Supplier<ServerWorld> serverWorld;
    private final Supplier<ChunkSection> sectionSupplier;
    private final boolean wasEmpty;
    private final List<ResultingTransactionBySideEffect> worldEffects;
    private final ChunkPipeline chunkPipeline;

    WorldPipeline(Builder builder) {
        this.chunkSupplier = builder.chunkSupplier;
        this.worldEffects = builder.effects;
        this.serverWorld = builder.serverWorld;
        this.sectionSupplier = builder.sectionSupplier;
        @Nullable ChunkSection chunkSection = Objects.requireNonNull(builder.sectionSupplier).get();
        this.wasEmpty = chunkSection == null || chunkSection.func_76663_a();
        this.chunkPipeline = builder.chunkPipeline;
    }

    @Override
    public ServerWorld getServerWorld() {
        return Objects.requireNonNull(this.serverWorld, "ServerWorld Supplier is null in ChunkPipeline").get();
    }

    @Override
    public Chunk getAffectedChunk() {
        return Objects.requireNonNull(this.chunkSupplier, "Chunk Supplier is null in ChunkPipeline").get();
    }

    @Override
    public ChunkSection getAffectedSection() {
        return Objects.requireNonNull(this.sectionSupplier, "ChunkSection Supplier is null in ChunkPipeline").get();
    }

    public boolean processEffects(PhaseContext<?> context, BlockState currentState, BlockState newProposedState, BlockPos pos, @Nullable Entity destroyer, SpongeBlockChangeFlag flag, int limit) {
        if (this.worldEffects.isEmpty()) {
            return false;
        }
        ServerWorld serverWorld = Objects.requireNonNull(this.serverWorld).get();
        @Nullable BlockState oldState = this.chunkPipeline.processChange(context, currentState, newProposedState, pos, limit);
        if (oldState == null) {
            return false;
        }
        int oldOpacity = oldState.func_200016_a((IBlockReader)serverWorld, pos);
        @Nullable TileEntity existing = this.chunkSupplier.get().func_177424_a(pos, Chunk.CreateEntityType.CHECK);
        PipelineCursor formerState = new PipelineCursor(oldState, oldOpacity, pos, existing, destroyer, limit);
        for (ResultingTransactionBySideEffect effect : this.worldEffects) {
            EffectTransactor ignored = context.getTransactor().pushEffect(effect);
            Throwable throwable = null;
            try {
                EffectResult result = effect.effect.processSideEffect(this, formerState, newProposedState, flag, limit);
                if (result.hasResult) {
                    boolean bl = result.resultingState != null;
                    return bl;
                }
                if (!formerState.drops.isEmpty() || result.drops.isEmpty()) continue;
                formerState = new PipelineCursor(oldState, oldOpacity, pos, existing, formerState.destroyer, result.drops, limit);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        return false;
    }

    public static Builder builder(ChunkPipeline pipeline) {
        return new Builder(Objects.requireNonNull(pipeline, "ChunkPipeline cannot be null!"));
    }

    @Override
    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    public static final class Builder {
        final Supplier<ServerWorld> serverWorld = chunkPipeline::getServerWorld;
        final Supplier<Chunk> chunkSupplier = chunkPipeline::getAffectedChunk;
        final Supplier<ChunkSection> sectionSupplier = chunkPipeline::getAffectedSection;
        @MonotonicNonNull List<ResultingTransactionBySideEffect> effects;
        final ChunkPipeline chunkPipeline;

        Builder(ChunkPipeline chunkPipeline) {
            this.chunkPipeline = chunkPipeline;
        }

        public Builder addEffect(ProcessingSideEffect effect) {
            if (this.effects == null) {
                this.effects = new LinkedList<ResultingTransactionBySideEffect>();
            }
            this.effects.add(new ResultingTransactionBySideEffect(Objects.requireNonNull(effect, "Effect is null")));
            return this;
        }

        public WorldPipeline build() {
            if (this.effects == null) {
                this.effects = Collections.emptyList();
            }
            return new WorldPipeline(this);
        }
    }
}

