/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.Hand;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.accessor.entity.passive.AbstractChestedHorseEntityAccessor;
import org.spongepowered.common.accessor.entity.passive.PigEntityAccessor;
import org.spongepowered.common.accessor.entity.passive.SheepEntityAccessor;
import org.spongepowered.common.accessor.entity.passive.WolfEntityAccessor;
import org.spongepowered.common.accessor.inventory.container.SlotAccessor;
import org.spongepowered.common.accessor.network.play.client.CPlayerPacketAccessor;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class PacketPhaseUtil {
    public static boolean handleSlotRestore(PlayerEntity player, @Nullable Container containerMenu, List<SlotTransaction> slotTransactions, boolean eventCancelled) {
        boolean restoredAny = false;
        for (SlotTransaction slotTransaction : slotTransactions) {
            ItemStackSnapshot snapshot;
            if (!slotTransaction.getCustom().isPresent() && slotTransaction.isValid() && !eventCancelled) continue;
            restoredAny = true;
            SlotAdapter slot = (SlotAdapter)slotTransaction.getSlot();
            ItemStackSnapshot itemStackSnapshot = snapshot = eventCancelled || !slotTransaction.isValid() ? (ItemStackSnapshot)slotTransaction.getOriginal() : (ItemStackSnapshot)slotTransaction.getCustom().get();
            if (containerMenu == null) {
                slot.set(snapshot.createStack());
                continue;
            }
            int slotNumber = slot.getOrdinal();
            Slot nmsSlot = containerMenu.func_75139_a(slotNumber);
            if (nmsSlot == null) continue;
            nmsSlot.func_75215_d(ItemStackUtil.fromSnapshotToNative(snapshot));
        }
        if (containerMenu != null) {
            boolean capture = ((TrackedInventoryBridge)containerMenu).bridge$capturingInventory();
            ((TrackedInventoryBridge)containerMenu).bridge$setCaptureInventory(false);
            containerMenu.func_75142_b();
            ((TrackedInventoryBridge)containerMenu).bridge$setCaptureInventory(capture);
            if (eventCancelled && player.field_71070_bA == containerMenu && player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).func_71120_a(containerMenu);
            }
        }
        return restoredAny;
    }

    public static void handleCustomCursor(PlayerEntity player, ItemStackSnapshot customCursor) {
        ItemStack cursor = ItemStackUtil.fromSnapshotToNative(customCursor);
        player.field_71071_by.func_70437_b(cursor);
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, cursor));
        }
    }

    public static void validateCapturedTransactions(int slotId, Container containerMenu, List<SlotTransaction> capturedTransactions) {
        Slot slot;
        if (capturedTransactions.size() == 0 && slotId >= 0 && slotId < containerMenu.field_75151_b.size() && (slot = containerMenu.func_75139_a(slotId)) != null) {
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(slot.func_75211_c());
            SlotTransaction slotTransaction = new SlotTransaction(((InventoryAdapter)containerMenu).inventoryAdapter$getSlot(slotId).get(), snapshot, snapshot);
            capturedTransactions.add(slotTransaction);
        }
    }

    public static void handlePlayerSlotRestore(ServerPlayerEntity player, ItemStack itemStack, Hand hand) {
        if (itemStack.func_190926_b()) {
            return;
        }
        player.field_71137_h = false;
        int slotId = 0;
        if (hand == Hand.OFF_HAND) {
            player.field_71071_by.field_184439_c.set(0, (Object)itemStack);
            slotId = player.field_71071_by.field_70462_a.size() + PlayerInventory.func_70451_h();
        } else {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)itemStack);
            for (Slot containerSlot : player.field_71070_bA.field_75151_b) {
                if (containerSlot.field_75224_c != player.field_71071_by || ((SlotAccessor)containerSlot).accessor$slot() != player.field_71071_by.field_70461_c) continue;
                slotId = containerSlot.field_75222_d;
                break;
            }
        }
        player.field_71070_bA.func_75142_b();
        player.field_71137_h = false;
        player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(player.field_71070_bA.field_75152_c, slotId, itemStack));
    }

    public static boolean allTransactionsInvalid(List<SlotTransaction> slotTransactions) {
        if (slotTransactions.size() == 0) {
            return false;
        }
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!slotTransaction.isValid()) continue;
            return false;
        }
        return true;
    }

    public static void onProcessPacket(IPacket packetIn, INetHandler netHandler) {
        if (netHandler instanceof ServerPlayNetHandler) {
            ServerPlayerEntity packetPlayer = ((ServerPlayNetHandler)netHandler).field_147369_b;
            if (!(packetPlayer.func_70089_S() || packetIn instanceof CCustomPayloadPacket || packetIn instanceof CClientStatusPacket && ((CClientStatusPacket)packetIn).func_149435_c() == CClientStatusPacket.State.PERFORM_RESPAWN)) {
                return;
            }
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                CPlayerPacket movingPacket;
                frame.pushCause(packetPlayer);
                boolean ignoreMovementCapture = packetIn instanceof CPlayerPacket ? ((movingPacket = (CPlayerPacket)packetIn) instanceof CPlayerPacket.RotationPacket ? true : packetPlayer.func_226277_ct_() == ((CPlayerPacketAccessor)movingPacket).accessor$x() && packetPlayer.func_226278_cu_() == ((CPlayerPacketAccessor)movingPacket).accessor$y() && packetPlayer.func_226281_cx_() == ((CPlayerPacketAccessor)movingPacket).accessor$z()) : false;
                if (ignoreMovementCapture || packetIn instanceof CClientSettingsPacket) {
                    packetIn.func_148833_a(netHandler);
                }
                ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(packetPlayer.field_71071_by.func_70445_o());
                IPhaseState<PacketContext<?>> packetState = PacketPhase.getInstance().getStateForPacket(packetIn);
                PacketContext<?> context = packetState.createPhaseContext(PhaseTracker.SERVER);
                if (!PacketPhase.getInstance().isPacketInvalid(packetIn, packetPlayer, packetState)) {
                    ((PacketContext)((PacketContext)((PacketContext)context.source(packetPlayer)).packetPlayer(packetPlayer)).packet(packetIn)).cursor(cursor);
                    PacketPhase.getInstance().populateContext(packetIn, packetPlayer, packetState, context);
                    context.creator(((ServerPlayer)packetPlayer).getUser());
                    context.notifier(((ServerPlayer)packetPlayer).getUser());
                }
                try (PacketContext<?> packetContext = context;){
                    packetContext.buildAndSwitch();
                    packetIn.func_148833_a(netHandler);
                }
                if (packetIn instanceof CClientStatusPacket) {
                    packetPlayer = ((ServerPlayNetHandler)netHandler).field_147369_b;
                }
                ((ServerPlayerEntityBridge)packetPlayer).bridge$setPacketItem(ItemStack.field_190927_a);
            }
        } else {
            packetIn.func_148833_a(netHandler);
        }
    }

    @Nullable
    public static DataParameter<?> findModifiedEntityInteractDataParameter(ItemStack stack, Entity entity) {
        Item item = stack.func_77973_b();
        if (item instanceof DyeItem) {
            if (entity instanceof SheepEntity) {
                return SheepEntityAccessor.accessor$DATA_WOOL_ID();
            }
            if (entity instanceof WolfEntity) {
                return WolfEntityAccessor.accessor$DATA_COLLAR_COLOR();
            }
            return null;
        }
        if (item == Items.field_151057_cb) {
            return entity instanceof LivingEntity && !(entity instanceof PlayerEntity) && stack.func_82837_s() ? EntityAccessor.accessor$DATA_CUSTOM_NAME() : null;
        }
        if (item == Items.field_151141_av) {
            return entity instanceof PigEntity ? PigEntityAccessor.accessor$DATA_SADDLE_ID() : null;
        }
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() == Blocks.field_150486_ae) {
            return entity instanceof AbstractChestedHorseEntity ? AbstractChestedHorseEntityAccessor.accessor$DATA_ID_CHEST() : null;
        }
        return null;
    }
}

