/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.play.client.CEnchantItemPacket;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.entity.AffectEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class EnchantItemPacketState
extends BasicInventoryPacketState {
    @Override
    public void unwind(InventoryPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        TrackedInventoryBridge trackedInventory = (TrackedInventoryBridge)player.field_71070_bA;
        if (!trackedInventory.bridge$capturingInventory()) {
            trackedInventory.bridge$getCapturedSlotTransactions().clear();
            return;
        }
        CEnchantItemPacket packetIn = (CEnchantItemPacket)context.getPacket();
        ItemStackSnapshot lastCursor = context.getCursor();
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
        Container openContainer = player.field_71070_bA;
        List<SlotTransaction> slotTransactions = trackedInventory.bridge$getCapturedSlotTransactions();
        int usedButton = packetIn.func_149537_d();
        ArrayList<Entity> capturedItems = new ArrayList<Entity>();
        CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
        try (CauseStackManager.StackFrame frame = causeStackManager.pushCauseFrame();){
            causeStackManager.pushCause(player);
            causeStackManager.pushCause(openContainer);
            ClickContainerEvent inventoryEvent = this.createInventoryEvent(player, ContainerUtil.fromNative(openContainer), transaction, Lists.newArrayList(slotTransactions), capturedItems, usedButton, null);
            if (trackedInventory.bridge$getCapturedSlotTransactions().isEmpty() && capturedItems.isEmpty()) {
                trackedInventory.bridge$setCaptureInventory(false);
                return;
            }
            if (inventoryEvent != null) {
                if (inventoryEvent instanceof AffectEntityEvent && ((AffectEntityEvent)((Object)inventoryEvent)).getEntities().isEmpty()) {
                    slotTransactions.clear();
                    trackedInventory.bridge$setCaptureInventory(false);
                    return;
                }
                if (!(inventoryEvent instanceof ClickContainerEvent.Drag)) {
                    PacketPhaseUtil.validateCapturedTransactions(packetIn.func_149539_c(), openContainer, inventoryEvent.getTransactions());
                }
                SpongeCommon.postEvent(inventoryEvent);
                if (inventoryEvent.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(inventoryEvent.getTransactions())) {
                    if (inventoryEvent instanceof ClickContainerEvent.Drop) {
                        capturedItems.clear();
                    }
                    PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, inventoryEvent.getCursorTransaction().getOriginal());
                    PacketPhaseUtil.handleSlotRestore((PlayerEntity)player, openContainer, inventoryEvent.getTransactions(), true);
                } else {
                    PacketPhaseUtil.handleSlotRestore((PlayerEntity)player, openContainer, inventoryEvent.getTransactions(), false);
                    if (!inventoryEvent.getCursorTransaction().isValid()) {
                        PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, inventoryEvent.getCursorTransaction().getOriginal());
                    } else if (inventoryEvent.getCursorTransaction().getCustom().isPresent()) {
                        PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, inventoryEvent.getCursorTransaction().getFinal());
                    }
                    if (inventoryEvent instanceof SpawnEntityEvent) {
                        PacketState.processSpawnedEntities(player, (SpawnEntityEvent)((Object)inventoryEvent));
                    }
                }
            }
        }
        slotTransactions.clear();
        trackedInventory.bridge$setCaptureInventory(false);
    }
}

