/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.TrackerBlockEventDataBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.world.BlockChange;

class BlockEventTickPhaseState
extends TickPhaseState<BlockEventTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, BlockEventTickContext> FRAME_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        TrackerBlockEventDataBridge blockEventData = context.getSource(TrackerBlockEventDataBridge.class).orElse(null);
        if (blockEventData != null) {
            if (blockEventData.bridge$getTileEntity() != null) {
                frame.pushCause(blockEventData.bridge$getTileEntity());
            } else if (blockEventData.bridge$getTickingLocatable() != null) {
                frame.pushCause(blockEventData.bridge$getTickingLocatable());
                frame.addContext(EventContextKeys.BLOCK_EVENT_PROCESS, blockEventData.bridge$getTickingLocatable());
            }
        }
    });

    BlockEventTickPhaseState() {
    }

    @Override
    public BlockEventTickContext createNewContext(PhaseTracker tracker) {
        return (BlockEventTickContext)((BlockEventTickContext)new BlockEventTickContext(tracker).addBlockCaptures()).addEntityCaptures();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BlockEventTickContext> getFrameModifier() {
        return this.FRAME_MODIFIER;
    }

    @Override
    public void associateNeighborStateNotifier(BlockEventTickContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
        context.applyNotifierIfAvailable(user -> {
            ChunkBridge mixinChunk = (ChunkBridge)minecraftWorld.func_175726_f(notifyPos);
            mixinChunk.bridge$addTrackedBlockPosition(block, notifyPos, (User)user, PlayerTracker.Type.NOTIFIER);
        });
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> snapshotTransaction, BlockEventTickContext context) {
        Block block = (Block)snapshotTransaction.getOriginal().getState().getType();
        SpongeBlockSnapshot original = (SpongeBlockSnapshot)snapshotTransaction.getOriginal();
        BlockPos changedBlockPos = original.getBlockPos();
        original.getServerWorld().ifPresent(worldServer -> {
            ChunkBridge changedMixinChunk = (ChunkBridge)worldServer.func_175726_f(changedBlockPos);
            changedMixinChunk.bridge$getBlockCreator(changedBlockPos).ifPresent(owner -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (User)owner, PlayerTracker.Type.CREATOR));
            changedMixinChunk.bridge$getBlockNotifier(changedBlockPos).ifPresent(user -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (User)user, PlayerTracker.Type.NOTIFIER));
        });
    }

    @Override
    public void unwind(BlockEventTickContext context) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
            TrackingUtil.processBlockCaptures(context);
        }
    }

    @Override
    public boolean doesCaptureNeighborNotifications(BlockEventTickContext context) {
        return true;
    }
}

