/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.fluid;

import java.util.Optional;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.fluid.FluidStack;
import org.spongepowered.api.fluid.FluidStackSnapshot;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.fluid.SpongeFluidStackBuilder;
import org.spongepowered.common.fluid.SpongeFluidStackSnapshotBuilder;
import org.spongepowered.common.util.Constants;

public class SpongeFluidStack
implements FluidStack,
SpongeMutableDataHolder {
    private FluidType fluidType;
    private int volume;
    @Nullable
    private DataContainer extraData;

    SpongeFluidStack(SpongeFluidStackBuilder builder) {
        this.fluidType = builder.fluidType;
        this.volume = builder.volume;
        DataContainer dataContainer = this.extraData = builder.extra == null ? null : builder.extra.copy();
        if (builder.keyValues != null) {
            builder.keyValues.forEach((k, v) -> this.offer(k, v));
        }
    }

    private SpongeFluidStack(FluidType fluidType, int volume, @Nullable DataContainer extraData) {
        this.fluidType = fluidType;
        this.volume = volume;
        this.extraData = extraData == null ? null : extraData.copy();
    }

    @Override
    public @NonNull FluidType getFluid() {
        return this.fluidType;
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public @NonNull FluidStack setVolume(int volume) {
        if (volume <= 0) {
            throw new IllegalArgumentException("Volume must be at least 0!");
        }
        this.volume = volume;
        return this;
    }

    @Override
    public @NonNull FluidStackSnapshot createSnapshot() {
        return (FluidStackSnapshot)new SpongeFluidStackSnapshotBuilder().from(this).build();
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Queries.CONTENT_VERSION, Constants.Fluids.FLUID_TYPE, Constants.Fluids.FLUID_VOLUME);
    }

    @Override
    public void setRawData(@NonNull DataView container) throws InvalidDataException {
        try {
            int contentVersion = container.getInt(Queries.CONTENT_VERSION).get();
            if (contentVersion != this.getContentVersion()) {
                throw new InvalidDataException("Older content found! Cannot set raw data of older content!");
            }
            String rawFluid = container.getString(Constants.Fluids.FLUID_TYPE).get();
            int volume = container.getInt(Constants.Fluids.FLUID_VOLUME).get();
            Optional fluidType = Sponge.getGame().registries().registry(RegistryTypes.FLUID_TYPE).findValue(ResourceKey.resolve(rawFluid));
            if (!fluidType.isPresent()) {
                throw new InvalidDataException("Unknown FluidType found! Requested: " + rawFluid + "but got none.");
            }
            this.fluidType = (FluidType)fluidType.get();
            this.volume = volume;
            if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
                this.extraData = container.getView(Constants.Sponge.UNSAFE_NBT).get().copy();
            }
        }
        catch (Exception e) {
            throw new InvalidDataException("DataContainer contained invalid data!", e);
        }
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public @NonNull DataContainer toContainer() {
        ResourceKey resourceKey = Sponge.getGame().registries().registry(RegistryTypes.FLUID_TYPE).valueKey(this.fluidType);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.Fluids.FLUID_TYPE, resourceKey).set(Constants.Fluids.FLUID_VOLUME, this.volume);
        if (this.extraData != null) {
            container.set(Constants.Sponge.UNSAFE_NBT, this.extraData);
        }
        return container;
    }

    @Override
    public FluidStack copy() {
        return new SpongeFluidStack(this.fluidType, this.volume, this.extraData);
    }
}

