/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.fluid;

import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.fluid.FluidStack;
import org.spongepowered.api.fluid.FluidStackSnapshot;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.fluid.SpongeFluidStack;
import org.spongepowered.common.util.Constants;

public class SpongeFluidStackBuilder
extends AbstractDataBuilder<FluidStack>
implements FluidStack.Builder {
    FluidType fluidType;
    int volume = 1;
    @Nullable
    DataContainer extra;
    @Nullable
    LinkedHashMap<Key<@NonNull ?>, Object> keyValues;

    public SpongeFluidStackBuilder() {
        super(FluidStack.class, 1);
    }

    @Override
    public @NonNull FluidStack.Builder fluid(@NonNull FluidType fluidType) {
        this.fluidType = Objects.requireNonNull(fluidType, "FluidType cannot be null!");
        return this;
    }

    @Override
    public @NonNull FluidStack.Builder volume(int volume) {
        if (volume <= 0) {
            throw new IllegalArgumentException("A FluidStack's volume has to be greater than zero!");
        }
        this.volume = volume;
        return this;
    }

    @Override
    public @NonNull FluidStack.Builder from(@NonNull FluidStackSnapshot fluidStackSnapshot) {
        return this.from(fluidStackSnapshot.createStack());
    }

    @Override
    public @NonNull FluidStack build() {
        Objects.requireNonNull(this.fluidType, "Fluidtype cannot be null!");
        if (this.volume < 0) {
            throw new IllegalStateException("Volume must be at least zero!");
        }
        return new SpongeFluidStack(this);
    }

    @Override
    public @NonNull FluidStack.Builder from(FluidStack value) {
        this.fluidType = value.getFluid();
        this.volume = value.getVolume();
        DataContainer container = value.toContainer();
        if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
            this.extra = container.getView(Constants.Sponge.UNSAFE_NBT).get().copy();
        }
        return this;
    }

    @Override
    protected @NonNull Optional<FluidStack> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Fluids.FLUID_TYPE, Constants.Fluids.FLUID_VOLUME)) {
            return Optional.empty();
        }
        this.reset();
        String rawFluid = container.getString(Constants.Fluids.FLUID_TYPE).get();
        Optional fluidType = Sponge.getGame().registries().registry(RegistryTypes.FLUID_TYPE).findValue(ResourceKey.resolve(rawFluid));
        if (!fluidType.isPresent()) {
            throw new InvalidDataException("Invalid fluid id found: " + rawFluid);
        }
        this.fluidType = (FluidType)fluidType.get();
        this.volume = container.getInt(Constants.Fluids.FLUID_VOLUME).get();
        this.extra = container.contains(Constants.Sponge.UNSAFE_NBT) ? container.getView(Constants.Sponge.UNSAFE_NBT).get().copy() : null;
        return Optional.of(this.build());
    }

    @Override
    public @NonNull FluidStack.Builder reset() {
        this.fluidType = null;
        this.volume = 0;
        this.extra = null;
        return this;
    }

    @Override
    public <V> @NonNull FluidStack.Builder add(@NonNull Key<@NonNull ? extends Value<V>> key, @NonNull V value) {
        if (this.keyValues == null) {
            this.keyValues = new LinkedHashMap();
        }
        this.keyValues.put(Objects.requireNonNull(key, "Key cannot be null!"), Objects.requireNonNull(value, "Value cannot be null!"));
        return this;
    }
}

