/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.common.bridge.inventory.InventoryBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.DefaultImplementedAdapterInventory;
import org.spongepowered.common.inventory.adapter.impl.SlotCollection;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.LensRegistrar;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;

public class BasicInventoryAdapter
implements InventoryAdapter,
DefaultImplementedAdapterInventory,
InventoryBridge,
Inventory {
    private final Fabric fabric;
    protected final SlotLensProvider slotLenses;
    protected final Lens lens;
    @Nullable
    private SlotCollection slotCollection;
    @Nullable
    protected List<Inventory> children;
    protected Inventory parent;

    public BasicInventoryAdapter(Fabric fabric, @Nullable Lens root, @Nullable Inventory parent) {
        this.fabric = fabric;
        this.parent = parent == null ? this : parent;
        this.slotLenses = this.initSlotsLenses(fabric, parent);
        this.lens = root != null ? root : LensRegistrar.getLens(this, this.slotLenses, fabric.fabric$getSize());
    }

    private SlotLensProvider initSlotsLenses(Fabric fabric, @Nullable Inventory parent) {
        if (parent instanceof InventoryAdapter) {
            return ((InventoryAdapter)((Object)parent)).inventoryAdapter$getSlotLensProvider();
        }
        return new LensRegistrar.BasicSlotLensProvider(fabric.fabric$getSize());
    }

    @Override
    public Inventory parent() {
        return this.parent;
    }

    @Override
    public SlotLensProvider inventoryAdapter$getSlotLensProvider() {
        return this.slotLenses;
    }

    @Override
    public Lens inventoryAdapter$getRootLens() {
        return this.lens;
    }

    @Override
    public Fabric inventoryAdapter$getFabric() {
        return this.fabric;
    }

    @Override
    public List<Slot> slots() {
        if (this.slotCollection == null) {
            this.slotCollection = SlotCollection.of(this, this);
        }
        return this.slotCollection.slots();
    }

    @Override
    public List<Inventory> children() {
        if (this.children == null) {
            this.children = this.impl$generateChildren();
        }
        return this.children;
    }

    @Override
    public Optional<Slot> inventoryAdapter$getSlot(int ordinal) {
        List<Slot> slots = this.slots();
        if (ordinal >= slots.size()) {
            return Optional.empty();
        }
        return Optional.of(slots.get(ordinal));
    }

    public static Optional<Slot> forSlot(Fabric fabric, SlotLens slotLens, Inventory parent) {
        return slotLens == null ? Optional.empty() : Optional.ofNullable(slotLens.getAdapter(fabric, parent));
    }

    @Override
    public void clear() {
        this.slots().forEach(Inventory::clear);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("capacity", this.capacity()).add("children", this.children().size()).add("parent", (Object)(this.parent == this ? "self" : this.parent.getClass().getSimpleName())).add("fabric", (Object)this.fabric.getClass().getSimpleName()).add("lens", (Object)this.lens.getClass().getSimpleName()).toString();
    }
}

