/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.slot;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerInventory;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.EquipmentSlotAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.HeldSlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.InvalidOrdinalException;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.inventory.lens.impl.comp.HotbarLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;

public class HeldHandSlotLens
extends AbstractLens
implements SlotLens {
    private HotbarLens hotbarLens;

    public HeldHandSlotLens(HotbarLens hotbarLens) {
        super(0, 1, BasicInventoryAdapter.class);
        this.hotbarLens = hotbarLens;
    }

    private PlayerInventory getInventoryPlayer(Fabric fabric) {
        return (PlayerInventory)fabric.fabric$get(0);
    }

    @Override
    public net.minecraft.item.ItemStack getStack(Fabric fabric) {
        PlayerInventory inv = this.getInventoryPlayer(fabric);
        return inv.func_70448_g();
    }

    @Override
    public boolean setStack(Fabric fabric, net.minecraft.item.ItemStack stack) {
        PlayerInventory inv = this.getInventoryPlayer(fabric);
        inv.field_70462_a.set(inv.field_70461_c, (Object)stack);
        return true;
    }

    @Override
    public int getOrdinal(Fabric fabric) {
        PlayerInventory inv = this.getInventoryPlayer(fabric);
        return inv.field_70461_c;
    }

    @Override
    public Class<? extends Inventory> getAdapterType() {
        return EquipmentSlotAdapter.class;
    }

    @Override
    public Slot getAdapter(Fabric fabric, Inventory parent) {
        return new HeldSlotAdapter(fabric, this, parent);
    }

    @Override
    public int slotCount() {
        return 1;
    }

    @Override
    public int getMaxStackSize(Fabric fabric) {
        return fabric.fabric$getMaxStackSize();
    }

    @Override
    public List<Lens> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<Lens> getSpanningChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<SlotLens> getSlots(Fabric fabric) {
        return Collections.singletonList(this.getSlotLens(fabric, 0));
    }

    @Override
    public Lens getLens(int index) {
        return this;
    }

    @Override
    public Map<Key<?>, Object> getDataAt(int index) {
        return Collections.emptyMap();
    }

    @Override
    public Map<Key<?>, Object> getDataFor(Lens lens) {
        return Collections.emptyMap();
    }

    @Override
    public boolean has(Lens lens) {
        return false;
    }

    @Override
    public boolean isSubsetOf(Collection<Lens> c) {
        return false;
    }

    @Override
    public SlotLens getSlotLens(Fabric fabric, int ordinal) {
        if (ordinal != 0) {
            throw new InvalidOrdinalException("Non-zero slot ordinal");
        }
        return this.hotbarLens.getSlotLens(fabric, this.getOrdinal(fabric));
    }

    public Predicate<EquipmentType> getEquipmentTypeFilter() {
        return e -> e == EquipmentTypes.MAIN_HAND.get();
    }

    public Predicate<ItemStack> getItemStackFilter() {
        return i -> true;
    }

    public Predicate<ItemType> getItemTypeFilter() {
        return i -> true;
    }

    @Override
    public String toString(int deep) {
        return "[HeldSlot]";
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public List<Lens> children() {
        return Collections.singletonList(this);
    }
}

