/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.query.type;

import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.EmptyInventoryImpl;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.comp.GridInventoryAdapter;
import org.spongepowered.common.inventory.lens.CompoundSlotLensProvider;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.query.SpongeQuery;
import org.spongepowered.math.vector.Vector2i;

public class GridQuery
extends SpongeQuery {
    private final Vector2i offset;
    private final Vector2i size;

    public GridQuery(Vector2i offset, Vector2i size) {
        this.offset = offset;
        this.size = size;
    }

    @Override
    public Inventory execute(Inventory inventory, InventoryAdapter adapter) {
        if (!(adapter instanceof GridInventoryAdapter)) {
            return new EmptyInventoryImpl(inventory);
        }
        GridInventoryAdapter gridAdapter = (GridInventoryAdapter)adapter;
        Vector2i max = gridAdapter.getDimensions();
        if (max.getX() < this.offset.getX() + this.size.getX() && max.getY() < this.offset.getY() + this.size.getY()) {
            return new EmptyInventoryImpl(inventory);
        }
        CompoundSlotLensProvider slotProvider = new CompoundSlotLensProvider();
        for (int dy = 0; dy < this.size.getY(); ++dy) {
            for (int dx = 0; dx < this.size.getX(); ++dx) {
                slotProvider.add(gridAdapter.getSlotLens(this.offset.getX() + dx, this.offset.getY() + dy));
            }
        }
        GridInventoryLens lens = new GridInventoryLens(0, this.size.getX(), this.size.getY(), slotProvider);
        return new GridInventoryAdapter(adapter.inventoryAdapter$getFabric(), lens, inventory);
    }
}

