/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.crafting.ShapelessCraftingRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.shapeless.SpongeShapelessCraftingRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.shapeless.SpongeShapelessCraftingRecipeSerializer;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;

public class SpongeShapelessCraftingRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, ShapelessCraftingRecipe.Builder>
implements ShapelessCraftingRecipe.Builder.EndStep,
ShapelessCraftingRecipe.Builder.ResultStep {
    private ItemStack result;
    private Function<CraftingInventory, net.minecraft.item.ItemStack> resultFunction;
    private Function<CraftingInventory, NonNullList<net.minecraft.item.ItemStack>> remainingItemsFunction;
    private final NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private String group;

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep addIngredients(ItemType ... ingredients) {
        for (ItemType ingredient : ingredients) {
            this.ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> (Item)ingredient}));
        }
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep addIngredients(Supplier<? extends ItemType> ... ingredients) {
        for (Supplier<? extends ItemType> ingredient : ingredients) {
            this.ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> (Item)ingredient.get()}));
        }
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep addIngredients(org.spongepowered.api.item.recipe.crafting.Ingredient ... ingredients) {
        for (org.spongepowered.api.item.recipe.crafting.Ingredient ingredient : ingredients) {
            this.ingredients.add((Object)IngredientUtil.toNative(ingredient));
        }
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep remainingItems(Function<CraftingGridInventory, List<ItemStack>> remainingItemsFunction) {
        this.remainingItemsFunction = grid -> {
            NonNullList mcList = NonNullList.func_191196_a();
            ((List)remainingItemsFunction.apply(InventoryUtil.toSpongeInventory(grid))).forEach(stack -> mcList.add((Object)ItemStackUtil.toNative(stack)));
            return mcList;
        };
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        this.result = result.createStack();
        this.resultFunction = null;
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep result(ItemStack result) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        this.result = result;
        this.resultFunction = null;
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep result(Function<CraftingGridInventory, ItemStack> resultFunction, ItemStack exemplaryResult) {
        this.resultFunction = inv -> ItemStackUtil.toNative((ItemStack)resultFunction.apply(InventoryUtil.toSpongeInventory(inv)));
        this.result = exemplaryResult.copy();
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        Preconditions.checkState((!this.ingredients.isEmpty() ? 1 : 0) != 0, (Object)"The ingredients are not set.");
        net.minecraft.item.ItemStack resultStack = ItemStackUtil.toNative(this.result);
        IRecipeSerializer<?> serializer = SpongeRecipeRegistration.determineSerializer(resultStack, this.resultFunction, this.remainingItemsFunction, this.ingredients, IRecipeSerializer.field_222158_b, SpongeShapelessCraftingRecipeSerializer.SPONGE_CRAFTING_SHAPELESS);
        return new SpongeShapelessCraftingRecipeRegistration((ResourceLocation)this.key, serializer, this.group, (List<Ingredient>)this.ingredients, resultStack, this.resultFunction, this.remainingItemsFunction);
    }

    @Override
    public ShapelessCraftingRecipe.Builder reset() {
        super.reset();
        this.result = null;
        this.resultFunction = null;
        this.ingredients.clear();
        this.group = null;
        this.remainingItemsFunction = null;
        return this;
    }
}

