/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.item.crafting.Ingredient;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.item.recipe.ingredient.SpongeItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongePredicateItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongeStackItemList;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SpongeIngredient
extends Ingredient {
    private static final Map<String, Predicate<net.minecraft.item.ItemStack>> cachedPredicates = new HashMap<String, Predicate<net.minecraft.item.ItemStack>>();

    public SpongeIngredient(Stream<? extends Ingredient.IItemList> itemlist) {
        super(itemlist);
    }

    public SpongeIngredient(Ingredient.IItemList iItemList) {
        this(Stream.of(iItemList));
    }

    public static void clearCache() {
        cachedPredicates.clear();
    }

    public boolean test(net.minecraft.item.ItemStack testStack) {
        if (testStack == null) {
            return false;
        }
        for (Ingredient.IItemList acceptedItem : this.field_199807_b) {
            if (acceptedItem instanceof SpongeItemList) {
                if (!((SpongeItemList)acceptedItem).test(testStack)) continue;
                return true;
            }
            for (net.minecraft.item.ItemStack stack : acceptedItem.func_199799_a()) {
                if (stack.func_77973_b() != testStack.func_77973_b()) continue;
                return true;
            }
        }
        return false;
    }

    public static SpongeIngredient spongeFromStacks(net.minecraft.item.ItemStack ... stacks) {
        SpongeStackItemList itemList = new SpongeStackItemList(stacks);
        return new SpongeIngredient(itemList);
    }

    public static SpongeIngredient spongeFromPredicate(ResourceKey key, Predicate<ItemStack> predicate, net.minecraft.item.ItemStack ... exemplaryIngredients) {
        Predicate<net.minecraft.item.ItemStack> mcPredicate = stack -> predicate.test(ItemStackUtil.fromNative(stack));
        if (cachedPredicates.put(key.toString(), mcPredicate) != null) {
            SpongeCommon.getLogger().warn(MessageFormat.format("Predicate ingredient registered twice! {} was replaced.", key.toString()));
        }
        SpongePredicateItemList itemList = new SpongePredicateItemList(key.toString(), mcPredicate, exemplaryIngredients);
        return new SpongeIngredient(itemList);
    }

    public static Predicate<net.minecraft.item.ItemStack> getCachedPredicate(String id) {
        return cachedPredicates.get(id);
    }
}

