/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.smithing.SmithingRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipeRegistration;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipeSerializer;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;

public final class SpongeSmithingRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, SmithingRecipe.Builder>
implements SmithingRecipe.Builder,
SmithingRecipe.Builder.AdditionStep,
SmithingRecipe.Builder.ResultStep,
SmithingRecipe.Builder.EndStep {
    private ItemStack result;
    private Ingredient base;
    private Ingredient addition;
    private Function<IInventory, net.minecraft.item.ItemStack> resultFunction;
    private @Nullable String group;

    @Override
    public SmithingRecipe.Builder.AdditionStep base(ItemType ingredient) {
        this.base = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> (Item)ingredient});
        return this;
    }

    @Override
    public SmithingRecipe.Builder.AdditionStep base(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        this.base = IngredientUtil.toNative(ingredient);
        return this;
    }

    @Override
    public SmithingRecipe.Builder.ResultStep addition(ItemType ingredient) {
        this.addition = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> (Item)ingredient});
        return this;
    }

    @Override
    public SmithingRecipe.Builder.ResultStep addition(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        this.addition = IngredientUtil.toNative(ingredient);
        return this;
    }

    @Override
    public SmithingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        this.result = result.createStack();
        this.resultFunction = null;
        return this;
    }

    @Override
    public SmithingRecipe.Builder.EndStep result(ItemStack result) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        this.result = result;
        this.resultFunction = null;
        return this;
    }

    @Override
    public SmithingRecipe.Builder.EndStep result(Function<Inventory, ItemStack> resultFunction, ItemStack exemplaryResult) {
        Preconditions.checkNotNull((Object)exemplaryResult, (Object)"exemplaryResult");
        Preconditions.checkState((!exemplaryResult.isEmpty() ? 1 : 0) != 0, (Object)"exemplaryResult must not be empty");
        this.result = exemplaryResult;
        this.resultFunction = inv -> ItemStackUtil.toNative((ItemStack)resultFunction.apply(InventoryUtil.toInventory(inv)));
        return this;
    }

    @Override
    public SmithingRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        net.minecraft.item.ItemStack result = ItemStackUtil.toNative(this.result);
        IRecipeSerializer<?> serializer = SpongeRecipeRegistration.determineSerializer(result, this.resultFunction, null, Arrays.asList(this.base, this.addition), IRecipeSerializer.field_234826_u_, SpongeSmithingRecipeSerializer.SPONGE_SMITHING);
        return new SpongeSmithingRecipeRegistration((ResourceLocation)this.key, serializer, this.group, this.base, this.addition, result, this.resultFunction);
    }

    @Override
    public SmithingRecipe.Builder reset() {
        this.result = null;
        this.resultFunction = null;
        this.base = null;
        this.addition = null;
        this.group = null;
        return (SmithingRecipe.Builder)super.reset();
    }
}

