/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.launch;

import com.google.common.base.Preconditions;
import com.google.inject.Stage;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.common.applaunch.plugin.PluginEngine;
import org.spongepowered.common.launch.plugin.SpongePluginManager;
import org.spongepowered.plugin.PluginContainer;

public abstract class Launch {
    private static Launch INSTANCE;
    protected final PluginEngine pluginEngine;
    protected final SpongePluginManager pluginManager;
    private final Logger logger = LogManager.getLogger("Sponge");
    private final List<PluginContainer> launcherPlugins;
    private PluginContainer minecraftPlugin;
    private PluginContainer apiPlugin;
    private PluginContainer commonPlugin;

    protected Launch(PluginEngine pluginEngine, SpongePluginManager pluginManager) {
        this.pluginEngine = pluginEngine;
        this.pluginManager = pluginManager;
        this.launcherPlugins = new ArrayList<PluginContainer>();
    }

    public static <L extends Launch> L getInstance() {
        return (L)INSTANCE;
    }

    public static void setInstance(Launch instance) {
        if (INSTANCE != null) {
            throw new RuntimeException("Attempt made to re-set launcher instance!");
        }
        INSTANCE = (Launch)Preconditions.checkNotNull((Object)instance);
    }

    public abstract boolean isVanilla();

    public abstract boolean isDedicatedServer();

    public final Logger getLogger() {
        return this.logger;
    }

    public PluginEngine getPluginEngine() {
        return this.pluginEngine;
    }

    public SpongePluginManager getPluginManager() {
        return this.pluginManager;
    }

    public abstract Stage getInjectionStage();

    public final boolean isDeveloperEnvironment() {
        return this.getInjectionStage() == Stage.DEVELOPMENT;
    }

    public final PluginContainer getMinecraftPlugin() {
        if (this.minecraftPlugin == null) {
            this.minecraftPlugin = this.pluginManager.getPlugin("minecraft").orElse(null);
            if (this.minecraftPlugin == null) {
                throw new RuntimeException("Could not find the plugin representing Minecraft, this is a serious issue!");
            }
        }
        return this.minecraftPlugin;
    }

    public final PluginContainer getApiPlugin() {
        if (this.apiPlugin == null) {
            this.apiPlugin = this.pluginManager.getPlugin("spongeapi").orElse(null);
            if (this.apiPlugin == null) {
                throw new RuntimeException("Could not find the plugin representing SpongeAPI, this is a serious issue!");
            }
        }
        return this.apiPlugin;
    }

    public final PluginContainer getCommonPlugin() {
        if (this.commonPlugin == null) {
            this.commonPlugin = this.pluginManager.getPlugin("sponge").orElse(null);
            if (this.commonPlugin == null) {
                throw new RuntimeException("Could not find the plugin representing Sponge, this is a serious issue!");
            }
        }
        return this.commonPlugin;
    }

    public abstract PluginContainer getPlatformPlugin();

    public final List<PluginContainer> getLauncherPlugins() {
        if (this.launcherPlugins.isEmpty()) {
            this.launcherPlugins.add(this.getMinecraftPlugin());
            this.launcherPlugins.add(this.getApiPlugin());
            this.launcherPlugins.add(this.getCommonPlugin());
            this.launcherPlugins.add(this.getPlatformPlugin());
        }
        return this.launcherPlugins;
    }

    protected void onLaunch() {
        this.createPlatformPlugins(this.pluginEngine);
    }

    protected abstract void createPlatformPlugins(PluginEngine var1);

    public final void auditMixins() {
        MixinEnvironment.getCurrentEnvironment().audit();
    }

    public void loadPlugins() {
    }
}

