/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.block;

import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.block.BlockStateSerializerDeserializer;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.mixin.api.mcp.block.AbstractBlockStateMixin_API;
import org.spongepowered.common.util.Constants;

@Mixin(value={net.minecraft.block.BlockState.class})
public abstract class BlockStateMixin_API
extends AbstractBlockStateMixin_API {
    private String api$serializedState;

    @Override
    public int getContentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.Block.BLOCK_STATE, this.impl$getSerializedString());
    }

    @Override
    public BlockSnapshot snapshotFor(ServerLocation location) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled().blockState((net.minecraft.block.BlockState)this).position(location.getBlockPosition()).world((ServerWorld)location.getWorld());
        if (this.shadow$func_177230_c().func_235695_q_() && location.getBlock().getType().equals(this.shadow$func_177230_c())) {
            BlockEntity tileEntity = location.getBlockEntity().orElseThrow(() -> new IllegalStateException("Unable to retrieve a TileEntity for location: " + location));
            builder.add(((CustomDataHolderBridge)((Object)tileEntity)).bridge$getManipulator());
            CompoundNBT compound = new CompoundNBT();
            ((TileEntity)tileEntity).func_189515_b(compound);
            builder.addUnsafeCompound(compound);
        }
        return builder.build();
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Constants.Block.BLOCK_STATE);
    }

    @Override
    public <E> Optional<E> get(Direction direction, Key<? extends Value<E>> key) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public BlockState withRawData(DataView container) throws InvalidDataException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public BlockState copy() {
        return this;
    }

    public String impl$getSerializedString() {
        if (this.api$serializedState == null) {
            this.api$serializedState = BlockStateSerializerDeserializer.serialize(this);
        }
        return this.api$serializedState;
    }
}

