/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.command.Commands;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryScope;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.user.UserManager;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.teleport.TeleportHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.command.CommandsBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.profile.SpongeGameProfileManager;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.scheduler.ServerScheduler;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.UsernameCache;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.storage.SpongePlayerDataManager;
import org.spongepowered.common.world.teleport.SpongeTeleportHelper;

@Mixin(value={MinecraftServer.class})
@Implements(value={@Interface(iface=Server.class, prefix="server$")})
public abstract class MinecraftServerMixin_API
extends RecursiveEventLoop<TickDelayedTask>
implements SpongeServer {
    @Shadow
    @Final
    public long[] field_71311_j;
    @Shadow
    @Final
    protected IServerConfiguration field_240768_i_;
    private Iterable<? extends Audience> audiences;
    private ServerScheduler api$scheduler;
    private SpongeTeleportHelper api$teleportHelper;
    private SpongePlayerDataManager api$playerDataHandler;
    private UsernameCache api$usernameCache;
    private Audience api$broadcastAudience;
    private ServerScoreboard api$scoreboard;
    private GameProfileManager api$profileManager;
    private SpongeUserManager api$userManager;
    private RegistryHolder api$registryHolder;

    @Shadow
    public abstract PlayerList shadow$func_184103_al();

    @Shadow
    public abstract boolean shadow$func_71266_T();

    @Shadow
    public abstract String shadow$func_71273_Y();

    @Shadow
    public abstract int shadow$func_71259_af();

    @Shadow
    public abstract void shadow$func_71263_m(boolean var1);

    @Shadow
    public abstract int shadow$func_143007_ar();

    @Shadow
    public abstract void shadow$func_143006_e(int var1);

    @Shadow
    public abstract boolean shadow$func_71199_h();

    @Shadow
    public abstract boolean shadow$func_104056_am();

    @Shadow
    public abstract boolean shadow$func_71219_W();

    @Shadow
    public abstract boolean shadow$func_82356_Z();

    @Shadow
    protected abstract boolean shadow$func_230536_N_();

    @Shadow
    public abstract boolean shadow$func_230537_U_();

    @Shadow
    public abstract boolean shadow$func_71255_r();

    @Shadow
    public abstract Commands func_195571_aL();

    public MinecraftServerMixin_API(String name) {
        super(name);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void api$initializeSpongeFields(Thread p_i232576_1_, DynamicRegistries.Impl p_i232576_2_, SaveFormat.LevelSave p_i232576_3_, IServerConfiguration p_i232576_4_, ResourcePackList p_i232576_5_, Proxy p_i232576_6_, DataFixer p_i232576_7_, DataPackRegistries p_i232576_8_, MinecraftSessionService p_i232576_9_, GameProfileRepository p_i232576_10_, PlayerProfileCache p_i232576_11_, IChunkStatusListenerFactory p_i232576_12_, CallbackInfo ci) {
        this.api$scheduler = new ServerScheduler();
        this.api$playerDataHandler = new SpongePlayerDataManager(this);
        this.api$teleportHelper = new SpongeTeleportHelper();
        this.api$userManager = new SpongeUserManager(this);
        this.api$registryHolder = new SpongeRegistryHolder(p_i232576_2_);
    }

    public @NonNull Iterable<? extends Audience> audiences() {
        if (this.audiences == null) {
            this.audiences = Iterables.concat((Iterable)this.shadow$func_184103_al().func_181057_v(), Collections.singleton(Sponge.getGame().getSystemSubject()));
        }
        return this.audiences;
    }

    @Override
    public ChunkLayout getChunkLayout() {
        return SpongeChunkLayout.INSTANCE;
    }

    @Override
    public Audience getBroadcastAudience() {
        if (this.api$broadcastAudience == null) {
            this.api$broadcastAudience = this;
        }
        return this.api$broadcastAudience;
    }

    @Override
    public void setBroadcastAudience(Audience channel) {
        this.api$broadcastAudience = (Audience)Preconditions.checkNotNull((Object)channel, (Object)"channel");
    }

    @Override
    public Optional<InetSocketAddress> getBoundAddress() {
        return Optional.empty();
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.shadow$func_184103_al().func_72383_n();
    }

    @Override
    public void setHasWhitelist(boolean enabled) {
        this.shadow$func_184103_al().func_72371_a(enabled);
    }

    @Override
    public boolean isOnlineModeEnabled() {
        return this.shadow$func_71266_T();
    }

    @Override
    public boolean isHardcoreModeEnabled() {
        return this.shadow$func_71199_h();
    }

    @Override
    public Difficulty getDifficulty() {
        return (Difficulty)this.field_240768_i_.func_176130_y();
    }

    @Override
    public GameMode getGameMode() {
        return (GameMode)this.field_240768_i_.func_76077_q();
    }

    @Override
    public boolean isGameModeEnforced() {
        return this.shadow$func_104056_am();
    }

    @Override
    public boolean isPVPEnabled() {
        return this.shadow$func_71219_W();
    }

    @Override
    public boolean areCommandBlocksEnabled() {
        return this.shadow$func_82356_Z();
    }

    @Override
    public boolean isMonsterSpawnsEnabled() {
        return this.shadow$func_230536_N_();
    }

    @Override
    public boolean isAnimalSpawnsEnabled() {
        return this.shadow$func_230537_U_();
    }

    @Override
    public boolean isMultiWorldEnabled() {
        return this.shadow$func_71255_r();
    }

    @Override
    public UserManager getUserManager() {
        return this.api$userManager;
    }

    @Override
    public TeleportHelper getTeleportHelper() {
        return this.api$teleportHelper;
    }

    @Override
    public Collection<ServerPlayer> getOnlinePlayers() {
        if (this.shadow$func_184103_al() == null || this.shadow$func_184103_al().func_181057_v() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.shadow$func_184103_al().func_181057_v());
    }

    @Override
    public Optional<ServerPlayer> getPlayer(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId);
        if (this.shadow$func_184103_al() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ServerPlayer)this.shadow$func_184103_al().func_177451_a(uniqueId));
    }

    @Override
    public Optional<ServerPlayer> getPlayer(String name) {
        if (this.shadow$func_184103_al() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ServerPlayer)this.shadow$func_184103_al().func_152612_a(name));
    }

    @Override
    public Component getMOTD() {
        return SpongeAdventure.legacySection(this.shadow$func_71273_Y());
    }

    @Override
    public int getMaxPlayers() {
        if (this.shadow$func_184103_al() == null) {
            return 0;
        }
        return this.shadow$func_184103_al().func_72352_l();
    }

    @Override
    public int getRunningTimeTicks() {
        return this.shadow$func_71259_af();
    }

    @Override
    public double getTicksPerSecond() {
        double nanoSPerTick = MathHelper.func_76127_a((long[])this.field_71311_j);
        return 1000.0 / Math.max(50.0, nanoSPerTick / 1000000.0);
    }

    @Override
    public int getTargetTicksPerSecond() {
        return 20;
    }

    @Override
    public void shutdown() {
        this.shadow$func_71263_m(false);
    }

    @Override
    public void shutdown(Component kickMessage) {
        Preconditions.checkNotNull((Object)kickMessage);
        for (ServerPlayer player : this.getOnlinePlayers()) {
            player.kick(kickMessage);
        }
        this.shadow$func_71263_m(false);
    }

    @Override
    public GameProfileManager getGameProfileManager() {
        if (this.api$profileManager == null) {
            this.api$profileManager = new SpongeGameProfileManager(this);
        }
        return this.api$profileManager;
    }

    @Override
    public SpongeCommandManager getCommandManager() {
        return ((CommandsBridge)this.func_195571_aL()).bridge$commandManager();
    }

    public Optional<ResourcePack> server$getResourcePack() {
        return Optional.ofNullable(((MinecraftServerBridge)((Object)this)).bridge$getResourcePack());
    }

    public Optional<Scoreboard> getServerScoreboard() {
        if (this.api$scoreboard == null) {
            ServerWorld world = SpongeCommon.getServer().func_241755_D_();
            if (world == null) {
                return Optional.empty();
            }
            this.api$scoreboard = world.func_96441_U();
        }
        return Optional.of((Scoreboard)this.api$scoreboard);
    }

    @Intrinsic
    public int server$getPlayerIdleTimeout() {
        return this.shadow$func_143007_ar();
    }

    @Intrinsic
    public void server$setPlayerIdleTimeout(int timeout) {
        this.shadow$func_143006_e(timeout);
    }

    @Override
    public Game getGame() {
        return Sponge.getGame();
    }

    @Override
    public CauseStackManager getCauseStackManager() {
        return PhaseTracker.getCauseStackManager();
    }

    @Override
    public ServerScheduler getScheduler() {
        return this.api$scheduler;
    }

    @Override
    public boolean onMainThread() {
        return this.func_213162_bc();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public SpongePlayerDataManager getPlayerDataManager() {
        return this.api$playerDataHandler;
    }

    @Override
    public UsernameCache getUsernameCache() {
        if (this.api$usernameCache == null) {
            this.api$usernameCache = new UsernameCache(this);
        }
        return this.api$usernameCache;
    }

    public void sendMessage(Identity identity, Component message, MessageType type) {
        this.shadow$func_184103_al().func_232641_a_(SpongeAdventure.asVanilla(message), SpongeAdventure.asVanilla(type), identity.uuid());
    }

    @Override
    public ServiceProvider.ServerScoped getServiceProvider() {
        return ((MinecraftServerBridge)((Object)this)).bridge$getServiceProvider();
    }

    @Override
    public RegistryScope registryScope() {
        return RegistryScope.ENGINE;
    }

    @Override
    public RegistryHolder registries() {
        return this.api$registryHolder;
    }
}

