/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.kyori.adventure.sound.Sound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.storage.IWorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeApplicators;
import org.spongepowered.api.world.volume.stream.VolumeCollectors;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslators;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.server.ChunkManagerAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.effect.record.SpongeMusicDisc;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.buffer.archetype.SpongeArchetypeVolume;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={net.minecraft.world.World.class})
public abstract class WorldMixin_API<W extends World<W, L>, L extends Location<W, L>>
implements World<W, L>,
AutoCloseable {
    @Shadow
    @Final
    public Random field_73012_v;
    @Shadow
    @Final
    public List<TileEntity> field_147482_g;
    private Context impl$context;

    @Shadow
    public abstract @Nullable MinecraftServer shadow$func_73046_m();

    @Shadow
    public abstract net.minecraft.block.BlockState shadow$func_180495_p(BlockPos var1);

    @Shadow
    public abstract void shadow$func_184148_a(@javax.annotation.Nullable PlayerEntity var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    @Shadow
    public abstract IWorldInfo shadow$func_72912_H();

    @Shadow
    public abstract void shadow$func_175690_a(BlockPos var1, @javax.annotation.Nullable TileEntity var2);

    @Shadow
    public abstract void shadow$func_175713_t(BlockPos var1);

    @Shadow
    public abstract RegistryKey<net.minecraft.world.World> shadow$func_234923_W_();

    @Override
    public Optional<? extends Player> getClosestPlayer(int x, int y, int z, double distance, Predicate<? super Player> predicate) {
        return Optional.ofNullable((Player)((net.minecraft.world.World)this).func_190525_a((double)x, (double)y, (double)z, distance, Objects.requireNonNull(predicate, "predicate")));
    }

    @Override
    public Chunk getChunk(int cx, int cy, int cz) {
        return (Chunk)((net.minecraft.world.World)this).func_217353_a(cx >> 4, cz >> 4, ChunkStatus.field_223226_a_, true);
    }

    @Override
    public Optional<Chunk> loadChunk(int cx, int cy, int cz, boolean shouldGenerate) {
        if (!SpongeChunkLayout.INSTANCE.isValidChunk(cx, cy, cz)) {
            return Optional.empty();
        }
        AbstractChunkProvider chunkProvider = ((IWorld)this).func_72863_F();
        if (!shouldGenerate) {
            return Optional.ofNullable((Chunk)chunkProvider.func_212849_a_(cx, cz, ChunkStatus.field_223226_a_, true));
        }
        return Optional.ofNullable((Chunk)chunkProvider.func_212849_a_(cx, cz, ChunkStatus.field_222617_m, true));
    }

    @Override
    public Iterable<Chunk> getLoadedChunks() {
        AbstractChunkProvider chunkProvider = ((IWorld)this).func_72863_F();
        if (chunkProvider instanceof ServerChunkProvider) {
            ChunkManagerAccessor chunkManager = (ChunkManagerAccessor)((ServerChunkProvider)chunkProvider).field_217237_a;
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            chunkManager.invoker$getChunks().forEach(holder -> chunks.add((Chunk)holder.func_219298_c()));
            return chunks;
        }
        return Collections.emptyList();
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.getHeight(HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    @Override
    public Vector3i getBlockMin() {
        return Constants.World.BLOCK_MIN;
    }

    @Override
    public Vector3i getBlockMax() {
        return Constants.World.BIOME_MAX;
    }

    @Override
    public Vector3i getBlockSize() {
        return Constants.World.BLOCK_SIZE;
    }

    @Override
    public Context getContext() {
        if (this.impl$context == null) {
            this.impl$context = new Context("world", this.shadow$func_234923_W_().func_240901_a_().toString());
        }
        return this.impl$context;
    }

    @Override
    public void spawnParticles(ParticleEffect particleEffect, org.spongepowered.math.vector.Vector3d position, int radius) {
        Objects.requireNonNull(particleEffect, "particleEffect");
        Objects.requireNonNull(position, "position");
        if (radius <= 0) {
            throw new IllegalArgumentException("The radius has to be greater then zero!");
        }
        SpongeParticleHelper.sendPackets(particleEffect, position, radius, this.shadow$func_234923_W_(), this.shadow$func_73046_m().func_184103_al());
    }

    @Override
    public void playMusicDisc(Vector3i position, MusicDisc musicDisc) {
        this.api$playRecord(Objects.requireNonNull(position, "position"), Objects.requireNonNull(musicDisc, "musicDisc"));
    }

    @Override
    public void stopMusicDisc(Vector3i position) {
        this.api$playRecord(Objects.requireNonNull(position, "position"), null);
    }

    @Override
    public void sendBlockChange(int x, int y, int z, BlockState state) {
        Objects.requireNonNull(state, "state");
        SChangeBlockPacket packet = new SChangeBlockPacket(new BlockPos(x, y, z), (net.minecraft.block.BlockState)state);
        ((net.minecraft.world.World)this).func_217369_A().stream().filter(ServerPlayerEntity.class::isInstance).map(ServerPlayerEntity.class::cast).forEach(p -> p.field_71135_a.func_147359_a((IPacket)packet));
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        SChangeBlockPacket packet = new SChangeBlockPacket((IBlockReader)((IWorldReader)this), new BlockPos(x, y, z));
        ((net.minecraft.world.World)this).func_217369_A().stream().filter(ServerPlayerEntity.class::isInstance).map(ServerPlayerEntity.class::cast).forEach(p -> p.field_71135_a.func_147359_a((IPacket)packet));
    }

    public void playSound(Sound sound, double x, double y, double z) {
        ResourceLocation soundKey = SpongeAdventure.asVanilla(sound.name());
        Optional event = Registry.field_212633_v.func_241873_b(soundKey);
        SoundCategory soundCategory = SpongeAdventure.asVanilla(sound.source());
        if (event.isPresent()) {
            this.shadow$func_184148_a(null, x, y, z, (SoundEvent)event.get(), soundCategory, sound.volume(), sound.pitch());
        } else {
            float volume = sound.volume();
            double radius = volume > 1.0f ? (double)(16.0f * volume) : 16.0;
            SPlaySoundPacket packet = new SPlaySoundPacket(soundKey, soundCategory, new Vector3d(x, y, z), volume, sound.pitch());
            this.shadow$func_73046_m().func_184103_al().func_148543_a(null, x, y, z, radius, this.shadow$func_234923_W_(), (IPacket)packet);
        }
    }

    @Override
    public Collection<? extends BlockEntity> getBlockEntities() {
        return Collections.unmodifiableCollection(this.field_147482_g);
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.shadow$func_175690_a(new BlockPos(x, y, z), (TileEntity)Objects.requireNonNull(blockEntity, "blockEntity"));
    }

    @Override
    public <E extends Entity> E createEntity(EntityType<E> type, org.spongepowered.math.vector.Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return ((WorldBridge)((Object)this)).bridge$createEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(position, "position"), false);
    }

    @Override
    public <E extends Entity> E createEntityNaturally(EntityType<E> type, org.spongepowered.math.vector.Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return ((WorldBridge)((Object)this)).bridge$createEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(position, "position"), true);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container) {
        throw new MissingImplementationException("World", "createEntity(container)");
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container, org.spongepowered.math.vector.Vector3d position) {
        throw new MissingImplementationException("World", "createEntity(container, position)");
    }

    @Override
    public ArchetypeVolume createArchetypeVolume(Vector3i min2, Vector3i max, Vector3i origin) {
        Vector3i rawVolMin = Objects.requireNonNull(Objects.requireNonNull(max, "max"), "min").min(max);
        Vector3i adjustedVolMin = rawVolMin.sub(Objects.requireNonNull(origin, "origin"));
        Vector3i volMax = max.max(min2);
        SpongeArchetypeVolume volume = new SpongeArchetypeVolume(adjustedVolMin, volMax.sub(rawVolMin).add(1, 1, 1), this.registries());
        this.getBlockStateStream(min2, max, StreamOptions.lazily()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyBlocks()));
        this.getBlockEntityStream(min2, max, StreamOptions.lazily()).map((world, blockEntity, x, y, z) -> ((BlockEntity)blockEntity.get()).createArchetype()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyBlockEntityArchetypes()));
        this.getBiomeStream(min2, max, StreamOptions.lazily()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyBiomes()));
        this.getEntityStream(min2, max, StreamOptions.lazily()).map((world, entity, x, y, z) -> ((Entity)entity.get()).createArchetype()).apply(VolumeCollectors.of(volume, VolumePositionTranslators.offset(origin), VolumeApplicators.applyEntityArchetypes()));
        return volume;
    }

    private void api$playRecord(Vector3i position, @javax.annotation.Nullable MusicDisc recordType) {
        this.shadow$func_73046_m().func_184103_al().func_232642_a_((IPacket)SpongeMusicDisc.createPacket(position, recordType), this.shadow$func_234923_W_());
    }
}

