/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.server;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.storage.FolderName;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryScope;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.storage.WorldStorage;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.raid.RaidManagerAccessor;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.mixin.api.mcp.world.WorldMixin_API;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeWorldTemplate;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={net.minecraft.world.server.ServerWorld.class})
@Implements(value={@Interface(iface=ServerWorld.class, prefix="serverWorld$")})
public abstract class ServerWorldMixin_API
extends WorldMixin_API<ServerWorld, ServerLocation>
implements ServerWorld {
    @Shadow
    @Final
    private ServerTickList<Block> field_94579_S;
    @Shadow
    @Final
    private ServerTickList<Fluid> field_205342_P;
    @Shadow
    @Final
    private Int2ObjectMap<net.minecraft.entity.Entity> field_217498_x;

    @Shadow
    public abstract void shadow$func_217445_a(@Nullable IProgressUpdate var1, boolean var2, boolean var3);

    @Shadow
    public abstract void shadow$func_217466_a(net.minecraft.world.chunk.Chunk var1);

    @Override
    @Shadow
    public abstract void shadow$func_184148_a(@Nullable PlayerEntity var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    @Shadow
    public abstract ServerChunkProvider shadow$func_72863_F();

    @Override
    @Nonnull
    @Shadow
    public abstract MinecraftServer shadow$func_73046_m();

    @Nullable
    @Shadow
    public abstract net.minecraft.entity.Entity shadow$func_217461_a(UUID var1);

    @Shadow
    public abstract List<ServerPlayerEntity> shadow$func_217369_A();

    @Shadow
    public abstract RaidManager shadow$func_217452_C();

    @Nullable
    @Shadow
    public abstract Raid shadow$func_217475_c_(BlockPos var1);

    @Shadow
    public abstract long shadow$func_72905_C();

    @Intrinsic
    public long serverWorld$getSeed() {
        return this.shadow$func_72905_C();
    }

    @Override
    public boolean isLoaded() {
        return ((ServerWorldBridge)((Object)this)).bridge$isLoaded();
    }

    @Override
    public ServerLocation getLocation(Vector3i position) {
        return ServerLocation.of((ServerWorld)this, Objects.requireNonNull(position, "position"));
    }

    @Override
    public ServerLocation getLocation(Vector3d position) {
        return ServerLocation.of((ServerWorld)this, Objects.requireNonNull(position, "position"));
    }

    @Override
    public ServerWorldProperties getProperties() {
        return (ServerWorldProperties)this.shadow$func_72912_H();
    }

    @Override
    public ChunkGenerator getGenerator() {
        return (ChunkGenerator)this.shadow$func_72863_F().func_201711_g();
    }

    @Override
    public WorldTemplate asTemplate() {
        return new SpongeWorldTemplate((net.minecraft.world.server.ServerWorld)this);
    }

    @Override
    public ResourceKey getKey() {
        return (ResourceKey)this.shadow$func_234923_W_().func_240901_a_();
    }

    @Override
    public Server getEngine() {
        return (Server)this.shadow$func_73046_m();
    }

    @Override
    public Optional<Chunk> regenerateChunk(int cx, int cy, int cz, ChunkRegenerateFlag flag) {
        throw new MissingImplementationException("ServerWorld", "regenerateChunk");
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        return ((ServerWorldBridge)((Object)this)).bridge$createSnapshot(x, y, z);
    }

    @Override
    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return snapshot.restore(force, Objects.requireNonNull(flag, "flag"));
    }

    @Override
    public boolean restoreSnapshot(int x, int y, int z, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return ((BlockSnapshot)Objects.requireNonNull(snapshot, "snapshot").withLocation((ServerLocation)this.getLocation(x, y, z))).restore(force, Objects.requireNonNull(flag, "flag"));
    }

    @Override
    public Path getDirectory() {
        return ((ServerWorldBridge)((Object)this)).bridge$getLevelSave().func_237285_a_(FolderName.field_237253_i_);
    }

    @Override
    public WorldStorage getWorldStorage() {
        return (WorldStorage)this.shadow$func_72863_F();
    }

    @Override
    public boolean save() throws IOException {
        ((ServerWorldBridge)((Object)this)).bridge$setManualSave(true);
        this.shadow$func_217445_a(null, false, true);
        return true;
    }

    @Override
    public boolean unloadChunk(Chunk chunk) {
        this.shadow$func_217466_a((net.minecraft.world.chunk.Chunk)Objects.requireNonNull(chunk, "chunk"));
        return true;
    }

    @Override
    public void triggerExplosion(Explosion explosion) {
        ((ServerWorldBridge)((Object)this)).bridge$triggerExplosion(Objects.requireNonNull(explosion, "explosion"));
    }

    @Override
    public Collection<ServerPlayer> getPlayers() {
        return Collections.unmodifiableCollection(this.shadow$func_217369_A());
    }

    public Collection<Entity> getEntities() {
        return Collections.unmodifiableCollection(this.field_217498_x.values());
    }

    @Override
    public Collection<org.spongepowered.api.raid.Raid> getRaids() {
        return ((RaidManagerAccessor)this.shadow$func_217452_C()).accessor$raidMap().values();
    }

    @Override
    public Optional<org.spongepowered.api.raid.Raid> getRaidAt(Vector3i blockPosition) {
        return Optional.ofNullable((org.spongepowered.api.raid.Raid)this.shadow$func_217475_c_(VecHelper.toBlockPos(Objects.requireNonNull(blockPosition, "blockPosition"))));
    }

    @Override
    public boolean containsBlock(int x, int y, int z) {
        return World.func_175701_a((BlockPos)new BlockPos(x, y, z));
    }

    @Override
    public Optional<Entity> getEntity(UUID uniqueId) {
        return Optional.ofNullable((Entity)this.shadow$func_217461_a(Objects.requireNonNull(uniqueId, "uniqueId")));
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.shadow$func_175713_t(new BlockPos(x, y, z));
    }

    @Override
    public ScheduledUpdateList<BlockType> getScheduledBlockUpdates() {
        return (ScheduledUpdateList)this.field_94579_S;
    }

    @Override
    public ScheduledUpdateList<FluidType> getScheduledFluidUpdates() {
        return (ScheduledUpdateList)this.field_205342_P;
    }

    @Override
    public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends Value<E>> key, E value) {
        Objects.requireNonNull(value, "value");
        DataProvider<Value<E>, E> dataProvider = SpongeDataManager.getProviderRegistry().getProvider(Objects.requireNonNull(key, "key"), ServerLocation.class);
        return dataProvider.offer(ServerLocation.of((ServerWorld)this, new Vector3d((float)x, (float)y, (float)z)), value);
    }

    @Override
    public <E> Optional<E> get(int x, int y, int z, Key<? extends Value<E>> key) {
        Optional value = SpongeDataManager.getProviderRegistry().getProvider(Objects.requireNonNull(key, "key"), ServerLocation.class).get(ServerLocation.of((ServerWorld)this, new Vector3d((float)x, (float)y, (float)z)));
        if (value.isPresent()) {
            return value;
        }
        return this.getBlock(x, y, z).get(key);
    }

    @Override
    public DataTransactionResult remove(int x, int y, int z, Key<?> key) {
        return SpongeDataManager.getProviderRegistry().getProvider(Objects.requireNonNull(key, "key"), ServerLocation.class).remove(ServerLocation.of((ServerWorld)this, new Vector3d((float)x, (float)y, (float)z)));
    }

    @Override
    public Weather weather() {
        return ((ServerWorldProperties)this.shadow$func_72912_H()).weather();
    }

    @Override
    public void setWeather(WeatherType type) {
        ((ServerWorldProperties)this.shadow$func_72912_H()).setWeather(Objects.requireNonNull(type, "type"));
    }

    @Override
    public void setWeather(WeatherType type, Ticks ticks) {
        ((ServerWorldProperties)this.shadow$func_72912_H()).setWeather(Objects.requireNonNull(type, "type"), Objects.requireNonNull(ticks, "ticks"));
    }

    @Override
    public RegistryScope registryScope() {
        return RegistryScope.WORLD;
    }

    @Override
    public RegistryHolder registries() {
        return ((ServerWorldBridge)((Object)this)).bridge$registries();
    }
}

