/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancements;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.AndCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.advancement.criteria.OrCriterion;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.advancement.criterion.ImplementationBackedCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeAndCriterion;
import org.spongepowered.common.advancement.criterion.SpongeAndCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeEmptyCriterion;
import org.spongepowered.common.advancement.criterion.SpongeOrCriterion;
import org.spongepowered.common.advancement.criterion.SpongeOrCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterion;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterionProgress;
import org.spongepowered.common.bridge.advancements.AdvancementProgressBridge;
import org.spongepowered.common.bridge.advancements.CriterionBridge;
import org.spongepowered.common.bridge.advancements.CriterionProgressBridge;
import org.spongepowered.common.bridge.advancements.PlayerAdvancementsBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;

@Mixin(value={AdvancementProgress.class})
public abstract class AdvancementProgressMixin
implements AdvancementProgressBridge {
    @Shadow
    @Final
    private Map<String, net.minecraft.advancements.CriterionProgress> field_192110_a;
    @Nullable
    private Map<String, ImplementationBackedCriterionProgress> impl$progressMap;
    @Nullable
    private ResourceLocation impl$advancementKey;
    @Nullable
    private PlayerAdvancements impl$playerAdvancements;

    @Override
    public Advancement bridge$getAdvancement() {
        Preconditions.checkState((boolean)PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        Preconditions.checkState((this.impl$advancementKey != null ? 1 : 0) != 0, (Object)"The advancement is not yet initialized");
        net.minecraft.advancements.Advancement advancement = SpongeCommon.getServer().func_191949_aK().func_192778_a(this.impl$advancementKey);
        if (advancement == null) {
            throw new IllegalStateException("The advancement of this advancement progress is unloaded: " + this.impl$advancementKey);
        }
        return (Advancement)advancement;
    }

    @Override
    public PlayerAdvancements bridge$getPlayerAdvancements() {
        Preconditions.checkState((boolean)PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        Preconditions.checkState((this.impl$playerAdvancements != null ? 1 : 0) != 0, (Object)"The playerAdvancements is not yet initialized");
        return this.impl$playerAdvancements;
    }

    @Override
    public void bridge$setPlayerAdvancements(PlayerAdvancements playerAdvancements) {
        Preconditions.checkState((boolean)PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        this.impl$playerAdvancements = playerAdvancements;
    }

    @Override
    public void bridge$setAdvancementId(ResourceLocation key) {
        Preconditions.checkState((boolean)PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        this.impl$advancementKey = key;
    }

    @Override
    public void bridge$invalidateAchievedState() {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        for (ImplementationBackedCriterionProgress progress : this.impl$getProgressMap().values()) {
            progress.invalidateAchievedState();
        }
    }

    @Override
    public void bridge$updateProgressMap() {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        Optional<Advancement> advancement = this.getOptionalAdvancement();
        if (advancement.isPresent()) {
            this.impl$progressMap = new LinkedHashMap<String, ImplementationBackedCriterionProgress>();
            this.impl$processProgressMap(advancement.get().getCriterion(), this.impl$progressMap);
        } else {
            this.impl$progressMap = null;
        }
    }

    @Override
    public Map<String, ImplementationBackedCriterionProgress> bridge$getProgressMap() {
        return this.impl$progressMap;
    }

    @Inject(method={"update"}, at={@At(value="RETURN")})
    private void impl$updateCriterionsAndMap(Map<String, Criterion> criteria, String[][] requirements, CallbackInfo ci) {
        String[][] stringArray = requirements;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] reqs;
            for (String req : reqs = stringArray[i]) {
                if (criteria.containsKey(req)) continue;
                String advName = this.getOptionalAdvancement().map(Objects::toString).orElse("unknown");
                throw new IllegalStateException("Found a requirement which does not exist in the criteria, " + req + " could not be found for the advancement: " + advName);
            }
        }
        this.bridge$updateProgressMap();
    }

    private Map<String, ImplementationBackedCriterionProgress> impl$getProgressMap() {
        Preconditions.checkState((this.impl$progressMap != null ? 1 : 0) != 0, (Object)"progressMap isn't initialized");
        return this.impl$progressMap;
    }

    private void impl$processProgressMap(AdvancementCriterion criterion, Map<String, ImplementationBackedCriterionProgress> progressMap) {
        if (criterion instanceof OperatorCriterion) {
            ((OperatorCriterion)criterion).getCriteria().forEach(child -> this.impl$processProgressMap((AdvancementCriterion)child, progressMap));
            if (criterion instanceof AndCriterion) {
                progressMap.put(criterion.getName(), new SpongeAndCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this), (SpongeAndCriterion)criterion));
            } else if (criterion instanceof OrCriterion) {
                progressMap.put(criterion.getName(), new SpongeOrCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this), (SpongeOrCriterion)criterion));
            }
        } else if (criterion instanceof SpongeScoreCriterion) {
            SpongeScoreCriterion scoreCriterion = (SpongeScoreCriterion)criterion;
            for (AdvancementCriterion advancementCriterion : scoreCriterion.internalCriteria) {
                CriterionProgressBridge progress = (CriterionProgressBridge)this.field_192110_a.get(advancementCriterion.getName());
                progress.bridge$setCriterion(advancementCriterion);
                progress.bridge$setAdvancementProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this));
                progressMap.put(advancementCriterion.getName(), (ImplementationBackedCriterionProgress)((Object)progress));
            }
            progressMap.put(scoreCriterion.getName(), new SpongeScoreCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this), scoreCriterion));
        } else if (!(criterion instanceof SpongeEmptyCriterion)) {
            CriterionProgressBridge progress = (CriterionProgressBridge)this.field_192110_a.get(criterion.getName());
            progress.bridge$setCriterion(criterion);
            progress.bridge$setAdvancementProgress((org.spongepowered.api.advancement.AdvancementProgress)((Object)this));
            progressMap.put(criterion.getName(), (ImplementationBackedCriterionProgress)((Object)progress));
        }
    }

    @Inject(method={"isDone"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$supportComplexCriteria(CallbackInfoReturnable<Boolean> ci) {
        if (this.impl$advancementKey == null || !PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        Advancement advancement = this.getOptionalAdvancement().orElse(null);
        if (advancement != null) {
            ImplementationBackedCriterionProgress bridge = this.impl$progressMap.get(advancement.getCriterion().getName());
            ci.setReturnValue((Object)(bridge != null && ((CriterionProgress)((Object)bridge)).achieved() ? 1 : 0));
        }
    }

    @Inject(method={"grantProgress"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$grantScoreCriteriaAndCallEvents(String criterion, CallbackInfoReturnable<Boolean> ci) {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        ci.setReturnValue((Object)this.impl$grantCriterion(criterion));
    }

    private boolean impl$grantCriterion(String rawCriterion) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.field_192110_a.get(rawCriterion);
        if (criterionProgress == null || criterionProgress.func_192151_a()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.func_192153_b();
            return true;
        }
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        ServerPlayer player = ((PlayerAdvancementsBridge)this.impl$playerAdvancements).bridge$getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.getCriterion();
        CriterionBridge criterionBridge = (CriterionBridge)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = criterionBridge.bridge$getScoreCriterion();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.impl$progressMap.get(scoreCriterion.getName());
            int lastScore = scoreProgress.getScore();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, this.bridge$getAdvancement(), scoreCriterion, player, lastScore, score) : (score == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, this.bridge$getAdvancement(), scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, this.bridge$getAdvancement(), scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventGrant(cause, this.bridge$getAdvancement(), criterion, player, Instant.now());
        }
        if (SpongeCommon.postEvent(event)) {
            return false;
        }
        criterionProgress.func_192153_b();
        return true;
    }

    @Inject(method={"revokeProgress"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$removeScoreCriteriaAndCallEvents(String rawCriterion, CallbackInfoReturnable<Boolean> ci) {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        ci.setReturnValue((Object)this.impl$revokeCriterion(rawCriterion));
    }

    private boolean impl$revokeCriterion(String rawCriterion) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.field_192110_a.get(rawCriterion);
        if (criterionProgress == null || !criterionProgress.func_192151_a()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.func_192154_c();
            return true;
        }
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        ServerPlayer player = ((PlayerAdvancementsBridge)this.impl$playerAdvancements).bridge$getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.getCriterion();
        CriterionBridge criterionBridge = (CriterionBridge)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = criterionBridge.bridge$getScoreCriterion();
        Advancement advancement = ((org.spongepowered.api.advancement.AdvancementProgress)((Object)this)).getAdvancement();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.impl$progressMap.get(scoreCriterion.getName());
            int lastScore = scoreProgress.getScore();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, advancement, scoreCriterion, player, lastScore, score) : (score == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, advancement, scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, advancement, scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventRevoke(cause, advancement, criterion, player);
        }
        if (SpongeCommon.postEvent(event)) {
            return false;
        }
        criterionProgress.func_192154_c();
        return true;
    }

    private Optional<Advancement> getOptionalAdvancement() {
        Preconditions.checkState((boolean)PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        Preconditions.checkState((this.impl$advancementKey != null ? 1 : 0) != 0, (Object)"The advancement is not yet initialized");
        net.minecraft.advancements.Advancement advancement = SpongeCommon.getServer().func_191949_aK().func_192778_a(this.impl$advancementKey);
        return Optional.ofNullable((Advancement)advancement);
    }
}

