/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.block.FallingBlock.class})
public abstract class FallingBlockMixin {
    @Redirect(method={"tick(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;getY()I"))
    public int impl$checkFallable(BlockPos pos, BlockState state, net.minecraft.world.server.ServerWorld world, BlockPos samePos, Random random, CallbackInfo ci) {
        if (pos.func_177956_o() < 0) {
            return pos.func_177956_o();
        }
        if (!ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE) {
            return pos.func_177956_o();
        }
        EntityType<FallingBlock> fallingBlock = EntityTypes.FALLING_BLOCK.get();
        ServerWorld spongeWorld = (ServerWorld)world;
        BlockSnapshot snapshot = spongeWorld.createSnapshot(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(snapshot);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.FALLING_BLOCK);
            ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), ServerLocation.of((ServerWorld)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5), new Vector3d(0.0f, 0.0f, 0.0f), fallingBlock);
            if (SpongeCommon.postEvent(event)) {
                int n = -1;
                return n;
            }
            int n = pos.func_177956_o();
            return n;
        }
    }
}

