/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import net.minecraft.block.BlockState;
import net.minecraft.block.NoteBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={NoteBlock.class})
public abstract class NoteBlockMixin
extends BlockMixin {
    @Inject(method={"triggerEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V")}, cancellable=true)
    private void impl$throwNoteBlockSoundEvent(BlockState state, World worldIn, BlockPos pos, int id, int param, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (!ShouldFire.PLAY_SOUND_EVENT_NOTE_BLOCK) {
            return;
        }
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151579_a) {
            return;
        }
        InstrumentType instrumentType = ((ServerWorld)worldIn).getBlock(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()).get(Keys.REPRESENTED_INSTRUMENT).orElse(null);
        if (instrumentType == null) {
            return;
        }
        float pitch = (float)Math.pow(2.0, (double)(param - 12) / 12.0);
        SimpleRegistry registry = (SimpleRegistry)Sponge.getGame().registries().registry(RegistryTypes.NOTE_PITCH);
        PlaySoundEvent.NoteBlock event = SpongeCommonEventFactory.callPlaySoundNoteBlockEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (ServerWorld)worldIn, pos, NoteBlockInstrument.func_208087_a((BlockState)state).func_208088_a(), instrumentType, (NotePitch)registry.func_148745_a(param), Float.valueOf(pitch));
        if (event.isCancelled()) {
            callbackInfo.setReturnValue((Object)true);
        }
    }
}

