/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.TNTBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.entity.item.EntityTNTPrimedBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={TNTBlock.class})
public abstract class TNTBlockMixin
extends BlockMixin {
    private boolean primeCancelled;

    private boolean impl$onRemove(World world, BlockPos pos, boolean isMoving) {
        boolean removed = !this.primeCancelled && world.func_217377_a(pos, isMoving);
        this.primeCancelled = false;
        return removed;
    }

    @Inject(method={"explode(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;addFreshEntity(Lnet/minecraft/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private static void impl$ThrowPrimeAndMaybeCancel(World worldIn, BlockPos pos, @Nullable LivingEntity igniter, CallbackInfo ci, TNTEntity tnt) {
        ((EntityTNTPrimedBridge)tnt).bridge$setDetonator(igniter);
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                if (igniter != null) {
                    frame.addContext(EventContextKeys.IGNITER, (Living)igniter);
                }
                if (!((FusedExplosiveBridge)tnt).bridge$shouldPrime()) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"wasExploded"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;addFreshEntity(Lnet/minecraft/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void impl$CheckIfCanPrimeFromExplosion(World worldIn, BlockPos pos, Explosion explosionIn, CallbackInfo ci, TNTEntity tnt) {
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.DAMAGE_TYPE, DamageTypes.EXPLOSIVE);
                if (!((FusedExplosiveBridge)tnt).bridge$shouldPrime()) {
                    ci.cancel();
                }
            }
        }
    }

    @Redirect(method={"onPlace"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z"))
    private boolean impl$removePostSetAir(World world, BlockPos pos, boolean isMoving) {
        return this.impl$onRemove(world, pos, isMoving);
    }

    @Redirect(method={"neighborChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z"))
    private boolean impl$removeNeighbor(World world, BlockPos pos, boolean isMoving) {
        return this.impl$onRemove(world, pos, isMoving);
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlock(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z"))
    private boolean impl$removeActivated(World world, BlockPos pos, BlockState state, int flag) {
        boolean removed = !this.primeCancelled && world.func_180501_a(pos, state, flag);
        this.primeCancelled = false;
        return removed;
    }

    @Redirect(method={"onProjectileHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z"))
    private boolean impl$removeonCollide(World world, BlockPos pos, boolean isMoving) {
        return this.impl$onRemove(world, pos, isMoving);
    }
}

