/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command;

import com.mojang.brigadier.ResultConsumer;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.accessor.command.CommandSourceAccessor;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.bridge.command.CommandSourceBridge;
import org.spongepowered.common.bridge.command.ICommandSourceBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.service.server.permission.SpongePermissions;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={CommandSource.class})
public abstract class CommandSourceMixin
implements CommandSourceBridge {
    private static final String PROTECTED_CTOR = "(Lnet/minecraft/command/ICommandSource;Lnet/minecraft/util/math/vector/Vector3d;Lnet/minecraft/util/math/vector/Vector2f;Lnet/minecraft/world/server/ServerWorld;ILjava/lang/String;Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/entity/Entity;ZLcom/mojang/brigadier/ResultConsumer;Lnet/minecraft/command/arguments/EntityAnchorArgument$Type;)";
    private static final String PROTECTED_CTOR_METHOD = "<init>(Lnet/minecraft/command/ICommandSource;Lnet/minecraft/util/math/vector/Vector3d;Lnet/minecraft/util/math/vector/Vector2f;Lnet/minecraft/world/server/ServerWorld;ILjava/lang/String;Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/entity/Entity;ZLcom/mojang/brigadier/ResultConsumer;Lnet/minecraft/command/arguments/EntityAnchorArgument$Type;)V";
    @Shadow
    @Final
    private ICommandSource field_197041_c;
    @Shadow
    @Final
    @Mutable
    private Vector3d field_197042_d;
    @Shadow
    @Final
    @Mutable
    private Vector2f field_201012_n;
    @Shadow
    @Final
    @Mutable
    private net.minecraft.world.server.ServerWorld field_197043_e;
    @Shadow
    @Final
    @Mutable
    private int field_197044_f;
    @Shadow
    @Final
    private ITextComponent field_197046_h;
    @Shadow
    @Final
    private String field_197045_g;
    @Shadow
    @Final
    private @Nullable Entity field_197049_k;
    @Shadow
    @Final
    private MinecraftServer field_197047_i;
    @Shadow
    @Final
    private boolean field_197048_j;
    @Shadow
    @Final
    private ResultConsumer<CommandSource> field_197050_l;
    @Shadow
    @Final
    private EntityAnchorArgument.Type field_201011_m;
    private Cause impl$cause;
    private @Nullable Supplier<String> impl$potentialPermissionNode = null;

    @Inject(method={"<init>(Lnet/minecraft/command/ICommandSource;Lnet/minecraft/util/math/vector/Vector3d;Lnet/minecraft/util/math/vector/Vector2f;Lnet/minecraft/world/server/ServerWorld;ILjava/lang/String;Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/entity/Entity;ZLcom/mojang/brigadier/ResultConsumer;Lnet/minecraft/command/arguments/EntityAnchorArgument$Type;)V"}, at={@At(value="RETURN")})
    private void impl$setCauseOnConstruction(ICommandSource p_i49553_1_, Vector3d p_i49553_2_, Vector2f p_i49553_3_, net.minecraft.world.server.ServerWorld p_i49553_4_, int p_i49553_5_, String p_i49553_6_, ITextComponent p_i49553_7_, MinecraftServer p_i49553_8_, @Nullable Entity p_i49553_9_, boolean p_i49553_10_, ResultConsumer<CommandSource> p_i49553_11_, EntityAnchorArgument.Type p_i49553_12_, CallbackInfo ci) {
        this.impl$cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        EventContext context = this.impl$cause.getContext();
        context.get(EventContextKeys.LOCATION).ifPresent(x -> {
            this.field_197042_d = VecHelper.toVanillaVector3d(x.getPosition());
            this.field_197043_e = (net.minecraft.world.server.ServerWorld)x.getWorld();
        });
        context.get(EventContextKeys.ROTATION).ifPresent(x -> {
            this.field_201012_n = new Vector2f((float)x.getX(), (float)x.getY());
        });
        context.get(EventContextKeys.SUBJECT).ifPresent(x -> {
            if (x instanceof EntityAccessor) {
                this.field_197044_f = ((EntityAccessor)((Object)x)).invoker$getPermissionLevel();
            } else if (x instanceof MinecraftServer && !((MinecraftServer)x).func_71264_H()) {
                this.field_197044_f = 4;
            }
        });
    }

    @Inject(method={"withEntity", "withPosition", "withRotation(Lnet/minecraft/util/math/vector/Vector2f;)Lnet/minecraft/command/CommandSource;", "withCallback(Lcom/mojang/brigadier/ResultConsumer;)Lnet/minecraft/command/CommandSource;", "withSuppressedOutput", "withPermission", "withMaximumPermission", "withAnchor", "withLevel"}, at={@At(value="RETURN")})
    private void impl$copyPermissionOnCopy(CallbackInfoReturnable<CommandSource> cir) {
        if (cir.getReturnValue() != this) {
            CommandSourceBridge commandSourceBridge = (CommandSourceBridge)cir.getReturnValue();
            commandSourceBridge.bridge$setPotentialPermissionNode(this.impl$potentialPermissionNode);
            commandSourceBridge.bridge$setCause(this.impl$cause);
        }
    }

    @Override
    public CommandCause bridge$withCurrentCause() {
        return (CommandCause)CommandSourceAccessor.invoker$new(this.field_197041_c, this.field_197042_d, this.field_201012_n, this.field_197043_e, this.field_197044_f, this.field_197045_g, this.field_197046_h, this.field_197047_i, this.field_197049_k, this.field_197048_j, this.field_197050_l, this.field_201011_m);
    }

    @Inject(method={"withLevel"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithWorld(net.minecraft.world.server.ServerWorld serverWorld, CallbackInfoReturnable<CommandSource> cir) {
        if (cir.getReturnValue() != this) {
            ServerLocation location = this.impl$cause.getContext().get(EventContextKeys.LOCATION).map(x -> ServerLocation.of((ServerWorld)serverWorld, x.getPosition())).orElseGet(() -> ServerLocation.of((ServerWorld)serverWorld, VecHelper.toVector3d(((CommandSource)cir.getReturnValue()).func_197036_d())));
            ((CommandSourceBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.LOCATION, location));
        }
    }

    @Inject(method={"withPosition"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithPosition(Vector3d pos, CallbackInfoReturnable<CommandSource> cir) {
        if (cir.getReturnValue() != this) {
            org.spongepowered.math.vector.Vector3d position = VecHelper.toVector3d(pos);
            ServerLocation location = this.impl$cause.getContext().get(EventContextKeys.LOCATION).map(x -> ServerLocation.of((ServerWorld)x.getWorld(), position)).orElseGet(() -> ServerLocation.of((ServerWorld)((CommandSource)cir.getReturnValue()).func_197023_e(), position));
            ((CommandSourceBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.LOCATION, location));
        }
    }

    @Inject(method={"withRotation(Lnet/minecraft/util/math/vector/Vector2f;)Lnet/minecraft/command/CommandSource;"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithRotation(Vector2f rotation, CallbackInfoReturnable<CommandSource> cir) {
        if (cir.getReturnValue() != this) {
            org.spongepowered.math.vector.Vector3d rot = new org.spongepowered.math.vector.Vector3d(rotation.field_189982_i, rotation.field_189983_j, 0.0f);
            ((CommandSourceBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.ROTATION, rot));
        }
    }

    @Inject(method={"hasPermission"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$checkPermission(int opLevel, CallbackInfoReturnable<Boolean> cir) {
        if (this.impl$potentialPermissionNode != null) {
            String perm = this.impl$potentialPermissionNode.get();
            SpongePermissions.registerPermission(perm, opLevel);
            cir.setReturnValue((Object)((CommandCause)((Object)this)).hasPermission(perm));
        }
    }

    @Override
    public void bridge$setPotentialPermissionNode(@Nullable Supplier<String> permission) {
        this.impl$potentialPermissionNode = permission;
    }

    @Override
    public void bridge$setCause(Cause cause) {
        this.impl$cause = cause;
    }

    @Override
    public Cause bridge$getCause() {
        return this.impl$cause;
    }

    @Override
    public ICommandSource bridge$getICommandSource() {
        return this.field_197041_c;
    }

    @Override
    public void bridge$updateFrameFromICommandSource(CauseStackManager.StackFrame frame) {
        ((ICommandSourceBridge)this.field_197041_c).bridge$addToCauseStack(frame);
    }

    @Override
    public CommandCause bridge$asCommandCause() {
        return (CommandCause)((Object)this);
    }

    private <T> Cause impl$applyToCause(EventContextKey<T> key, T value) {
        EventContext.Builder builder = EventContext.builder().from(this.impl$cause.getContext());
        builder.add(key, value);
        return Cause.builder().from(this.impl$cause).build(builder.build());
    }
}

