/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.EntityTypeBridge;
import org.spongepowered.common.bridge.entity.LivingEntityBridge;
import org.spongepowered.common.bridge.entity.PlatformLivingEntityBridge;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.cause.entity.damage.DamageEventHandler;
import org.spongepowered.common.event.cause.entity.damage.SpongeDamageSources;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.EntityMixin;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements LivingEntityBridge,
PlatformLivingEntityBridge {
    @Shadow
    public int field_70737_aN;
    @Shadow
    public int field_70738_aO;
    @Shadow
    public float field_70739_aP;
    @Shadow
    public float field_70721_aZ;
    @Shadow
    protected int field_70708_bq;
    @Shadow
    protected int field_70718_bc;
    @Shadow
    protected int field_184628_bn;
    @Shadow
    protected float field_110153_bc;
    @Shadow
    @Nullable
    protected PlayerEntity field_70717_bb;
    @Shadow
    private DamageSource field_189750_bF;
    @Shadow
    private long field_189751_bG;
    @Shadow
    protected boolean field_70729_aU;
    @Shadow
    public int field_70725_aQ;
    @Shadow
    protected int field_70744_aE;
    @Shadow
    protected ItemStack field_184627_bm;
    @Nullable
    private ItemStack impl$activeItemStackCopy;
    @Nullable
    private Vector3d impl$preTeleportPosition;
    private int impl$deathEventsPosted;
    private int impl$maxAir = this.shadow$func_205010_bg();

    @Shadow
    public abstract ModifiableAttributeInstance shadow$func_110148_a(Attribute var1);

    @Shadow
    public abstract void shadow$func_70606_j(float var1);

    @Shadow
    public abstract void shadow$func_233627_a_(float var1, double var2, double var4);

    @Shadow
    public abstract void shadow$func_70604_c(LivingEntity var1);

    @Shadow
    public abstract void shadow$func_110149_m(float var1);

    @Shadow
    public abstract void shadow$func_184611_a(Hand var1, @Nullable ItemStack var2);

    @Shadow
    public abstract void shadow$func_184602_cy();

    @Shadow
    public abstract int shadow$func_184605_cv();

    @Shadow
    public abstract float shadow$func_110139_bj();

    @Shadow
    public abstract float shadow$func_110143_aJ();

    @Shadow
    public abstract boolean shadow$func_70644_a(Effect var1);

    @Shadow
    protected abstract boolean shadow$func_184583_d(DamageSource var1);

    @Shadow
    public abstract ItemStack shadow$func_184582_a(EquipmentSlotType var1);

    @Shadow
    public abstract ItemStack shadow$func_184614_ca();

    @Shadow
    public abstract CombatTracker shadow$func_110142_aN();

    @Shadow
    public void shadow$func_174812_G() {
    }

    @Shadow
    public abstract Hand shadow$func_184600_cs();

    @Shadow
    protected abstract void shadow$func_70018_K();

    @Shadow
    protected abstract void shadow$func_184590_k(float var1);

    @Shadow
    protected abstract void shadow$func_184581_c(DamageSource var1);

    @Shadow
    protected abstract void shadow$func_190629_c(LivingEntity var1);

    @Shadow
    protected abstract float shadow$func_70599_aP();

    @Shadow
    protected abstract float shadow$func_70647_i();

    @Shadow
    protected abstract SoundEvent shadow$func_184615_bR();

    @Shadow
    public abstract boolean shadow$func_70608_bn();

    @Shadow
    public abstract Optional<BlockPos> shadow$func_213374_dv();

    @Shadow
    private boolean shadow$func_190628_d(DamageSource p_190628_1_) {
        return false;
    }

    @Shadow
    public abstract void shadow$func_70645_a(DamageSource var1);

    @Shadow
    protected abstract void shadow$func_195062_a(ItemStack var1, int var2);

    @Shadow
    public abstract void shadow$func_213366_dy();

    @Shadow
    protected abstract void shadow$func_70665_d(DamageSource var1, float var2);

    @Shadow
    public abstract boolean shadow$func_70617_f_();

    @Shadow
    public abstract void shadow$func_70031_b(boolean var1);

    @Shadow
    public abstract void shadow$func_130011_c(net.minecraft.entity.Entity var1);

    @Shadow
    protected abstract void shadow$func_230294_b_(DamageSource var1, float var2);

    @Shadow
    public abstract ItemStack shadow$func_184586_b(Hand var1);

    @Shadow
    protected abstract void shadow$func_213337_cE();

    @Shadow
    protected abstract void shadow$func_213345_d(DamageSource var1);

    @Shadow
    @Nullable
    public abstract LivingEntity shadow$func_94060_bK();

    @Shadow
    protected abstract void shadow$func_226298_f_(@Nullable LivingEntity var1);

    @Shadow
    public abstract Collection<EffectInstance> shadow$func_70651_bq();

    @Shadow
    public abstract float shadow$func_110138_aP();

    @Shadow
    public abstract AttributeModifierManager shadow$func_233645_dx_();

    @Override
    public boolean bridge$damageEntity(DamageSource damageSource, float damage) {
        if (this.shadow$func_180431_b(damageSource)) {
            return false;
        }
        boolean isHuman = (LivingEntity)this instanceof PlayerEntity;
        float originalDamage = damage = this.bridge$applyModDamage((LivingEntity)this, damageSource, damage);
        if (damage <= 0.0f) {
            return false;
        }
        ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
        Optional<DamageFunction> hardHatFunction = DamageEventHandler.createHardHatModifier((LivingEntity)this, damageSource);
        Optional<DamageFunction> armorFunction = DamageEventHandler.createArmorModifiers((LivingEntity)this, damageSource);
        Optional<DamageFunction> resistanceFunction = DamageEventHandler.createResistanceModifier((LivingEntity)this, damageSource);
        Optional<List<DamageFunction>> armorEnchantments = DamageEventHandler.createEnchantmentModifiers((LivingEntity)this, damageSource);
        Optional<DamageFunction> absorptionFunction = DamageEventHandler.createAbsorptionModifier((LivingEntity)this);
        Optional<DamageFunction> shieldFunction = DamageEventHandler.createShieldFunction((LivingEntity)this, damageSource, damage);
        hardHatFunction.ifPresent(originalFunctions::add);
        shieldFunction.ifPresent(originalFunctions::add);
        armorFunction.ifPresent(originalFunctions::add);
        resistanceFunction.ifPresent(originalFunctions::add);
        armorEnchantments.ifPresent(originalFunctions::addAll);
        absorptionFunction.ifPresent(originalFunctions::add);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            float f2;
            DamageEventHandler.generateCauseFor(damageSource, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), originalFunctions, originalDamage);
            if (damageSource != SpongeDamageSources.IGNORED) {
                SpongeCommon.postEvent(event);
            }
            if (event.isCancelled()) {
                boolean bl = false;
                return bl;
            }
            damage = (float)event.getFinalDamage();
            damage = this.bridge$applyModDamageBeforeFunctions((LivingEntity)this, damageSource, damage);
            ItemStack helmet = this.shadow$func_184582_a(EquipmentSlotType.HEAD);
            if (damageSource instanceof FallingBlockDamageSource || damageSource == DamageSource.field_82728_o || damageSource == DamageSource.field_82729_p && !helmet.func_190926_b()) {
                helmet.func_222118_a((int)(event.getBaseDamage() * 4.0 + (double)this.field_70146_Z.nextFloat() * event.getBaseDamage() * 2.0), (LivingEntity)this, entity -> entity.func_213361_c(EquipmentSlotType.HEAD));
            }
            if (shieldFunction.isPresent()) {
                net.minecraft.entity.Entity entity2;
                this.shadow$func_184590_k((float)event.getBaseDamage());
                if (!damageSource.func_76352_a() && (entity2 = damageSource.func_76364_f()) instanceof LivingEntity) {
                    this.shadow$func_190629_c((LivingEntity)entity2);
                }
            }
            if (!damageSource.func_76363_c() && armorFunction.isPresent()) {
                this.shadow$func_230294_b_(damageSource, (float)event.getBaseDamage());
            }
            if (resistanceFunction.isPresent() && (f2 = (float)event.getDamage(resistanceFunction.get().getModifier()) - damage) > 0.0f && f2 < 3.4028235E37f) {
                if ((LivingEntity)this instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)((LivingEntity)this)).func_195067_a(Stats.field_212739_K, Math.round(f2 * 10.0f));
                } else if (damageSource.func_76346_g() instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)damageSource.func_76346_g()).func_195067_a(Stats.field_212736_G, Math.round(f2 * 10.0f));
                }
            }
            double absorptionModifier = absorptionFunction.map(function -> event.getDamage(function.getModifier())).orElse(0.0);
            if (absorptionFunction.isPresent()) {
                absorptionModifier = event.getDamage(absorptionFunction.get().getModifier());
            }
            float f = (float)event.getFinalDamage() - (float)absorptionModifier;
            this.shadow$func_110149_m(Math.max(this.shadow$func_110139_bj() + (float)absorptionModifier, 0.0f));
            if (f > 0.0f && f < 3.4028235E37f && damageSource.func_76346_g() instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)damageSource.func_76346_g()).func_195067_a(Stats.field_212735_F, Math.round(f * 10.0f));
            }
            if (damage != 0.0f) {
                if (isHuman) {
                    ((PlayerEntity)this).func_71020_j(damageSource.func_76345_d());
                }
                float f22 = this.shadow$func_110143_aJ();
                this.shadow$func_70606_j(f22 - damage);
                this.shadow$func_110142_aN().func_94547_a(damageSource, f22, damage);
                if (isHuman) {
                    boolean bl = true;
                    return bl;
                }
                this.shadow$func_110149_m(this.shadow$func_110139_bj() - damage);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Inject(method={"setHealth"}, at={@At(value="HEAD")})
    private void impl$resetDeathEventCounter(float health, CallbackInfo info) {
        if (this.shadow$func_110143_aJ() <= 0.0f && health > 0.0f) {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Redirect(method={"dropExperience()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getExperienceReward(Lnet/minecraft/entity/player/PlayerEntity;)I"))
    protected int impl$exposeGetExperienceForDeath(LivingEntity entity, PlayerEntity attackingPlayer) {
        return this.bridge$getExperiencePointsOnDeath(entity, attackingPlayer);
    }

    @Overwrite
    protected void func_70665_d(DamageSource damageSource, float damage) {
        this.bridge$damageEntity(damageSource, damage);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwDestructEntityDeath(DamageSource cause, CallbackInfo ci) {
        boolean throwEvent;
        boolean bl = throwEvent = !((WorldBridge)this.field_70170_p).bridge$isFake() && Sponge.isServerAvailable() && Sponge.getServer().onMainThread();
        if (!this.field_70729_aU) {
            if (throwEvent && this.impl$deathEventsPosted <= 3) {
                ++this.impl$deathEventsPosted;
                if (SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)this, cause).isCancelled()) {
                    ci.cancel();
                }
            }
        } else {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;broadcastEntityEvent(Lnet/minecraft/entity/Entity;B)V")}, cancellable=true)
    private void impl$doNotSendStateForHumans(DamageSource cause, CallbackInfo ci) {
        if ((LivingEntity)this instanceof HumanEntity) {
            ci.cancel();
        }
    }

    @Redirect(method={"dropAllDeathLoot"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;dropEquipment()V"))
    private void tracker$dropInventory(LivingEntity thisEntity) {
        if (thisEntity instanceof PlayerEntityBridge && ((PlayerEntityBridge)thisEntity).bridge$keepInventory()) {
            return;
        }
        this.shadow$func_213337_cE();
    }

    @Overwrite
    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag2;
        boolean flag;
        this.field_189750_bF = source;
        if (source == null) {
            new PrettyPrinter(60).centre().add("Null DamageSource").hr().addWrapped("Sponge has found a null damage source! This should NEVER happen as the DamageSource is used for all sorts of calculations. Usually this can be considered developer error. Please report the following stacktrace to the most appropriate mod/plugin available.", new Object[0]).add().add(new IllegalArgumentException("Null DamageSource")).log(SpongeCommon.getLogger(), Level.WARN);
            return false;
        }
        if (!this.bridge$onLivingAttack((LivingEntity)this, source, amount)) {
            return false;
        }
        if (this.shadow$func_180431_b(source)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.shadow$func_110143_aJ() <= 0.0f && source != SpongeDamageSources.IGNORED) {
            return false;
        }
        if (source.func_76347_k() && this.shadow$func_70644_a(Effects.field_76426_n)) {
            return false;
        }
        if (this.shadow$func_70608_bn() && !this.field_70170_p.field_72995_K) {
            this.shadow$func_213366_dy();
        }
        this.field_70708_bq = 0;
        float f = amount;
        float f1 = 0.0f;
        boolean bl = flag = amount > 0.0f && this.shadow$func_184583_d(source);
        if (flag) {
            f1 = amount;
        }
        this.field_70721_aZ = 1.5f;
        boolean flag1 = true;
        if ((float)this.field_70172_ad > 10.0f) {
            if (amount <= this.field_110153_bc) {
                return false;
            }
            if (((EntityTypeBridge)this.shadow$func_200600_R()).bridge$overridesDamageEntity()) {
                this.shadow$func_70665_d(source, amount - this.field_110153_bc);
            } else if (!this.bridge$damageEntity(source, amount - this.field_110153_bc)) {
                return false;
            }
            this.field_110153_bc = amount;
            flag1 = false;
        } else {
            if (((EntityTypeBridge)this.shadow$func_200600_R()).bridge$overridesDamageEntity()) {
                this.shadow$func_70665_d(source, amount);
            } else if (!this.bridge$damageEntity(source, amount)) {
                return false;
            }
            this.field_110153_bc = amount;
            this.field_70172_ad = 20;
            this.field_70737_aN = this.field_70738_aO = 10;
        }
        this.field_70739_aP = 0.0f;
        net.minecraft.entity.Entity entity = source.func_76346_g();
        if (entity != null) {
            TameableEntity wolfentity;
            if (entity instanceof LivingEntity) {
                this.shadow$func_70604_c((LivingEntity)entity);
            }
            if (entity instanceof PlayerEntity) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (PlayerEntity)entity;
            } else if (entity instanceof TameableEntity && (wolfentity = (TameableEntity)entity).func_70909_n()) {
                this.field_70718_bc = 100;
                LivingEntity livingentity = wolfentity.func_70902_q();
                this.field_70717_bb = livingentity != null && livingentity.func_200600_R() == EntityType.field_200729_aH ? (PlayerEntity)livingentity : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.field_70170_p.func_72960_a((net.minecraft.entity.Entity)((LivingEntity)this), (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                this.field_70170_p.func_72960_a((net.minecraft.entity.Entity)((LivingEntity)this), (byte)33);
            } else {
                byte b0 = source == DamageSource.field_76369_e ? (byte)36 : (source.func_76347_k() ? (byte)37 : (source == DamageSource.field_220302_v ? (byte)44 : 2));
                this.field_70170_p.func_72960_a((net.minecraft.entity.Entity)((LivingEntity)this), b0);
            }
            if (source != DamageSource.field_76369_e && !flag) {
                this.shadow$func_70018_K();
            }
            if (entity != null) {
                double d1 = entity.func_226277_ct_() - this.shadow$func_226277_ct_();
                double d0 = entity.func_226281_cx_() - this.shadow$func_226281_cx_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.2957763671875 - (double)this.field_70177_z);
                this.shadow$func_233627_a_(0.4f, d1, d0);
            } else {
                this.field_70739_aP = (float)(Math.random() * 2.0 * 180.0);
            }
        }
        if (this.shadow$func_110143_aJ() <= 0.0f) {
            if (!this.shadow$func_190628_d(source)) {
                SoundEvent soundevent = this.shadow$func_184615_bR();
                if (!this.bridge$isVanished() && flag1 && soundevent != null) {
                    this.shadow$func_184185_a(soundevent, this.shadow$func_70599_aP(), this.shadow$func_70647_i());
                }
                this.shadow$func_70645_a(source);
            }
        } else if (flag1 && !this.bridge$isVanished()) {
            this.shadow$func_184581_c(source);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.field_189750_bF = source;
            this.field_189751_bG = this.field_70170_p.func_82737_E();
        }
        if ((LivingEntity)this instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192128_h.func_192200_a((ServerPlayerEntity)this, source, f, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                ((ServerPlayerEntity)this).func_195067_a(Stats.field_212737_I, Math.round(f1 * 10.0f));
            }
        }
        if (entity instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192127_g.func_192220_a((ServerPlayerEntity)entity, (net.minecraft.entity.Entity)this, source, f, amount, flag);
        }
        return flag2;
    }

    @Redirect(method={"triggerItemUseEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;spawnItemParticles(Lnet/minecraft/item/ItemStack;I)V"))
    private void impl$hideItemParticlesIfVanished(LivingEntity livingEntity, ItemStack stack, int count) {
        if (!this.bridge$isVanished()) {
            this.shadow$func_195062_a(stack, count);
        }
    }

    @Inject(method={"randomTeleport"}, at={@At(value="HEAD")})
    private void impl$snapshotPositionBeforeVanillaTeleportLogic(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        this.impl$preTeleportPosition = new Vector3d(this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_());
    }

    @Inject(method={"randomTeleport"}, at={@At(value="RETURN", ordinal=0, shift=At.Shift.BY, by=2)}, cancellable=true)
    private void impl$callMoveEntityEventForTeleport(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        if (!ShouldFire.MOVE_ENTITY_EVENT) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            MoveEntityEvent event;
            frame.pushCause(this);
            if (!frame.getCurrentContext().containsKey(EventContextKeys.MOVEMENT_TYPE)) {
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.ENTITY_TELEPORT);
            }
            if (SpongeCommon.postEvent(event = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), this.impl$preTeleportPosition, new Vector3d(this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_()), new Vector3d(x, y, z)))) {
                this.shadow$func_70634_a(this.impl$preTeleportPosition.getX(), this.impl$preTeleportPosition.getY(), this.impl$preTeleportPosition.getZ());
                cir.setReturnValue((Object)false);
                return;
            }
            this.shadow$func_70634_a(event.getDestinationPosition().getX(), event.getDestinationPosition().getY(), event.getDestinationPosition().getZ());
        }
    }

    @Inject(method={"startUsingItem"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="FIELD", target="Lnet/minecraft/entity/LivingEntity;useItem:Lnet/minecraft/item/ItemStack;")})
    private void impl$onSetActiveItemStack(Hand hand, CallbackInfo ci, ItemStack stack) {
        UseItemStackEvent.Start event;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)hand;
            this.impl$addSelfToFrame(frame, snapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventStart(PhaseTracker.getCauseStackManager().getCurrentCause(), stack.func_77988_m(), stack.func_77988_m(), snapshot);
        }
        if (SpongeCommon.postEvent(event)) {
            ci.cancel();
        } else {
            this.field_184628_bn = event.getRemainingDuration();
        }
    }

    @Redirect(method={"startUsingItem"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/LivingEntity;useItemRemaining:I"))
    private void impl$getItemDuration(LivingEntity this$0, int count) {
        if (this.field_70170_p.field_72995_K) {
            this.field_184628_bn = count;
        }
    }

    private void impl$addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot, HandType hand) {
        frame.addContext(EventContextKeys.USED_HAND, hand);
        this.impl$addSelfToFrame(frame, snapshot);
    }

    private void impl$addSelfToFrame(CauseStackManager.StackFrame frame, ItemStackSnapshot snapshot) {
        frame.pushCause(this);
        frame.addContext(EventContextKeys.USED_ITEM, snapshot);
        if (this instanceof ServerPlayer) {
            frame.addContext(EventContextKeys.CREATOR, ((ServerPlayer)((Object)this)).getUser());
            frame.addContext(EventContextKeys.NOTIFIER, ((ServerPlayer)((Object)this)).getUser());
        }
    }

    @Redirect(method={"updatingUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getUseItemRemainingTicks()I", ordinal=0))
    private int impl$onGetRemainingItemDuration(LivingEntity self) {
        UseItemStackEvent.Tick event;
        if (this.field_70170_p.field_72995_K) {
            return self.func_184605_cv();
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.field_184627_bm);
            HandType handType = (HandType)this.shadow$func_184600_cs();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventTick(PhaseTracker.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, snapshot);
            SpongeCommon.postEvent(event);
        }
        this.field_184628_bn = Math.max(event.getRemainingDuration(), 1);
        if (event.isCancelled()) {
            return 26;
        }
        return this.shadow$func_184605_cv();
    }

    @Inject(method={"completeUsingItem"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;triggerItemUseEffects(Lnet/minecraft/item/ItemStack;I)V")})
    private void impl$onUpdateItemUse(CallbackInfo ci) {
        UseItemStackEvent.Finish event;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.field_184627_bm);
            HandType handType = (HandType)this.shadow$func_184600_cs();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventFinish(PhaseTracker.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, snapshot);
        }
        SpongeCommon.postEvent(event);
        if (event.getRemainingDuration() > 0) {
            this.field_184628_bn = event.getRemainingDuration();
            ci.cancel();
        } else if (event.isCancelled()) {
            this.shadow$func_184602_cy();
            ci.cancel();
        } else {
            this.impl$activeItemStackCopy = this.field_184627_bm.func_77946_l();
        }
    }

    @Redirect(method={"completeUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setItemInHand(Lnet/minecraft/util/Hand;Lnet/minecraft/item/ItemStack;)V"))
    private void impl$onSetHeldItem(LivingEntity self, Hand hand, ItemStack stack) {
        UseItemStackEvent.Replace event;
        if (this.field_70170_p.field_72995_K) {
            self.func_184611_a(hand, stack);
            return;
        }
        ItemStackSnapshot activeItemStackSnapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy == null ? ItemStack.field_190927_a : this.impl$activeItemStackCopy);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack == null ? ItemStack.field_190927_a : stack);
            HandType handType = (HandType)hand;
            this.impl$addSelfToFrame(frame, activeItemStackSnapshot, handType);
            event = SpongeEventFactory.createUseItemStackEventReplace(PhaseTracker.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, activeItemStackSnapshot, new Transaction<ItemStackSnapshot>(ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy), snapshot));
        }
        if (SpongeCommon.postEvent(event)) {
            this.shadow$func_184611_a(hand, this.impl$activeItemStackCopy.func_77946_l());
            return;
        }
        if (!event.getItemStackResult().isValid()) {
            this.shadow$func_184611_a(hand, this.impl$activeItemStackCopy.func_77946_l());
            return;
        }
        this.shadow$func_184611_a(hand, ItemStackUtil.fromSnapshotToNative(event.getItemStackResult().getFinal()));
    }

    @Redirect(method={"releaseUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;releaseUsing(Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;I)V"))
    private void impl$onStopPlayerUsing(ItemStack stack, World world, LivingEntity self, int duration) {
        if (this.field_70170_p.field_72995_K) {
            stack.func_77974_b(world, self, duration);
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            HandType handType = (HandType)this.shadow$func_184600_cs();
            this.impl$addSelfToFrame(frame, snapshot, handType);
            if (!SpongeCommon.postEvent(SpongeEventFactory.createUseItemStackEventStop(PhaseTracker.getCauseStackManager().getCurrentCause(), duration, duration, snapshot))) {
                stack.func_77974_b(world, self, duration);
            }
        }
    }

    @Inject(method={"stopUsingItem"}, at={@At(value="HEAD")})
    private void impl$onResetActiveHand(CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(this.impl$activeItemStackCopy != null ? this.impl$activeItemStackCopy : this.field_184627_bm);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            this.impl$addSelfToFrame(frame, snapshot);
            SpongeCommon.postEvent(SpongeEventFactory.createUseItemStackEventReset(PhaseTracker.getCauseStackManager().getCurrentCause(), this.field_184628_bn, this.field_184628_bn, snapshot));
        }
        this.impl$activeItemStackCopy = null;
    }
}

