/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.effect;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={LightningBoltEntity.class})
public abstract class LightningBoltEntityMixin
extends EntityMixin {
    private final List<org.spongepowered.api.entity.Entity> impl$struckEntities = Lists.newArrayList();
    private boolean impl$effect = false;

    @Redirect(method={"spawnFire"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockAndUpdate(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z"))
    private boolean impl$throwEventForChangingBlocks(World world, BlockPos pos, BlockState blockState) {
        return this.impl$strikeBlockAndAddSnapshot(world, pos, blockState);
    }

    @Redirect(method={"spawnFire(I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockAndUpdate(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z"))
    private boolean impl$throwEventForChangingBlockDuringUpdate(World world, BlockPos pos, BlockState blockState) {
        return this.impl$strikeBlockAndAddSnapshot(world, pos, blockState);
    }

    private boolean impl$strikeBlockAndAddSnapshot(World world, BlockPos pos, BlockState blockState) {
        if (!this.impl$effect && ((org.spongepowered.api.world.World)world).containsBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            Vector3i pos3i = VecHelper.toVector3i(pos);
            Transaction<SpongeBlockSnapshot> transaction = new Transaction<SpongeBlockSnapshot>(SpongeBlockSnapshotBuilder.pooled().blockState(world.func_180495_p(pos)).world((ServerWorld)world).position(pos3i).build(), SpongeBlockSnapshotBuilder.pooled().blockState(blockState).world((ServerWorld)world).position(pos3i).build());
            return true;
        }
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;thunderHit(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/entity/effect/LightningBoltEntity;)V"))
    private void impl$AddEntityToListForEvent(Entity mcEntity, ServerWorld level, LightningBoltEntity lightningBolt) {
        org.spongepowered.api.entity.Entity entity;
        if (!this.impl$effect && !this.impl$struckEntities.contains(entity = (org.spongepowered.api.entity.Entity)mcEntity)) {
            this.impl$struckEntities.add(entity);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/LightningBoltEntity;remove()V")})
    private void impl$ThrowEventAndProcess(CallbackInfo ci) {
        if (this.field_70128_L || this.field_70170_p.field_72995_K) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            LightningEvent.Strike strike = SpongeEventFactory.createLightningEventStrike(frame.getCurrentCause(), this.impl$struckEntities);
            Sponge.getEventManager().post(strike);
            if (!strike.isCancelled()) {
                for (org.spongepowered.api.entity.Entity e : strike.getEntities()) {
                    ((Entity)e).func_241841_a((ServerWorld)this.field_70170_p, (LightningBoltEntity)this);
                }
                SpongeCommon.postEvent(SpongeEventFactory.createLightningEventPost(frame.getCurrentCause()));
            }
        }
    }

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        if (compound.func_74764_b("effect")) {
            this.impl$effect = compound.func_74767_n("effect");
        }
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        compound.func_74757_a("effect", this.impl$effect);
    }
}

