/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import java.util.ArrayList;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.util.DamageSource;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.cause.entity.damage.DamageEventHandler;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.LivingEntityMixin;

@Mixin(value={ArmorStandEntity.class})
public abstract class ArmorStandEntityMixin
extends LivingEntityMixin {
    @Shadow
    protected abstract void shadow$func_213817_e(DamageSource var1, float var2);

    private void fireDestroyDamageEvent(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            DamageEventHandler.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), new ArrayList<DamageFunction>(), Math.max(1000.0f, this.shadow$func_110143_aJ()));
            if (SpongeCommon.postEvent(event)) {
                cir.setReturnValue((Object)false);
            }
            if (event.getFinalDamage() < (double)this.shadow$func_110143_aJ()) {
                this.shadow$func_213817_e(source, (float)event.getFinalDamage());
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hurt"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/util/DamageSource;OUT_OF_WORLD:Lnet/minecraft/util/DamageSource;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/ArmorStandEntity;remove()V", ordinal=0)}, cancellable=true)
    private void fireDamageEventOutOfWorld(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Inject(method={"hurt"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/DamageSource;isExplosion()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/ArmorStandEntity;causeDamage(Lnet/minecraft/util/DamageSource;F)V")}, cancellable=true)
    private void impl$fireDamageEventExplosion(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/item/ArmorStandEntity;causeDamage(Lnet/minecraft/util/DamageSource;F)V"))
    private void impl$fireDamageEventDamage(ArmorStandEntity self, DamageSource source, float amount) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            DamageEventHandler.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), new ArrayList<DamageFunction>(), amount);
            if (!SpongeCommon.postEvent(event)) {
                this.shadow$func_213817_e(source, (float)event.getFinalDamage());
            }
        }
    }

    @Inject(method={"hurt"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/DamageSource;isCreativePlayer()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/ArmorStandEntity;playBrokenSound()V")}, cancellable=true)
    private void fireDamageEventCreativePunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Inject(method={"hurt"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/entity/item/ArmorStandEntity;lastHit:J", opcode=180))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;broadcastEntityEvent(Lnet/minecraft/entity/Entity;B)V")}, cancellable=true)
    private void fireDamageEventFirstPunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            DamageEventHandler.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), new ArrayList<DamageFunction>(), 0.0);
            if (SpongeCommon.postEvent(event)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/ArmorStandEntity;brokenByPlayer(Lnet/minecraft/util/DamageSource;)V")}, cancellable=true)
    private void fireDamageEventSecondPunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.fireDestroyDamageEvent(source, cir);
    }

    @Overwrite
    public void func_174812_G() {
        super.shadow$func_174812_G();
    }
}

