/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ExpireEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.item.ItemEntityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.storage.ServerWorldInfoBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends EntityMixin
implements ItemEntityBridge {
    private static final int MAGIC_PREVIOUS = -1;
    @Shadow
    private int field_145804_b;
    @Shadow
    private int field_70292_b;
    private double impl$cachedRadius = -1.0;
    private int impl$previousPickupDelay = -1;
    private boolean impl$infinitePickupDelay;
    private int impl$previousDespawnDelay = -1;
    private boolean impl$infiniteDespawnDelay;

    @Shadow
    public abstract ItemStack shadow$func_92059_d();

    @Override
    public boolean bridge$infinitePickupDelay() {
        return this.impl$infinitePickupDelay;
    }

    @ModifyConstant(method={"mergeWithNeighbours"}, constant={@Constant(doubleValue=0.5)})
    private double impl$changeSearchRadiusFromConfig(double originalRadius) {
        if (this.field_70170_p.field_72995_K || ((WorldBridge)this.field_70170_p).bridge$isFake()) {
            return originalRadius;
        }
        if (this.impl$cachedRadius == -1.0) {
            double configRadius = ((WorldConfig)((ServerWorldInfoBridge)this.field_70170_p.func_72912_H()).bridge$configAdapter().get()).world.itemMergeRadius;
            this.impl$cachedRadius = configRadius < 0.0 ? 0.0 : configRadius;
        }
        return this.impl$cachedRadius;
    }

    @Override
    public int bridge$getPickupDelay() {
        return this.impl$infinitePickupDelay ? this.impl$previousPickupDelay : this.field_145804_b;
    }

    @Override
    public void bridge$setPickupDelay(int delay, boolean infinite) {
        this.field_145804_b = delay;
        boolean previous = this.impl$infinitePickupDelay;
        this.impl$infinitePickupDelay = infinite;
        if (infinite && !previous) {
            this.impl$previousPickupDelay = this.field_145804_b;
            this.field_145804_b = Short.MAX_VALUE;
        } else if (!infinite) {
            this.impl$previousPickupDelay = -1;
        }
    }

    @Override
    public boolean bridge$infiniteDespawnDelay() {
        return this.impl$infiniteDespawnDelay;
    }

    @Override
    public int bridge$getDespawnDelay() {
        return ((WorldConfig)SpongeGameConfigs.getForWorld((World)this.field_70170_p).get()).entity.item.despawnRate - (this.impl$infiniteDespawnDelay ? this.impl$previousDespawnDelay : this.field_70292_b);
    }

    @Override
    public void bridge$setDespawnDelay(int delay, boolean infinite) {
        this.field_70292_b = ((WorldConfig)SpongeGameConfigs.getForWorld((World)this.field_70170_p).get()).entity.item.despawnRate - delay;
        boolean previous = this.impl$infiniteDespawnDelay;
        this.impl$infiniteDespawnDelay = infinite;
        if (infinite && !previous) {
            this.impl$previousDespawnDelay = this.field_70292_b;
            this.field_70292_b = Short.MIN_VALUE;
        } else if (!infinite) {
            this.impl$previousDespawnDelay = -1;
        }
    }

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        this.impl$infinitePickupDelay = compound.func_74767_n("InfinitePickupDelay");
        this.impl$previousPickupDelay = compound.func_150297_b("PreviousPickupDelay", 99) ? compound.func_74762_e("PreviousPickupDelay") : -1;
        this.impl$infiniteDespawnDelay = compound.func_74767_n("InfiniteDespawnDelay");
        this.impl$previousDespawnDelay = compound.func_150297_b("PreviousDespawnDelay", 99) ? compound.func_74762_e("PreviousDespawnDelay") : -1;
        if (this.impl$infinitePickupDelay) {
            if (this.impl$previousPickupDelay != this.field_145804_b) {
                this.impl$previousPickupDelay = this.field_145804_b;
            }
            this.field_145804_b = Short.MAX_VALUE;
        } else if (this.field_145804_b == Short.MAX_VALUE && this.impl$previousPickupDelay != -1) {
            this.field_145804_b = this.impl$previousPickupDelay;
            this.impl$previousPickupDelay = -1;
        }
        if (this.impl$infiniteDespawnDelay) {
            if (this.impl$previousDespawnDelay != this.field_70292_b) {
                this.impl$previousDespawnDelay = this.field_70292_b;
            }
            this.field_70292_b = Short.MIN_VALUE;
        } else if (this.field_70292_b == Short.MIN_VALUE && this.impl$previousDespawnDelay != -1) {
            this.field_70292_b = this.impl$previousDespawnDelay;
            this.impl$previousDespawnDelay = -1;
        }
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        compound.func_74757_a("InfinitePickupDelay", this.impl$infinitePickupDelay);
        compound.func_74777_a("PreviousPickupDelay", (short)this.impl$previousPickupDelay);
        compound.func_74757_a("InfiniteDespawnDelay", this.impl$infiniteDespawnDelay);
        compound.func_74777_a("PreviousDespawnDelay", (short)this.impl$previousDespawnDelay);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/ItemEntity;remove()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/item/ItemEntity;updateInWaterStateAndDoFluidPushing()Z"), to=@At(value="TAIL"))})
    private void impl$fireExpireEntityEventTargetItem(CallbackInfo ci) {
        if (!PhaseTracker.SERVER.onSidedThread() || this.shadow$func_92059_d().func_190926_b()) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            ExpireEntityEvent event = SpongeEventFactory.createExpireEntityEvent(frame.getCurrentCause(), (Item)((Object)this));
            SpongeCommon.postEvent(event);
        }
    }

    @ModifyConstant(method={"isMergable"}, constant={@Constant(intValue=6000)})
    private int impl$isMergableUseDespawnRateFromConfig(int originalValue) {
        return ((WorldConfig)SpongeGameConfigs.getForWorld((World)this.field_70170_p).get()).entity.item.despawnRate;
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=6000)})
    private int impl$tickUseDespawnRateFromConfig(int originalValue) {
        return ((WorldConfig)SpongeGameConfigs.getForWorld((World)this.field_70170_p).get()).entity.item.despawnRate;
    }
}

