/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item.minecart;

import java.util.ArrayList;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import org.spongepowered.api.entity.vehicle.minecart.MinecartLike;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.item.minecart.MinecartEntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={AbstractMinecartEntity.class})
public abstract class AbstractMinecartEntityMixin
extends EntityMixin
implements MinecartEntityBridge {
    protected double impl$maxSpeed = 0.4;
    private boolean impl$slowWhenEmpty = true;
    private org.spongepowered.math.vector.Vector3d impl$airborneMod = new org.spongepowered.math.vector.Vector3d((double)0.95f, (double)0.95f, (double)0.95f);
    private org.spongepowered.math.vector.Vector3d impl$derailedMod = new org.spongepowered.math.vector.Vector3d(0.5, 0.5, 0.5);

    @Overwrite
    protected double func_174898_m() {
        return this.impl$maxSpeed;
    }

    @Redirect(method={"comeOffTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/vector/Vector3d;scale(D)Lnet/minecraft/util/math/vector/Vector3d;"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/util/math/vector/Vector3d;z:D"), to=@At(value="FIELD", target="Lnet/minecraft/entity/MoverType;SELF:Lnet/minecraft/entity/MoverType;")), expect=1, require=1)
    private Vector3d impl$applyDerailedModifierOnGround(Vector3d vec3d, double factor) {
        return vec3d.func_216372_d(this.impl$derailedMod.getX(), this.impl$derailedMod.getY(), this.impl$derailedMod.getZ());
    }

    @Redirect(method={"comeOffTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/vector/Vector3d;scale(D)Lnet/minecraft/util/math/vector/Vector3d;"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/entity/MoverType;SELF:Lnet/minecraft/entity/MoverType;"), to=@At(value="TAIL")), expect=1, require=1)
    private Vector3d impl$applyDerailedModifierInAir(Vector3d vec3d, double factor) {
        return vec3d.func_216372_d(this.impl$airborneMod.getX(), this.impl$airborneMod.getY(), this.impl$airborneMod.getZ());
    }

    @Redirect(method={"applyNaturalSlowdown"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/item/minecart/AbstractMinecartEntity;isVehicle()Z"))
    private boolean impl$applyDragIfEmpty(AbstractMinecartEntity self) {
        return !this.impl$slowWhenEmpty || this.shadow$func_184207_aI();
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/minecart/AbstractMinecartEntity;ejectPassengers()V")}, cancellable=true)
    private void impl$postOnAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.getCurrentCause(), (MinecartLike)((Object)this), new ArrayList(), 0.0f, amount);
            SpongeCommon.postEvent(event);
            if (event.isCancelled()) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        if (compound.func_74764_b("maxSpeed")) {
            this.impl$maxSpeed = compound.func_74769_h("maxSpeed");
        }
        if (compound.func_74764_b("slowWhenEmpty")) {
            this.impl$slowWhenEmpty = compound.func_74767_n("slowWhenEmpty");
        }
        if (compound.func_74764_b("airborneModifier")) {
            this.impl$airborneMod = VecHelper.fromCompound(compound.func_74775_l("airborneModifier"));
        }
        if (compound.func_74764_b("derailedModifier")) {
            this.impl$derailedMod = VecHelper.fromCompound(compound.func_74775_l("derailedModifier"));
        }
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        compound.func_74780_a("maxSpeed", this.impl$maxSpeed);
        compound.func_74757_a("slowWhenEmpty", this.impl$slowWhenEmpty);
        compound.func_218657_a("airborneModifier", (INBT)VecHelper.toCompound(this.impl$airborneMod));
        compound.func_218657_a("derailedModifier", (INBT)VecHelper.toCompound(this.impl$derailedMod));
    }

    @Override
    public double bridge$getMaxSpeed() {
        return this.impl$maxSpeed;
    }

    @Override
    public void bridge$setMaxSpeed(double impl$maxSpeed) {
        this.impl$maxSpeed = impl$maxSpeed;
    }

    @Override
    public boolean bridge$getSlowWhenEmpty() {
        return this.impl$slowWhenEmpty;
    }

    @Override
    public void bridge$setSlowWhenEmpty(boolean impl$slowWhenEmpty) {
        this.impl$slowWhenEmpty = impl$slowWhenEmpty;
    }

    @Override
    public org.spongepowered.math.vector.Vector3d bridge$getAirborneMod() {
        return this.impl$airborneMod;
    }

    @Override
    public void bridge$setAirborneMod(org.spongepowered.math.vector.Vector3d impl$airborneMod) {
        this.impl$airborneMod = impl$airborneMod;
    }

    @Override
    public org.spongepowered.math.vector.Vector3d bridge$getDerailedMod() {
        return this.impl$derailedMod;
    }

    @Override
    public void bridge$setDerailedMod(org.spongepowered.math.vector.Vector3d impl$derailedMod) {
        this.impl$derailedMod = impl$derailedMod;
    }
}

