/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.event.cause.entity.damage.ModifierFunction;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.authlib.GameProfileHolderBridge;
import org.spongepowered.common.bridge.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.cause.entity.damage.DamageEventHandler;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.LivingEntityMixin;
import org.spongepowered.common.util.ExperienceHolderUtil;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin
implements PlayerEntityBridge,
GameProfileHolderBridge {
    @Shadow
    @Final
    protected static DataParameter<Byte> field_184827_bp;
    @Shadow
    public int field_71068_ca;
    @Shadow
    public int field_71067_cb;
    @Shadow
    public float field_71106_cc;
    @Shadow
    @Final
    public PlayerAbilities field_71075_bZ;
    @Shadow
    @Final
    public PlayerInventory field_71071_by;
    @Shadow
    public Container field_71070_bA;
    @Shadow
    @Final
    public PlayerContainer field_71069_bz;
    @Shadow
    @Final
    private GameProfile field_146106_i;
    private boolean impl$affectsSpawning = true;
    private boolean impl$shouldRestoreInventory = false;
    protected final boolean impl$isFake = ((PlatformEntityBridge)((PlayerEntity)this)).bridge$isFakePlayer();

    @Shadow
    public abstract boolean shadow$func_175149_v();

    @Shadow
    public abstract int shadow$func_71050_bK();

    @Shadow
    @Nullable
    public abstract ItemEntity shadow$func_146097_a(ItemStack var1, boolean var2, boolean var3);

    @Shadow
    public abstract FoodStats shadow$func_71024_bL();

    @Shadow
    public abstract GameProfile shadow$func_146103_bH();

    @Shadow
    public abstract Scoreboard shadow$func_96123_co();

    @Shadow
    public abstract boolean shadow$func_184812_l_();

    @Shadow
    public boolean shadow$func_96122_a(PlayerEntity other) {
        return false;
    }

    @Shadow
    public abstract String shadow$func_195047_I_();

    @Shadow
    public abstract float shadow$func_70689_ay();

    @Shadow
    public abstract void shadow$func_184821_cY();

    @Shadow
    public abstract float shadow$func_184825_o(float var1);

    @Shadow
    public abstract void shadow$func_184810_cG();

    @Shadow
    public abstract void shadow$func_71009_b(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void shadow$func_71047_c(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void shadow$func_71029_a(Stat<?> var1);

    @Shadow
    public abstract void shadow$func_195067_a(ResourceLocation var1, int var2);

    @Shadow
    public abstract void shadow$func_71020_j(float var1);

    @Shadow
    public abstract ITextComponent shadow$func_145748_c_();

    @Shadow
    protected abstract void shadow$func_192030_dh();

    @Shadow
    public abstract void shadow$func_195066_a(ResourceLocation var1);

    @Override
    public boolean bridge$affectsSpawning() {
        return this.impl$affectsSpawning && !this.shadow$func_175149_v() && !this.bridge$isUntargetable();
    }

    @Override
    public void bridge$setAffectsSpawning(boolean affectsSpawning) {
        this.impl$affectsSpawning = affectsSpawning;
    }

    @Override
    public void bridge$shouldRestoreInventory(boolean restore) {
        this.impl$shouldRestoreInventory = restore;
    }

    @Override
    public boolean bridge$shouldRestoreInventory() {
        return this.impl$shouldRestoreInventory;
    }

    @Override
    public GameProfile bridge$getGameProfile() {
        return this.field_146106_i;
    }

    @Override
    public int bridge$getExperienceSinceLevel() {
        return this.field_71067_cb - ExperienceHolderUtil.xpAtLevel(this.field_71068_ca);
    }

    @Override
    public void bridge$setExperienceSinceLevel(int experience) {
        this.field_71067_cb = ExperienceHolderUtil.xpAtLevel(this.field_71068_ca) + experience;
        this.field_71106_cc = (float)experience / (float)this.shadow$func_71050_bK();
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isSleeping()Z"))
    private boolean impl$postSleepingEvent(PlayerEntity self) {
        if (self.func_70608_bn()) {
            if (!((WorldBridge)this.field_70170_p).bridge$isFake()) {
                CauseStackManager csm = PhaseTracker.getCauseStackManager();
                csm.pushCause(this);
                BlockPos bedLocation = this.shadow$func_213374_dv().get();
                BlockSnapshot snapshot = ((ServerWorld)this.field_70170_p).createSnapshot(bedLocation.func_177958_n(), bedLocation.func_177956_o(), bedLocation.func_177952_p());
                SpongeCommon.postEvent(SpongeEventFactory.createSleepingEventTick(csm.getCurrentCause(), snapshot, (Humanoid)((Object)this)));
                csm.popCause();
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"getDisplayName"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getName()Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent impl$useCustomNameIfSet(PlayerEntity playerEntity) {
        if (playerEntity instanceof ServerPlayerEntity) {
            if (playerEntity.func_145818_k_()) {
                return playerEntity.func_200201_e();
            }
            return playerEntity.func_200200_C_();
        }
        return playerEntity.func_200200_C_();
    }

    @Redirect(method={"playSound(Lnet/minecraft/util/SoundEvent;FF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V"))
    private void impl$playNoSoundToOthersIfVanished(World world, PlayerEntity player, double x, double y, double z, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (!this.bridge$isVanished()) {
            this.field_70170_p.func_184148_a(player, x, y, z, sound, category, volume, pitch);
        }
    }

    @Redirect(method={"canUseGameMasterBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getPermissionLevel()I"))
    private int impl$checkPermissionForCommandBlock(PlayerEntity playerEntity) {
        if (this instanceof Subject) {
            return ((Subject)((Object)this)).hasPermission("minecraft.commandblock") ? 2 : 0;
        }
        return this.shadow$func_184840_I();
    }

    @Redirect(method={"mayUseItemAt"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasAdventureModePlaceTagForBlock(Lnet/minecraft/tags/ITagCollectionSupplier;Lnet/minecraft/util/CachedBlockInfo;)Z"))
    private boolean impl$callChangeBlockPre(ItemStack stack, ITagCollectionSupplier tagSupplier, CachedBlockInfo cachedBlockInfo) {
        if (!stack.func_206847_b(tagSupplier, cachedBlockInfo)) {
            return false;
        }
        if (this.field_70170_p instanceof WorldBridge && !((WorldBridge)this.field_70170_p).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
                boolean bl = !SpongeCommonEventFactory.callChangeBlockEventPre((ServerWorldBridge)this.field_70170_p, cachedBlockInfo.func_177508_d(), (Object)this).isCancelled();
                return bl;
            }
        }
        return true;
    }

    @Overwrite
    @Nullable
    public ItemEntity func_71019_a(ItemStack itemStackIn, boolean unused) {
        return this.shadow$func_146097_a(itemStackIn, false, false);
    }

    @Inject(method={"getFireImmuneTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useCustomFireImmuneTicks(CallbackInfoReturnable<Integer> ci) {
        if (this.impl$hasCustomFireImmuneTicks) {
            ci.setReturnValue((Object)this.impl$fireImmuneTicks);
        }
    }

    @Inject(method={"interactOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void impl$onRightClickEntity(net.minecraft.entity.Entity entityToInteractOn, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        if (!((PlayerEntity)this instanceof ServerPlayerEntity)) {
            return;
        }
        InteractEntityEvent.Secondary event = SpongeCommonEventFactory.callInteractEntityEventSecondary((ServerPlayerEntity)this, this.shadow$func_184586_b(hand), entityToInteractOn, hand, null);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)ActionResultType.FAIL);
        }
    }

    @Overwrite
    public void func_71059_n(net.minecraft.entity.Entity targetEntity) {
        if (!PlatformHooks.INSTANCE.getEntityHooks().checkAttackEntity((PlayerEntity)this, targetEntity)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((net.minecraft.entity.Entity)((PlayerEntity)this))) {
            double originalBaseDamage = this.shadow$func_110148_a(Attributes.field_233823_f_).func_111126_e();
            float damage = (float)originalBaseDamage;
            float enchantmentDamage = 0.0f;
            float attackStrength = this.shadow$func_184825_o(0.5f);
            ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
            CreatureAttribute creatureAttribute = targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).func_70668_bt() : CreatureAttribute.field_223222_a_;
            List<DamageFunction> enchantmentModifierFunctions = DamageEventHandler.createAttackEnchantmentFunction(this.shadow$func_184614_ca(), creatureAttribute, attackStrength);
            List enchantmentModifiers = enchantmentModifierFunctions.stream().map(ModifierFunction::getModifier).collect(Collectors.toList());
            enchantmentDamage = (float)enchantmentModifierFunctions.stream().map(ModifierFunction::getFunction).mapToDouble(function -> function.applyAsDouble(originalBaseDamage)).sum();
            originalFunctions.addAll(enchantmentModifierFunctions);
            originalFunctions.add(DamageEventHandler.provideCooldownAttackStrengthFunction((PlayerEntity)this, attackStrength));
            enchantmentDamage *= attackStrength;
            this.shadow$func_184821_cY();
            if ((damage *= 0.2f + attackStrength * attackStrength * 0.8f) > 0.0f || enchantmentDamage > 0.0f) {
                boolean isMainthread;
                ItemStack itemstack;
                boolean isStrongAttack = attackStrength > 0.9f;
                boolean isSprintingAttack = false;
                boolean isCriticalAttack = false;
                boolean isSweapingAttack = false;
                int knockbackModifier = 0;
                knockbackModifier += EnchantmentHelper.func_77501_a((LivingEntity)((PlayerEntity)this));
                if (this.shadow$func_70051_ag() && isStrongAttack) {
                    ++knockbackModifier;
                    isSprintingAttack = true;
                }
                isCriticalAttack = isStrongAttack && this.field_70143_R > 0.0f && !this.field_70122_E && !this.shadow$func_70617_f_() && !this.shadow$func_70090_H() && !this.shadow$func_70644_a(Effects.field_76440_q) && !this.shadow$func_184218_aH() && targetEntity instanceof LivingEntity;
                boolean bl = isCriticalAttack = isCriticalAttack && !this.shadow$func_70051_ag();
                if (isCriticalAttack) {
                    originalFunctions.add(DamageEventHandler.provideCriticalAttackTuple((PlayerEntity)this));
                }
                double distanceWalkedDelta = this.field_70140_Q - this.field_70141_P;
                ItemStack heldItem = this.shadow$func_184614_ca();
                if (isStrongAttack && !isCriticalAttack && !isSprintingAttack && this.field_70122_E && distanceWalkedDelta < (double)this.shadow$func_70689_ay() && (itemstack = heldItem).func_77973_b() instanceof SwordItem) {
                    isSweapingAttack = true;
                }
                DamageSource damageSource = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this));
                boolean bl2 = isMainthread = !this.field_70170_p.field_72995_K;
                if (isMainthread) {
                    PhaseTracker.getInstance().pushCause(damageSource);
                }
                Cause currentCause = isMainthread ? PhaseTracker.getInstance().getCurrentCause() : Cause.of(EventContext.empty(), damageSource);
                AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(currentCause, (Entity)targetEntity, originalFunctions, knockbackModifier, originalBaseDamage);
                SpongeCommon.postEvent(event);
                if (isMainthread) {
                    PhaseTracker.getInstance().popCause();
                }
                if (event.isCancelled()) {
                    return;
                }
                damage = (float)event.getFinalOutputDamage();
                double attackDamage = damage;
                knockbackModifier = (int)event.getKnockbackModifier();
                enchantmentDamage = (float)enchantmentModifiers.stream().mapToDouble(event::getOutputDamage).sum();
                float targetOriginalHealth = 0.0f;
                boolean litEntityOnFire = false;
                int fireAspectModifier = EnchantmentHelper.func_90036_a((LivingEntity)((PlayerEntity)this));
                if (targetEntity instanceof LivingEntity) {
                    targetOriginalHealth = ((LivingEntity)targetEntity).func_110143_aJ();
                    if (fireAspectModifier > 0 && !targetEntity.func_70027_ad()) {
                        litEntityOnFire = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                Vector3d targetMotion = targetEntity.func_213322_ci();
                boolean attackSucceeded = targetEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this)), damage);
                if (attackSucceeded) {
                    if (knockbackModifier > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).func_233627_a_((float)knockbackModifier * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackModifier * 0.5f));
                        }
                        this.shadow$func_213317_d(this.shadow$func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                        this.shadow$func_70031_b(false);
                    }
                    if (isSweapingAttack) {
                        for (LivingEntity livingEntity : this.field_70170_p.func_217357_a(LivingEntity.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (livingEntity == (PlayerEntity)this || livingEntity == targetEntity || this.shadow$func_184191_r((net.minecraft.entity.Entity)livingEntity) || livingEntity instanceof ArmorStandEntity && ((ArmorStandEntity)livingEntity).func_181026_s() || !(this.shadow$func_70068_e((net.minecraft.entity.Entity)livingEntity) < 9.0)) continue;
                            EntityDamageSource sweepingAttackSource = (EntityDamageSource)((EntityDamageSource.Builder)((EntityDamageSource.Builder)EntityDamageSource.builder().entity((Player)((Object)this))).type(DamageTypes.SWEEPING_ATTACK)).build();
                            CauseStackManager.StackFrame frame = isMainthread ? PhaseTracker.getInstance().pushCauseFrame() : null;
                            Throwable throwable = null;
                            try {
                                if (isMainthread) {
                                    frame.pushCause(sweepingAttackSource);
                                }
                                ItemStackSnapshot heldSnapshot = ItemStackUtil.snapshotOf(heldItem);
                                if (isMainthread) {
                                    frame.addContext(EventContextKeys.WEAPON, heldSnapshot);
                                }
                                DamageFunction sweapingFunction = DamageFunction.of(DamageModifier.builder().cause(Cause.of(EventContext.empty(), heldSnapshot)).item(heldSnapshot).type(DamageModifierTypes.SWEEPING).build(), incoming -> (double)EnchantmentHelper.func_191527_a((LivingEntity)((PlayerEntity)this)) * attackDamage);
                                ArrayList<DamageFunction> sweapingFunctions = new ArrayList<DamageFunction>();
                                sweapingFunctions.add(sweapingFunction);
                                AttackEntityEvent sweepingAttackEvent = SpongeEventFactory.createAttackEntityEvent(currentCause, (Entity)livingEntity, sweapingFunctions, 1.0f, 1.0);
                                SpongeCommon.postEvent(sweepingAttackEvent);
                                if (sweepingAttackEvent.isCancelled()) continue;
                                livingEntity.func_233627_a_(sweepingAttackEvent.getKnockbackModifier() * 0.4f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                                livingEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this)), (float)sweepingAttackEvent.getFinalOutputDamage());
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (frame == null) continue;
                                if (throwable != null) {
                                    try {
                                        frame.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                frame.close();
                            }
                        }
                        this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187730_dW, this.shadow$func_184176_by(), 1.0f, 1.0f);
                        this.shadow$func_184810_cG();
                    }
                    if (targetEntity instanceof ServerPlayerEntity && targetEntity.field_70133_I) {
                        ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.func_213317_d(targetMotion);
                    }
                    if (isCriticalAttack) {
                        this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187718_dS, this.shadow$func_184176_by(), 1.0f, 1.0f);
                        this.shadow$func_71009_b(targetEntity);
                    }
                    if (!isCriticalAttack && !isSweapingAttack) {
                        if (isStrongAttack) {
                            this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187727_dV, this.shadow$func_184176_by(), 1.0f, 1.0f);
                        } else {
                            this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187733_dX, this.shadow$func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (enchantmentDamage > 0.0f) {
                        this.shadow$func_71047_c(targetEntity);
                    }
                    this.shadow$func_130011_c(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)targetEntity), (net.minecraft.entity.Entity)((PlayerEntity)this));
                    }
                    EnchantmentHelper.func_151385_b((LivingEntity)((PlayerEntity)this), (net.minecraft.entity.Entity)targetEntity);
                    ItemStack itemstack1 = this.shadow$func_184614_ca();
                    net.minecraft.entity.Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPartEntity) {
                        entity = ((EnderDragonPartEntity)targetEntity).field_213852_b;
                    }
                    if (!this.field_70170_p.field_72995_K && !itemstack1.func_190926_b() && entity instanceof LivingEntity) {
                        itemstack1.func_77961_a((LivingEntity)entity, (PlayerEntity)this);
                        if (itemstack1.func_190926_b()) {
                            this.shadow$func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = targetOriginalHealth - ((LivingEntity)targetEntity).func_110143_aJ();
                        this.shadow$func_195067_a(Stats.field_188111_y, Math.round(f5 * 10.0f));
                        if (fireAspectModifier > 0) {
                            targetEntity.func_70015_d(fireAspectModifier * 4);
                        }
                        if (this.field_70170_p instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((net.minecraft.world.server.ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226278_cu_() + (double)(targetEntity.func_213302_cg() * 0.5f), targetEntity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.shadow$func_71020_j(0.1f);
                } else {
                    this.field_70170_p.func_184148_a(null, this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_(), SoundEvents.field_187724_dU, this.shadow$func_184176_by(), 1.0f, 1.0f);
                    if (litEntityOnFire) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
    }

    @Override
    public boolean impl$canCallIgniteEntityEvent() {
        return !this.shadow$func_175149_v() && !this.shadow$func_184812_l_();
    }
}

