/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import com.google.common.collect.ImmutableSet;
import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.IWorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.adventure.Audiences;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.chat.ChatVisibility;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.event.entity.living.player.KickPlayerEvent;
import org.spongepowered.api.event.entity.living.player.PlayerChangeClientSettingsEvent;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.locale.Locales;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.NetworkManagerAccessor;
import org.spongepowered.common.accessor.network.play.client.CClientSettingsPacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.BossInfoBridge;
import org.spongepowered.common.data.type.SpongeSkinPart;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.mixin.core.entity.player.PlayerEntityMixin;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.LocaleCache;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.border.PlayerOwnBorderListener;
import org.spongepowered.common.world.portal.PlatformTeleporter;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin
extends PlayerEntityMixin
implements SubjectBridge,
ServerPlayerEntityBridge {
    @Shadow
    public ServerPlayNetHandler field_71135_a;
    @Shadow
    @Final
    public PlayerInteractionManager field_71134_c;
    @Shadow
    @Final
    public MinecraftServer field_71133_b;
    @Shadow
    private int field_184856_bZ;
    @Shadow
    private boolean field_184851_cj;
    @Shadow
    public boolean field_71136_j;
    @Shadow
    private boolean field_192040_cp;
    @Shadow
    private Vector3d field_193110_cw;
    @Shadow
    private int field_71144_ck;
    @Shadow
    private float field_71149_ch;
    @Shadow
    private int field_71146_ci;
    @Shadow
    public boolean field_71137_h;
    private final User impl$user = this.impl$getUserObjectOnConstruction();
    private @Nullable ITextComponent impl$connectionMessage;
    private Locale impl$language = Locales.EN_US;
    private Scoreboard impl$scoreboard = Sponge.getGame().getServer().getServerScoreboard().get();
    private @Nullable Boolean impl$keepInventory = null;
    private ItemStack impl$packetItem = ItemStack.field_190927_a;
    private int impl$viewDistance;
    private int impl$skinPartMask;
    private Set<SkinPart> impl$skinParts = ImmutableSet.of();
    private final PlayerOwnBorderListener impl$borderListener = new PlayerOwnBorderListener((ServerPlayerEntity)this);

    @Shadow
    public abstract net.minecraft.world.server.ServerWorld shadow$func_71121_q();

    @Shadow
    public abstract void shadow$func_175399_e(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void shadow$func_184210_p();

    @Shadow
    public abstract void shadow$func_71053_j();

    @Shadow
    public abstract void shadow$func_175145_a(Stat<?> var1);

    @Shadow
    protected abstract void shadow$func_241157_eT_();

    @Shadow
    protected abstract void shadow$func_242110_a(net.minecraft.world.server.ServerWorld var1, BlockPos var2);

    @Shadow
    protected abstract void shadow$func_213846_b(net.minecraft.world.server.ServerWorld var1);

    @Override
    public @Nullable ITextComponent bridge$getConnectionMessageToSend() {
        if (this.impl$connectionMessage == null) {
            return new StringTextComponent("");
        }
        return this.impl$connectionMessage;
    }

    @Override
    public void bridge$setConnectionMessageToSend(ITextComponent message) {
        this.impl$connectionMessage = message;
    }

    @Override
    public String bridge$getSubjectCollectionIdentifier() {
        return "user";
    }

    @Override
    public User bridge$getUserObject() {
        return this.impl$user;
    }

    @Override
    public User bridge$getUser() {
        return this.impl$user;
    }

    @Override
    public boolean bridge$isVanished() {
        return false;
    }

    @Override
    public Tristate bridge$permDefault(String permission) {
        return Tristate.FALSE;
    }

    @Override
    public void bridge$setPacketItem(ItemStack itemstack) {
        this.impl$packetItem = itemstack;
    }

    @Override
    public boolean bridge$setLocation(ServerLocation location) {
        if (this.field_70128_L) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            Event event;
            frame.pushCause(SpongeCommon.getActivePlugin());
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
            net.minecraft.world.server.ServerWorld destinationWorld = (net.minecraft.world.server.ServerWorld)location.getWorld();
            org.spongepowered.math.vector.Vector3d toPosition = location.getPosition();
            if (this.shadow$func_71121_q() != destinationWorld) {
                event = SpongeEventFactory.createChangeEntityWorldEventPre(frame.getCurrentCause(), (Entity)((Object)this), (ServerWorld)this.shadow$func_71121_q(), (ServerWorld)location.getWorld(), (ServerWorld)location.getWorld());
                if (SpongeCommon.postEvent(event)) {
                    boolean bl = false;
                    return bl;
                }
                ChangeEntityWorldEvent.Reposition repositionEvent = SpongeEventFactory.createChangeEntityWorldEventReposition(frame.getCurrentCause(), (Entity)((Object)this), (ServerWorld)this.shadow$func_71121_q(), VecHelper.toVector3d(this.shadow$func_213303_ch()), location.getPosition(), event.getOriginalDestinationWorld(), location.getPosition(), event.getDestinationWorld());
                if (SpongeCommon.postEvent(repositionEvent)) {
                    boolean bl = false;
                    return bl;
                }
                destinationWorld = (net.minecraft.world.server.ServerWorld)event.getDestinationWorld();
                toPosition = repositionEvent.getDestinationPosition();
            } else if (ShouldFire.MOVE_ENTITY_EVENT) {
                event = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), VecHelper.toVector3d(this.shadow$func_213303_ch()), location.getPosition(), location.getPosition());
                if (SpongeCommon.postEvent(event)) {
                    boolean bl = false;
                    return bl;
                }
                toPosition = event.getDestinationPosition();
            }
            ((ServerPlayerEntity)this).func_184210_p();
            if (((ServerPlayerEntity)this).func_70608_bn()) {
                ((ServerPlayerEntity)this).func_225652_a_(true, true);
            }
            ChunkPos chunkPos = new ChunkPos((int)toPosition.getX() >> 4, (int)toPosition.getZ() >> 4);
            destinationWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkPos, 1, (Object)((ServerPlayerEntity)this).func_145782_y());
            if (this.shadow$func_71121_q() != destinationWorld) {
                this.shadow$func_70080_a(toPosition.getX(), toPosition.getY(), toPosition.getZ(), this.field_70177_z, this.field_70125_A);
                EntityUtil.performPostChangePlayerWorldLogic((ServerPlayerEntity)this, this.shadow$func_71121_q(), (net.minecraft.world.server.ServerWorld)location.getWorld(), destinationWorld, false);
            } else {
                this.field_71135_a.func_175089_a(toPosition.getX(), toPosition.getY(), toPosition.getZ(), this.field_70177_z, this.field_70125_A, new HashSet());
                this.field_71135_a.func_184342_d();
            }
        }
        return true;
    }

    @Override
    public void bridge$refreshExp() {
        this.field_184856_bZ = -1;
    }

    @Override
    public boolean bridge$kick(Component message) {
        Component messageToSend;
        if (ShouldFire.KICK_PLAYER_EVENT) {
            KickPlayerEvent kickEvent = SpongeEventFactory.createKickPlayerEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), message, message, (ServerPlayer)((Object)this));
            if (Sponge.getEventManager().post(kickEvent)) {
                return false;
            }
            messageToSend = kickEvent.getMessage();
        } else {
            messageToSend = message;
        }
        ITextComponent component = SpongeAdventure.asVanilla(messageToSend);
        this.field_71135_a.func_194028_b(component);
        return true;
    }

    @Override
    public Locale bridge$getLanguage() {
        return this.impl$language;
    }

    @Override
    public void bridge$setLanguage(Locale language) {
        this.impl$language = language;
    }

    @Override
    public void bridge$initScoreboard() {
        ((ServerScoreboardBridge)this.shadow$func_96123_co()).bridge$addPlayer((ServerPlayerEntity)this, true);
    }

    @Override
    public void bridge$removeScoreboardOnRespawn() {
        ((ServerScoreboardBridge)((Object)((ServerPlayer)((Object)this)).getScoreboard())).bridge$removePlayer((ServerPlayerEntity)this, false);
    }

    @Override
    public void bridge$setScoreboardOnRespawn(Scoreboard scoreboard) {
        this.impl$scoreboard = scoreboard;
        ((ServerScoreboardBridge)((Object)((ServerPlayer)((Object)this)).getScoreboard())).bridge$addPlayer((ServerPlayerEntity)this, false);
    }

    @Override
    public Scoreboard bridge$getScoreboard() {
        return this.impl$scoreboard;
    }

    @Override
    public void bridge$replaceScoreboard(@Nullable Scoreboard scoreboard) {
        if (scoreboard == null) {
            scoreboard = Sponge.getGame().getServer().getServerScoreboard().orElseThrow(() -> new IllegalStateException("Server does not have a valid scoreboard"));
        }
        this.impl$scoreboard = scoreboard;
    }

    @Override
    public boolean bridge$keepInventory() {
        if (this.impl$keepInventory == null) {
            return this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c);
        }
        return this.impl$keepInventory;
    }

    @Override
    public int bridge$getExperiencePointsOnDeath(LivingEntity entity, PlayerEntity attackingPlayer) {
        if (this.impl$keepInventory != null && this.impl$keepInventory.booleanValue()) {
            return 0;
        }
        return super.bridge$getExperiencePointsOnDeath(entity, attackingPlayer);
    }

    @Override
    public int bridge$getViewDistance() {
        return this.impl$viewDistance;
    }

    @Override
    public Set<SkinPart> bridge$getSkinParts() {
        byte mask = (Byte)this.shadow$func_184212_Q().func_187225_a(field_184827_bp);
        if (this.impl$skinPartMask != mask) {
            this.impl$skinParts = (Set)Sponge.getGame().registries().registry(RegistryTypes.SKIN_PART).stream().map(part -> (SpongeSkinPart)part).filter(part -> part.test(mask)).collect(ImmutableSet.toImmutableSet());
            this.impl$skinPartMask = mask;
        }
        return this.impl$skinParts;
    }

    @Override
    public void bridge$setSkinParts(Set<SkinPart> skinParts) {
        int mask = 0;
        for (SkinPart part : skinParts) {
            mask |= ((SpongeSkinPart)part).getMask();
        }
        this.shadow$func_184212_Q().func_187227_b(field_184827_bp, (Object)((byte)mask));
        this.impl$skinParts = ImmutableSet.copyOf(skinParts);
        this.impl$skinPartMask = mask;
    }

    @Overwrite
    public void func_200619_a(net.minecraft.world.server.ServerWorld world, double x, double y, double z, float yaw, float pitch) {
        ServerPlayerEntity player = (ServerPlayerEntity)this;
        double actualX = x;
        double actualY = y;
        double actualZ = z;
        double actualYaw = yaw;
        double actualPitch = pitch;
        boolean hasMovementContext = PhaseTracker.getCauseStackManager().getCurrentContext().containsKey(EventContextKeys.MOVEMENT_TYPE);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (!hasMovementContext) {
                frame.pushCause(SpongeCommon.getActivePlugin());
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
            }
            if (world == player.field_70170_p) {
                if (ShouldFire.MOVE_ENTITY_EVENT) {
                    MoveEntityEvent posEvent = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (Entity)player, VecHelper.toVector3d(player.func_213303_ch()), new org.spongepowered.math.vector.Vector3d(x, y, z), new org.spongepowered.math.vector.Vector3d(x, y, z));
                    if (SpongeCommon.postEvent(posEvent)) {
                        return;
                    }
                    actualX = posEvent.getDestinationPosition().getX();
                    actualY = posEvent.getDestinationPosition().getY();
                    actualZ = posEvent.getDestinationPosition().getZ();
                }
                if (ShouldFire.ROTATE_ENTITY_EVENT) {
                    RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), (Entity)player, new org.spongepowered.math.vector.Vector3d(actualPitch, actualYaw, 0.0), new org.spongepowered.math.vector.Vector3d(pitch, yaw, 0.0f));
                    SpongeCommon.postEvent(rotateEvent);
                    actualYaw = rotateEvent.isCancelled() ? (double)player.field_70177_z : rotateEvent.getToRotation().getY();
                    actualPitch = rotateEvent.isCancelled() ? (double)player.field_70125_A : rotateEvent.getToRotation().getX();
                }
                this.shadow$func_175399_e((net.minecraft.entity.Entity)player);
                this.shadow$func_184210_p();
                if (player.func_70608_bn()) {
                    player.func_225652_a_(true, true);
                }
                player.field_71135_a.func_147364_a(actualX, actualY, actualZ, (float)actualYaw, (float)actualPitch);
                player.func_70034_d((float)actualYaw);
                ChunkPos chunkpos = new ChunkPos(new BlockPos(actualX, actualY, actualZ));
                world.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)player.func_145782_y());
            } else {
                RotateEntityEvent rotateEvent;
                ChangeEntityWorldEvent.Pre preEvent = PlatformHooks.INSTANCE.getEventHooks().callChangeEntityWorldEventPre((net.minecraft.entity.Entity)player, world);
                if (SpongeCommon.postEvent(preEvent)) {
                    return;
                }
                if (ShouldFire.MOVE_ENTITY_EVENT) {
                    ChangeEntityWorldEvent.Reposition posEvent = SpongeEventFactory.createChangeEntityWorldEventReposition(frame.getCurrentCause(), (Entity)player, preEvent.getOriginalWorld(), VecHelper.toVector3d(player.func_213303_ch()), new org.spongepowered.math.vector.Vector3d(x, y, z), preEvent.getOriginalDestinationWorld(), new org.spongepowered.math.vector.Vector3d(x, y, z), preEvent.getDestinationWorld());
                    if (SpongeCommon.postEvent(posEvent)) {
                        return;
                    }
                    actualX = posEvent.getDestinationPosition().getX();
                    actualY = posEvent.getDestinationPosition().getY();
                    actualZ = posEvent.getDestinationPosition().getZ();
                }
                this.shadow$func_70107_b(actualX, actualY, actualZ);
                if (ShouldFire.ROTATE_ENTITY_EVENT && !SpongeCommon.postEvent(rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), (Entity)player, new org.spongepowered.math.vector.Vector3d(actualYaw, actualPitch, 0.0), new org.spongepowered.math.vector.Vector3d(yaw, pitch, 0.0f)))) {
                    actualYaw = (float)rotateEvent.getToRotation().getX();
                    actualPitch = (float)rotateEvent.getToRotation().getY();
                }
                this.field_70177_z = (float)actualYaw;
                this.field_70125_A = (float)actualPitch;
                EntityUtil.performPostChangePlayerWorldLogic(player, (net.minecraft.world.server.ServerWorld)preEvent.getOriginalWorld(), (net.minecraft.world.server.ServerWorld)preEvent.getOriginalDestinationWorld(), (net.minecraft.world.server.ServerWorld)preEvent.getDestinationWorld(), false);
            }
        }
    }

    @Override
    public void bridge$setPlayerChangingDimensions() {
        this.field_184851_cj = true;
    }

    @Override
    public net.minecraft.entity.Entity bridge$performGameWinLogic() {
        this.shadow$func_213319_R();
        this.shadow$func_71121_q().func_217434_e((ServerPlayerEntity)this);
        if (!this.field_71136_j) {
            this.field_71136_j = true;
            this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241768_e_, this.field_192040_cp ? 0.0f : 1.0f));
            this.field_192040_cp = true;
        }
        return (net.minecraft.entity.Entity)this;
    }

    @Override
    public void bridge$playerPrepareForPortalTeleport(net.minecraft.world.server.ServerWorld currentWorld, net.minecraft.world.server.ServerWorld targetWorld) {
        IWorldInfo iworldinfo = targetWorld.func_72912_H();
        this.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(targetWorld.func_230315_m_(), targetWorld.func_234923_W_(), BiomeManager.func_235200_a_((long)targetWorld.func_72905_C()), this.field_71134_c.func_73081_b(), this.field_71134_c.func_241815_c_(), targetWorld.func_234925_Z_(), targetWorld.func_241109_A_(), true));
        this.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(iworldinfo.func_176130_y(), iworldinfo.func_176123_z()));
        PlayerList playerlist = this.field_71133_b.func_184103_al();
        playerlist.func_187243_f((ServerPlayerEntity)this);
        currentWorld.func_217434_e((ServerPlayerEntity)this);
        this.field_70128_L = false;
    }

    @Override
    public void bridge$validateEntityAfterTeleport(net.minecraft.entity.Entity e, PlatformTeleporter platformTeleporter) {
        if (e != this) {
            throw new IllegalArgumentException(String.format("Teleporter %s did not return the expected player entity: got %s, expected PlayerEntity %s", platformTeleporter, e, this));
        }
    }

    @Override
    public net.minecraft.entity.Entity bridge$portalRepositioning(boolean createEndPlatform, net.minecraft.world.server.ServerWorld serverworld, net.minecraft.world.server.ServerWorld targetWorld, PortalInfo portalinfo) {
        serverworld.func_217381_Z().func_76320_a("moving");
        if (serverworld.func_234923_W_() == World.field_234918_g_ && targetWorld.func_234923_W_() == World.field_234919_h_) {
            this.field_193110_cw = this.shadow$func_213303_ch();
        } else if (createEndPlatform && targetWorld.func_234923_W_() == World.field_234920_i_) {
            this.shadow$func_242110_a(targetWorld, new BlockPos(portalinfo.field_222505_a));
        }
        serverworld.func_217381_Z().func_76319_b();
        serverworld.func_217381_Z().func_76320_a("placing");
        this.shadow$func_70029_a((World)targetWorld);
        targetWorld.func_217447_b((ServerPlayerEntity)this);
        this.shadow$func_70101_b(portalinfo.field_242960_c, portalinfo.field_242961_d);
        this.shadow$func_242281_f(portalinfo.field_222505_a.field_72450_a, portalinfo.field_222505_a.field_72448_b, portalinfo.field_222505_a.field_72449_c);
        serverworld.func_217381_Z().func_76319_b();
        return (net.minecraft.entity.Entity)this;
    }

    @Override
    public void bridge$postPortalForceChangeTasks(net.minecraft.entity.Entity entity, net.minecraft.world.server.ServerWorld targetWorld, boolean isNetherPortal) {
        this.field_71134_c.func_73080_a(targetWorld);
        this.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(this.field_71075_bZ));
        PlayerList playerlist = this.field_71133_b.func_184103_al();
        playerlist.func_72354_b((ServerPlayerEntity)this, targetWorld);
        playerlist.func_72385_f((ServerPlayerEntity)this);
        Vector3d finalPos = this.shadow$func_213303_ch();
        this.shadow$func_225653_b_(finalPos.field_72450_a, finalPos.field_72448_b, finalPos.field_72449_c);
        for (EffectInstance effectinstance : this.shadow$func_70651_bq()) {
            this.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(this.shadow$func_145782_y(), effectinstance));
        }
        if (isNetherPortal) {
            this.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        }
        this.field_71144_ck = -1;
        this.field_71149_ch = -1.0f;
        this.field_71146_ci = -1;
    }

    @Redirect(method={"getExitPortal"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getExitPortal(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Z)Ljava/util/Optional;"), to=@At(value="FIELD", opcode=180, target="Lnet/minecraft/entity/player/ServerPlayerEntity;level:Lnet/minecraft/world/World;")), at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z"))
    private boolean impl$dontCreatePortalIfItsAlreadyBeenAttempted(Optional<?> optional) {
        return this.impl$dontCreateExitPortal || optional.isPresent();
    }

    @Inject(method={"sendRemoveEntity"}, at={@At(value="RETURN")})
    private void impl$removeHumanFromPlayerClient(net.minecraft.entity.Entity entityIn, CallbackInfo ci) {
        if (entityIn instanceof HumanEntity) {
            ((HumanEntity)entityIn).untrackFrom((ServerPlayerEntity)this);
        }
    }

    @Redirect(method={"openMenu", "openHorseInventory"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;closeContainer()V"))
    private void impl$closePreviousContainer(ServerPlayerEntity self) {
        this.shadow$func_71053_j();
    }

    @Overwrite
    public void func_70645_a(DamageSource cause) {
        boolean flag;
        DestructEntityEvent.Death event = SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)((ServerPlayerEntity)this), cause, Audiences.server());
        if (event.isCancelled()) {
            return;
        }
        boolean bl = flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l) && !event.isMessageCancelled();
        if (flag) {
            ITextComponent itextcomponent = this.shadow$func_110142_aN().func_151521_b();
            this.field_71135_a.func_211148_a((IPacket)new SCombatPacket(this.shadow$func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, itextcomponent), p_212356_2_ -> {
                if (!p_212356_2_.isSuccess()) {
                    int i = 256;
                    String s2 = itextcomponent.func_212636_a(256);
                    TranslationTextComponent itextcomponent1 = new TranslationTextComponent("death.attack.message_too_long", new Object[]{new StringTextComponent(s2).func_240699_a_(TextFormatting.YELLOW)});
                    IFormattableTextComponent itextcomponent2 = new TranslationTextComponent("death.attack.even_more_magic", new Object[]{this.shadow$func_145748_c_()}).func_240700_a_(arg_0 -> ServerPlayerEntityMixin.lambda$null$3((ITextComponent)itextcomponent1, arg_0));
                    this.field_71135_a.func_147359_a((IPacket)new SCombatPacket(this.shadow$func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, (ITextComponent)itextcomponent2));
                }
            });
            Team team = this.shadow$func_96124_cp();
            if (team != null && team.func_178771_j() != Team.Visible.ALWAYS) {
                if (team.func_178771_j() == Team.Visible.HIDE_FOR_OTHER_TEAMS) {
                    this.field_71133_b.func_184103_al().func_177453_a((PlayerEntity)((ServerPlayerEntity)this), itextcomponent);
                } else if (team.func_178771_j() == Team.Visible.HIDE_FOR_OWN_TEAM) {
                    this.field_71133_b.func_184103_al().func_177452_b((PlayerEntity)((ServerPlayerEntity)this), itextcomponent);
                }
            } else {
                Component message = event.getMessage();
                if (message != Component.empty()) {
                    event.getAudience().ifPresent(eventChannel -> eventChannel.sendMessage(Identity.nil(), message));
                }
            }
        } else {
            this.field_71135_a.func_147359_a((IPacket)new SCombatPacket(this.shadow$func_110142_aN(), SCombatPacket.Event.ENTITY_DIED));
        }
        this.shadow$func_192030_dh();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234895_F_)) {
            this.shadow$func_241157_eT_();
        }
        this.impl$keepInventory = event.getKeepInventory();
        if (!this.shadow$func_175149_v()) {
            this.shadow$func_213345_d(cause);
        }
        this.shadow$func_96123_co().func_197893_a(ScoreCriteria.field_96642_c, this.shadow$func_195047_I_(), Score::func_96648_a);
        LivingEntity livingentity = this.shadow$func_94060_bK();
        if (livingentity != null) {
            this.shadow$func_71029_a(Stats.field_199091_i.func_199076_b((Object)livingentity.func_200600_R()));
            livingentity.func_191956_a((net.minecraft.entity.Entity)((ServerPlayerEntity)this), this.field_70744_aE, cause);
            this.shadow$func_226298_f_(livingentity);
        }
        this.field_70170_p.func_72960_a((net.minecraft.entity.Entity)((ServerPlayerEntity)this), (byte)3);
        this.shadow$func_195066_a(Stats.field_188069_A);
        this.shadow$func_175145_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188098_h));
        this.shadow$func_175145_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n));
        this.shadow$func_70066_B();
        this.shadow$func_70052_a(0, false);
        this.shadow$func_110142_aN().func_94549_h();
    }

    @Redirect(method={"restoreFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$RuleKey;)Z"))
    private boolean tracker$useKeepFromBridge(GameRules gameRules, GameRules.RuleKey<?> key, ServerPlayerEntity corpse, boolean keepEverything) {
        boolean keep = ((PlayerEntityBridge)corpse).bridge$keepInventory();
        if (!keep) {
            this.field_71071_by.func_70455_b(corpse.field_71071_by);
            corpse.field_71071_by.func_174888_l();
        }
        return keep;
    }

    private User impl$getUserObjectOnConstruction() {
        SpongeUserManager manager = (SpongeUserManager)SpongeCommon.getGame().getServer().getUserManager();
        if (this.impl$isFake) {
            return manager.getOrCreate(SpongeUserManager.FAKEPLAYER_PROFILE);
        }
        return manager.forceRecreateUser(SpongeGameProfile.of(this.shadow$func_146103_bH()));
    }

    @Inject(method={"restoreFrom"}, at={@At(value="HEAD")})
    private void impl$copyDataOnRespawn(ServerPlayerEntity oldPlayer, boolean respawnFromEnd, CallbackInfo ci) {
        DataCompoundHolder oldEntity;
        if (oldPlayer instanceof DataCompoundHolder && (oldEntity = (DataCompoundHolder)oldPlayer).data$hasSpongeData()) {
            CompoundNBT compound = oldEntity.data$getCompound();
            this.data$setCompound(compound);
        }
        SpongeAdventure.forEachBossBar(bar -> ((BossInfoBridge)bar).bridge$replacePlayer(oldPlayer, (ServerPlayerEntity)this));
    }

    @Inject(method={"updateOptions"}, at={@At(value="HEAD")})
    private void impl$handleClientSettings(CClientSettingsPacket packet, CallbackInfo ci) {
        if (!ShouldFire.PLAYER_CHANGE_CLIENT_SETTINGS_EVENT) {
            return;
        }
        CClientSettingsPacketAccessor $packet = (CClientSettingsPacketAccessor)packet;
        Locale newLocale = LocaleCache.getLocale($packet.accessor$language());
        ImmutableSet skinParts = (ImmutableSet)Sponge.getGame().registries().registry(RegistryTypes.SKIN_PART).stream().map(part -> (SpongeSkinPart)part).filter(part -> part.test(packet.func_149521_d())).collect(ImmutableSet.toImmutableSet());
        int viewDistance = $packet.accessor$viewDistance();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            ChatVisibility visibility = (ChatVisibility)packet.func_149523_e();
            PlayerChangeClientSettingsEvent event = SpongeEventFactory.createPlayerChangeClientSettingsEvent(frame.getCurrentCause(), visibility, (Set<SkinPart>)skinParts, newLocale, (ServerPlayer)((Object)this), packet.func_149520_f(), viewDistance);
            SpongeCommon.postEvent(event);
        }
    }

    @Inject(method={"updateOptions"}, at={@At(value="TAIL")})
    private void impl$updateTrackedClientSettings(CClientSettingsPacket packet, CallbackInfo ci) {
        CClientSettingsPacketAccessor $packet = (CClientSettingsPacketAccessor)packet;
        Locale newLocale = LocaleCache.getLocale($packet.accessor$language());
        int viewDistance = $packet.accessor$viewDistance();
        Channel channel = ((NetworkManagerAccessor)this.field_71135_a.field_147371_a).accessor$channel();
        channel.attr(SpongeAdventure.CHANNEL_LOCALE).set((Object)newLocale);
        SpongeAdventure.forEachBossBar(bar -> this.field_71135_a.func_147359_a((IPacket)new SUpdateBossInfoPacket(SUpdateBossInfoPacket.Operation.UPDATE_NAME, (BossInfo)bar)));
        this.impl$viewDistance = viewDistance;
        this.impl$language = newLocale;
    }

    @Override
    public void bridge$restorePacketItem(Hand hand) {
        if (this.impl$packetItem.func_190926_b()) {
            return;
        }
        this.shadow$func_184611_a(hand, this.impl$packetItem);
        this.field_71070_bA.func_75142_b();
    }

    @Inject(method={"slotChanged"}, at={@At(value="HEAD")})
    private void sendSlotContents(Container containerToSend, int slotIn, ItemStack stack, CallbackInfo ci) {
        if (containerToSend.func_75139_a(slotIn) instanceof CraftingResultSlot) {
            this.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(containerToSend.field_75152_c, slotIn, stack));
        }
    }

    @Override
    public PlayerOwnBorderListener bridge$getWorldBorderListener() {
        return this.impl$borderListener;
    }

    @Inject(method={"sendMessage(Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/util/text/ChatType;Ljava/util/UUID;)V"}, cancellable=true, at={@At(value="HEAD")})
    public void sendMessage(ITextComponent p_241151_1_, ChatType p_241151_2_, UUID p_241151_3_, CallbackInfo ci) {
        if (this.impl$isFake) {
            ci.cancel();
        }
    }

    private static /* synthetic */ Style lambda$null$3(ITextComponent itextcomponent1, Style p_212357_1_) {
        return p_212357_1_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)itextcomponent1));
    }
}

