/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.World;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={FireworkRocketEntity.class})
public abstract class FireworkRocketEntityMixin
extends EntityMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int field_92056_a;
    @Shadow
    private int field_92055_b;
    private ProjectileSource impl$projectileSource = UnknownProjectileSource.UNKNOWN;
    private int impl$explosionRadius = 0;

    @Override
    public int bridge$getFuseDuration() {
        return this.field_92055_b;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.field_92055_b = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.field_92055_b - this.field_92056_a;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.field_92056_a = 0;
        this.field_92055_b = fuseTicks;
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.impl$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.impl$explosionRadius = radius == null ? 0 : radius;
    }

    @Redirect(method={"explode()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;broadcastEntityEvent(Lnet/minecraft/entity/Entity;B)V"))
    private void impl$useSpongeExplosion(World world, Entity self, byte state) {
        if (this.field_70170_p.field_72995_K) {
            world.func_72960_a(self, state);
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, this.impl$projectileSource);
            SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().sourceExplosive((FireworkRocket)((Object)this)).location(((FireworkRocket)((Object)this)).getServerLocation()).radius(this.impl$explosionRadius)).ifPresent(explosion -> world.func_72960_a(self, state));
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void impl$postPrimeEvent(CallbackInfo ci) {
        if (this.field_92056_a == 1 && !this.field_70170_p.field_72995_K) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, this.impl$projectileSource);
                this.bridge$postPrime();
            }
        }
    }
}

