/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={net.minecraft.item.ItemStack.class})
public abstract class ItemStackMixin
implements CustomDataHolderBridge,
DataCompoundHolder {
    @Shadow
    private boolean field_190928_g;
    @Shadow
    private CompoundNBT field_77990_d;

    @Shadow
    public abstract void shadow$func_77982_d(@Nullable CompoundNBT var1);

    @Shadow
    @Nullable
    public abstract CompoundNBT shadow$func_77978_p();

    @Override
    public <E> DataTransactionResult bridge$offerCustom(Key<@NonNull ? extends Value<E>> key, E value) {
        if (this.field_190928_g) {
            return DataTransactionResult.failNoData();
        }
        return CustomDataHolderBridge.super.bridge$offerCustom(key, value);
    }

    @Override
    public <E> Optional<E> bridge$getCustom(Key<@NonNull ? extends Value<E>> key) {
        if (this.field_190928_g) {
            return Optional.empty();
        }
        return CustomDataHolderBridge.super.bridge$getCustom(key);
    }

    @Override
    public <E> DataTransactionResult bridge$removeCustom(Key<@NonNull ? extends Value<E>> key) {
        if (this.field_190928_g) {
            return DataTransactionResult.failNoData();
        }
        return CustomDataHolderBridge.super.bridge$removeCustom(key);
    }

    @Override
    public CompoundNBT data$getCompound() {
        return this.shadow$func_77978_p();
    }

    @Override
    public void data$setCompound(CompoundNBT nbt) {
        this.shadow$func_77982_d(nbt);
    }

    @Inject(method={"copy"}, at={@At(value="RETURN")})
    private void impl$onCopy(CallbackInfoReturnable<net.minecraft.item.ItemStack> info) {
        ((CustomDataHolderBridge)info.getReturnValue()).bridge$mergeDeserialized(this.bridge$getManipulator());
    }

    @Inject(method={"split"}, at={@At(value="RETURN")})
    private void impl$onSplit(int amount, CallbackInfoReturnable<net.minecraft.item.ItemStack> info) {
        ((CustomDataHolderBridge)info.getReturnValue()).bridge$mergeDeserialized(this.bridge$getManipulator());
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/CompoundNBT;)V"}, at={@At(value="RETURN")})
    private void impl$onRead(CompoundNBT compound, CallbackInfo info) {
        if (!this.field_190928_g) {
            CustomDataHolderBridge.syncCustomToTag(this);
        }
        if (this.field_77990_d != null && this.field_77990_d.isEmpty()) {
            this.field_77990_d = null;
        }
    }

    @Redirect(method={"removeTagKey"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundNBT;remove(Ljava/lang/String;)V"))
    private void impl$nullStackCompoundIfEmptyAfterRemoval(CompoundNBT compound, String key) {
        compound.func_82580_o(key);
        if (compound.isEmpty()) {
            this.field_77990_d = null;
        }
    }

    @Inject(method={"setTag"}, at={@At(value="RETURN")})
    private void impl$onSet(CompoundNBT compound, CallbackInfo callbackInfo) {
        if (this.shadow$func_77978_p() != compound) {
            this.bridge$clearCustomData();
        }
        CustomDataHolderBridge.syncTagToCustom(this);
    }

    @Inject(method={"mineBlock"}, at={@At(value="HEAD")})
    private void impl$capturePlayerUsingItemstack(World worldIn, BlockState blockIn, BlockPos pos, PlayerEntity playerIn, CallbackInfo ci) {
        if (!((WorldBridge)worldIn).bridge$isFake()) {
            PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
            context.capturePlayerUsingStackToBreakBlock((ItemStack)((Object)this), (ServerPlayerEntity)playerIn);
        }
    }

    @Inject(method={"mineBlock"}, at={@At(value="RETURN")})
    private void impl$nullOutCapturedPlayer(World worldIn, BlockState blockIn, BlockPos pos, PlayerEntity playerIn, CallbackInfo ci) {
        if (!((WorldBridge)worldIn).bridge$isFake()) {
            PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
            context.capturePlayerUsingStackToBreakBlock((ItemStack)((Object)this), null);
        }
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.ITEMSTACK;
    }
}

