/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.management;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.management.PlayerProfileCache;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.management.PlayerProfileCache_ProfileEntryAccessor;
import org.spongepowered.common.bridge.server.management.PlayerProfileCacheBridge;
import org.spongepowered.common.bridge.server.management.PlayerProfileCache_ProfileEntryBridge;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={PlayerProfileCache.class})
public abstract class PlayerProfileCacheMixin
implements PlayerProfileCacheBridge {
    @Shadow
    @Final
    private Map<UUID, PlayerProfileCache_ProfileEntryAccessor> field_152662_d;
    @Shadow
    @Final
    private Map<String, PlayerProfileCache_ProfileEntryAccessor> field_152661_c;
    private boolean impl$canSave = false;

    @Shadow
    public void shadow$func_152649_a(com.mojang.authlib.GameProfile profile) {
    }

    @Override
    public Optional<PlayerProfileCache_ProfileEntryBridge> bridge$getEntry(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        PlayerProfileCache_ProfileEntryAccessor accessor = this.field_152662_d.get(uniqueId);
        if (accessor == null) {
            return Optional.empty();
        }
        if (accessor.invoker$getExpirationDate().getTime() < System.currentTimeMillis()) {
            this.field_152662_d.remove(uniqueId, accessor);
            this.field_152661_c.remove(accessor.invoker$getProfile().getName(), accessor);
            return Optional.empty();
        }
        return Optional.of((PlayerProfileCache_ProfileEntryBridge)((Object)accessor));
    }

    @Override
    public Optional<PlayerProfileCache_ProfileEntryBridge> bridge$getEntry(String name) {
        Objects.requireNonNull(name, "name");
        String lowerName = name.toLowerCase(Locale.ROOT);
        PlayerProfileCache_ProfileEntryAccessor accessor = this.field_152661_c.get(lowerName);
        if (accessor == null) {
            return Optional.empty();
        }
        if (accessor.invoker$getExpirationDate().getTime() < System.currentTimeMillis()) {
            this.field_152662_d.remove(accessor.invoker$getProfile().getId(), accessor);
            this.field_152661_c.remove(lowerName, accessor);
            return Optional.empty();
        }
        return Optional.of((PlayerProfileCache_ProfileEntryBridge)((Object)accessor));
    }

    @Override
    public void bridge$add(com.mojang.authlib.GameProfile profile, boolean full, boolean signed) {
        com.mojang.authlib.GameProfile current;
        Objects.requireNonNull(profile, "profile");
        PlayerProfileCache_ProfileEntryAccessor accessor = this.field_152662_d.get(profile.getId());
        com.mojang.authlib.GameProfile gameProfile = current = accessor == null ? null : accessor.invoker$getProfile();
        if (current != null && Objects.equals(current.getId(), profile.getId()) && Objects.equals(current.getName(), profile.getName()) && !full) {
            return;
        }
        this.shadow$func_152649_a(profile);
        accessor = this.field_152662_d.get(profile.getId());
        if (accessor == null || accessor.invoker$getProfile() != profile) {
            return;
        }
        PlayerProfileCache_ProfileEntryBridge bridge = (PlayerProfileCache_ProfileEntryBridge)((Object)accessor);
        bridge.bridge$setSigned(signed);
        bridge.bridge$setIsFull(full);
    }

    @Override
    public void bridge$add(GameProfile profile, boolean full, boolean signed) {
        Objects.requireNonNull(profile, "profile");
        PlayerProfileCache_ProfileEntryAccessor accessor = this.field_152662_d.get(profile.getUniqueId());
        com.mojang.authlib.GameProfile current = accessor == null ? null : accessor.invoker$getProfile();
        com.mojang.authlib.GameProfile mcProfile = SpongeGameProfile.toMcProfile(profile);
        if (current != null && Objects.equals(current.getId(), mcProfile.getId()) && Objects.equals(current.getName(), mcProfile.getName()) && !full) {
            return;
        }
        this.shadow$func_152649_a(mcProfile);
        accessor = this.field_152662_d.get(profile.getUniqueId());
        if (accessor == null || accessor.invoker$getProfile() != mcProfile) {
            return;
        }
        ((PlayerProfileCache_ProfileEntryBridge)((Object)accessor)).bridge$set(profile, full, signed);
    }

    @Override
    public void bridge$setCanSave(boolean flag) {
        this.impl$canSave = flag;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerProfileCache;load()Ljava/util/List;"))
    private List<?> impl$callLoadAfterServerCreated(PlayerProfileCache playerProfileCache) {
        return Collections.emptyList();
    }

    @Inject(method={"add"}, at={@At(value="RETURN")})
    private void impl$UpdateCacheUsername(com.mojang.authlib.GameProfile profile, CallbackInfo ci) {
        ((SpongeServer)Sponge.getServer()).getUsernameCache().setUsername(profile.getId(), profile.getName());
    }

    @Redirect(method={"lookupGameProfile"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/GameProfileRepository;findProfilesByNames([Ljava/lang/String;Lcom/mojang/authlib/Agent;Lcom/mojang/authlib/ProfileLookupCallback;)V", remap=false))
    private static void impl$LookUpViaSponge(GameProfileRepository repository, String[] names, Agent agent, ProfileLookupCallback callback) {
        GameProfileManager profileManager = Sponge.getServer().getGameProfileManager();
        profileManager.getBasicProfile(names[0]).whenComplete((profile, ex) -> {
            if (ex != null) {
                callback.onProfileLookupFailed(new com.mojang.authlib.GameProfile(null, names[0]), ex instanceof Exception ? (Exception)ex : new RuntimeException((Throwable)ex));
            } else {
                callback.onProfileLookupSucceeded(SpongeGameProfile.toMcProfile(profile));
            }
        });
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IgnoreSavingIfCancelled(CallbackInfo ci) {
        if (!this.impl$canSave) {
            ci.cancel();
        }
    }
}

