/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import java.util.Collections;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.api.block.entity.carrier.furnace.FurnaceBlockEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.CookingEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.tileentity.LockableTileEntityMixin;

@Mixin(value={AbstractFurnaceTileEntity.class})
public abstract class AbstractFurnaceTileEntityMixin
extends LockableTileEntityMixin {
    @Shadow
    protected NonNullList<ItemStack> field_214012_a;
    @Shadow
    private int field_214020_l;
    @Shadow
    private int field_214021_m;
    @Shadow
    @Final
    protected IRecipeType<? extends AbstractCookingRecipe> field_214014_c;

    @Shadow
    protected abstract boolean shadow$func_214008_b(IRecipe<?> var1);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;shrink(I)V"))
    private void impl$throwFuelEventIfOrShrink(ItemStack itemStack, int quantity) {
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf(itemStack);
        ItemStackSnapshot shrinkedFuel = ItemStackUtil.snapshotOf(ItemStackUtil.cloneDefensive(itemStack, itemStack.func_190916_E() - 1));
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(fuel, shrinkedFuel);
        AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
        CookingEvent.ConsumeFuel event = SpongeEventFactory.createCookingEventConsumeFuel(cause, (FurnaceBlockEntity)((Object)this), Optional.of(fuel), Optional.of((CookingRecipe)recipe), Collections.singletonList(transaction));
        SpongeCommon.postEvent(event);
        if (event.isCancelled()) {
            this.field_214021_m = 0;
            return;
        }
        if (!transaction.isValid()) {
            return;
        }
        if (transaction.getCustom().isPresent()) {
            this.field_214012_a.set(1, (Object)ItemStackUtil.fromSnapshotToNative(transaction.getFinal()));
        } else {
            itemStack.func_190918_g(quantity);
        }
    }

    private AbstractCookingRecipe impl$getCurrentRecipe() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.field_214014_c, (IInventory)((AbstractFurnaceTileEntity)this), this.field_145850_b).orElse(null);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;canBurn(Lnet/minecraft/item/crafting/IRecipe;)Z", ordinal=1))
    private boolean impl$checkIfCanSmelt(AbstractFurnaceTileEntity furnace, IRecipe<?> recipe) {
        if (!this.shadow$func_214008_b(recipe)) {
            return false;
        }
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.field_214012_a.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        if (this.field_214020_l == 0) {
            CookingEvent.Start event = SpongeEventFactory.createCookingEventStart(cause, (FurnaceBlockEntity)((Object)this), Optional.of(fuel), Optional.of((CookingRecipe)recipe), Collections.emptyList());
            SpongeCommon.postEvent(event);
            return !event.isCancelled();
        }
        CookingEvent.Tick event = SpongeEventFactory.createCookingEventTick(cause, (FurnaceBlockEntity)((Object)this), Optional.of(fuel), Optional.of((CookingRecipe)recipe), Collections.emptyList());
        SpongeCommon.postEvent(event);
        return !event.isCancelled();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(III)I"))
    private int impl$resetCookTimeIfCancelled(int newCookTime, int zero, int totalCookTime) {
        int clampedCookTime = MathHelper.func_76125_a((int)newCookTime, (int)zero, (int)totalCookTime);
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.field_214012_a.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
        CookingEvent.Tick event = SpongeEventFactory.createCookingEventTick(cause, (FurnaceBlockEntity)((Object)this), Optional.of(fuel), Optional.of((CookingRecipe)recipe), Collections.emptyList());
        SpongeCommon.postEvent(event);
        if (event.isCancelled()) {
            return this.field_214020_l;
        }
        return clampedCookTime;
    }

    @Inject(method={"setItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;getTotalCookTime()I")})
    private void impl$interruptSmelt(CallbackInfo ci) {
        this.impl$callInteruptSmeltEvent();
    }

    @Inject(method={"tick"}, at={@At(shift=At.Shift.BEFORE, value="FIELD", opcode=181, target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;cookingProgress:I")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/tileentity/AbstractFurnaceTileEntity;burn(Lnet/minecraft/item/crafting/IRecipe;)V"), to=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(III)I"))})
    private void impl$onResetCookTimePassive(CallbackInfo ci) {
        this.impl$callInteruptSmeltEvent();
    }

    private void impl$callInteruptSmeltEvent() {
        if (this.field_214020_l > 0) {
            ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.field_214012_a.get(1));
            Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
            AbstractCookingRecipe recipe = this.impl$getCurrentRecipe();
            CookingEvent.Interrupt event = SpongeEventFactory.createCookingEventInterrupt(cause, (FurnaceBlockEntity)((Object)this), Optional.of(fuel), Optional.ofNullable((CookingRecipe)recipe));
            SpongeCommon.postEvent(event);
        }
    }

    @Inject(method={"burn"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;shrink(I)V")})
    private void impl$afterSmeltItem(IRecipe<?> recipe, CallbackInfo ci) {
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)this.field_214012_a.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(recipe.func_77571_b());
        CookingEvent.Finish event = SpongeEventFactory.createCookingEventFinish(cause, (FurnaceBlockEntity)((Object)this), Collections.singletonList(snapshot), Optional.of(fuel), Optional.ofNullable((CookingRecipe)recipe));
        SpongeCommon.postEvent(event);
    }
}

