/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import co.aikar.timings.Timing;
import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;

@Mixin(value={TileEntity.class})
public abstract class TileEntityMixin
implements TileEntityBridge,
DataCompoundHolder,
TimingBridge {
    @Shadow
    @Final
    private TileEntityType<?> field_200663_e;
    @Shadow
    @Nullable
    private BlockState field_195045_e;
    @Shadow
    protected World field_145850_b;
    @Shadow
    protected BlockPos field_174879_c;
    @Nullable
    private Timing impl$timing;
    private CompoundNBT impl$nbt;

    @Shadow
    public abstract BlockPos shadow$func_174877_v();

    @Shadow
    public abstract BlockState shadow$func_195044_w();

    @Shadow
    public abstract void shadow$func_70296_d();

    @Override
    public Timing bridge$getTimingsHandler() {
        if (this.impl$timing == null) {
            this.impl$timing = SpongeTimings.getTileEntityTiming((BlockEntity)((Object)this));
        }
        return this.impl$timing;
    }

    @Override
    public CompoundNBT data$getCompound() {
        return this.impl$nbt;
    }

    @Override
    public void data$setCompound(CompoundNBT nbt) {
        this.impl$nbt = nbt;
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.BLOCK_ENTITY;
    }

    @Inject(method={"saveMetadata"}, at={@At(value="RETURN")})
    private void impl$writeSpongeData(CompoundNBT compound, CallbackInfoReturnable<CompoundNBT> ci) {
        CompoundNBT forgeCompound;
        if (this.data$hasSpongeData() && (forgeCompound = compound.func_74775_l("ForgeData")) != this.data$getForgeData()) {
            if (forgeCompound.isEmpty()) {
                compound.func_218657_a("ForgeData", (INBT)forgeCompound);
            }
            forgeCompound.func_218657_a("SpongeData", (INBT)this.data$getSpongeData());
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void impl$readSpongeData(BlockState p_230337_1_, CompoundNBT compound, CallbackInfo ci) {
        this.data$setCompound(compound);
        if (this.data$hasSpongeData()) {
            CustomDataHolderBridge.syncTagToCustom(this);
            this.data$setCompound(null);
            CustomDataHolderBridge.syncCustomToTag(this);
        } else {
            this.data$setCompound(null);
        }
    }

    public String toString() {
        ResourceKey key = (ResourceKey)Registry.field_212626_o.func_177774_c(this.field_200663_e);
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)key).add("world", (Object)this.field_145850_b).add("pos", (Object)this.field_174879_c).add("blockstate", (Object)this.field_195045_e).toString();
    }

    protected MoreObjects.ToStringHelper getPrettyPrinterStringHelper() {
        ResourceKey key = (ResourceKey)Registry.field_212626_o.func_177774_c(this.field_200663_e);
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)key).add("world", (Object)((ServerWorld)this.field_145850_b).getKey()).add("pos", (Object)this.field_174879_c);
    }

    @Override
    public String bridge$getPrettyPrinterString() {
        return this.getPrettyPrinterStringHelper().toString();
    }
}

