/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.BossInfoBridge;

@Mixin(value={BossInfo.class})
public abstract class BossInfoMixin
implements BossInfoBridge {
    @Shadow
    protected ITextComponent field_186749_a;
    @Shadow
    protected float field_186750_b;
    @Shadow
    protected BossInfo.Color field_186751_c;
    @Shadow
    protected BossInfo.Overlay field_186752_d;
    @Shadow
    protected boolean field_186753_e;
    @Shadow
    protected boolean field_186754_f;
    @Shadow
    protected boolean field_186755_g;
    protected BossBar impl$adventure;

    @Override
    public void bridge$copyAndAssign(BossBar adventure) {
        this.impl$adventure = adventure;
        this.field_186750_b = adventure.progress();
        this.field_186753_e = adventure.hasFlag(BossBar.Flag.DARKEN_SCREEN);
        this.field_186754_f = adventure.hasFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        this.field_186755_g = adventure.hasFlag(BossBar.Flag.CREATE_WORLD_FOG);
    }

    @Override
    public BossBar bridge$asAdventure() {
        if (this.impl$adventure == null) {
            this.bridge$setAdventure(BossBar.bossBar((Component)SpongeAdventure.asAdventure(this.field_186749_a), (float)this.field_186750_b, (BossBar.Color)SpongeAdventure.asAdventure(this.field_186751_c), (BossBar.Overlay)SpongeAdventure.asAdventure(this.field_186752_d), SpongeAdventure.asAdventureFlags(this.field_186753_e, this.field_186754_f, this.field_186755_g)));
        }
        return this.impl$adventure;
    }

    @Override
    public void bridge$setAdventure(BossBar adventure) {
        this.impl$adventure = adventure;
    }

    @Override
    public void bridge$replacePlayer(ServerPlayerEntity oldPlayer, ServerPlayerEntity newPlayer) {
    }

    @Redirect(method={"setName"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;name:Lnet/minecraft/util/text/ITextComponent;"))
    private void adventureName(BossInfo $this, ITextComponent name) {
        this.bridge$asAdventure().name(SpongeAdventure.asAdventure(name));
    }

    @Redirect(method={"setPercent"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;percent:F"))
    private void adventurePercent(BossInfo $this, float percent) {
        this.bridge$asAdventure().progress(percent);
    }

    @Redirect(method={"setColor"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;color:Lnet/minecraft/world/BossInfo$Color;"))
    private void adventureColor(BossInfo $this, BossInfo.Color color) {
        this.bridge$asAdventure().color(SpongeAdventure.asAdventure(color));
    }

    @Redirect(method={"setOverlay"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;overlay:Lnet/minecraft/world/BossInfo$Overlay;"))
    private void adventureOverlay(BossInfo $this, BossInfo.Overlay overlay) {
        this.bridge$asAdventure().overlay(SpongeAdventure.asAdventure(overlay));
    }

    @Redirect(method={"setDarkenScreen"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;darkenScreen:Z"))
    private void adventureDarkenScreen(BossInfo $this, boolean darkenScreen) {
        if (darkenScreen) {
            this.bridge$asAdventure().addFlag(BossBar.Flag.DARKEN_SCREEN);
        } else {
            this.bridge$asAdventure().removeFlag(BossBar.Flag.DARKEN_SCREEN);
        }
    }

    @Redirect(method={"setPlayBossMusic"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;playBossMusic:Z"))
    private void adventurePlayBossMusic(BossInfo $this, boolean playBossMusic) {
        if (playBossMusic) {
            this.bridge$asAdventure().addFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        } else {
            this.bridge$asAdventure().removeFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        }
    }

    @Redirect(method={"setCreateWorldFog"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;createWorldFog:Z"))
    private void adventureCreateWorldFog(BossInfo $this, boolean createWorldFog) {
        if (createWorldFog) {
            this.bridge$asAdventure().addFlag(BossBar.Flag.CREATE_WORLD_FOG);
        } else {
            this.bridge$asAdventure().removeFlag(BossBar.Flag.CREATE_WORLD_FOG);
        }
    }

    @Redirect(method={"getName"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;name:Lnet/minecraft/util/text/ITextComponent;"))
    private ITextComponent nameRead(BossInfo $this) {
        return SpongeAdventure.asVanilla(this.bridge$asAdventure().name());
    }

    @Redirect(method={"getPercent"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;percent:F"))
    private float percentRead(BossInfo $this) {
        return this.bridge$asAdventure().progress();
    }

    @Redirect(method={"getColor"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;color:Lnet/minecraft/world/BossInfo$Color;"))
    private BossInfo.Color colorRead(BossInfo $this) {
        return SpongeAdventure.asVanilla(this.bridge$asAdventure().color());
    }

    @Redirect(method={"getOverlay"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;overlay:Lnet/minecraft/world/BossInfo$Overlay;"))
    private BossInfo.Overlay overlayRead(BossInfo $this) {
        return SpongeAdventure.asVanilla(this.bridge$asAdventure().overlay());
    }

    @Redirect(method={"shouldDarkenScreen"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;darkenScreen:Z"))
    private boolean darkenSkyRead(BossInfo $this) {
        return this.bridge$asAdventure().hasFlag(BossBar.Flag.DARKEN_SCREEN);
    }

    @Redirect(method={"shouldPlayBossMusic"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;playBossMusic:Z"))
    private boolean playEndBossMusicRead(BossInfo $this) {
        return this.bridge$asAdventure().hasFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
    }

    @Redirect(method={"shouldCreateWorldFog"}, at=@At(value="FIELD", target="Lnet/minecraft/world/BossInfo;createWorldFog:Z"))
    private boolean createFogRead(BossInfo $this) {
        return this.bridge$asAdventure().hasFlag(BossBar.Flag.CREATE_WORLD_FOG);
    }
}

