/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.server;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.PlatformServerWorldBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.storage.ServerWorldInfoBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.mixin.core.world.WorldMixin;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={net.minecraft.world.server.ServerWorld.class})
public abstract class ServerWorldMixin
extends WorldMixin
implements ServerWorldBridge,
PlatformServerWorldBridge,
ResourceKeyBridge {
    @Shadow
    @Final
    private IServerWorldInfo field_241103_E_;
    private SaveFormat.LevelSave impl$levelSave;
    private CustomServerBossInfoManager impl$bossBarManager;
    private SpongeRegistryHolder impl$registerHolder;
    private IChunkStatusListener impl$chunkStatusListener;
    private Map<Entity, Vector3d> impl$rotationUpdates;
    private boolean impl$isManualSave = false;

    @Shadow
    @Nonnull
    public abstract MinecraftServer shadow$func_73046_m();

    @Shadow
    protected abstract void shadow$func_73042_a();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void impl$cacheLevelSave(MinecraftServer p_i241885_1_, Executor p_i241885_2_, SaveFormat.LevelSave p_i241885_3_, IServerWorldInfo p_i241885_4_, RegistryKey<World> p_i241885_5_, DimensionType p_i241885_6_, IChunkStatusListener p_i241885_7_, ChunkGenerator p_i241885_8_, boolean p_i241885_9_, long p_i241885_10_, List<ISpecialSpawner> p_i241885_12_, boolean p_i241885_13_, CallbackInfo ci) {
        this.impl$levelSave = p_i241885_3_;
        this.impl$chunkStatusListener = p_i241885_7_;
        this.impl$rotationUpdates = new Object2ObjectOpenHashMap();
        this.impl$registerHolder = new SpongeRegistryHolder((DynamicRegistries.Impl)p_i241885_1_.func_244267_aX());
    }

    @Redirect(method={"getSeed"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/IServerConfiguration;worldGenSettings()Lnet/minecraft/world/gen/settings/DimensionGeneratorSettings;"))
    public DimensionGeneratorSettings impl$onGetSeed(IServerConfiguration iServerConfiguration) {
        return ((ServerWorldInfo)this.field_241103_E_).func_230418_z_();
    }

    @Override
    public SaveFormat.LevelSave bridge$getLevelSave() {
        return this.impl$levelSave;
    }

    @Override
    public IChunkStatusListener bridge$getChunkStatusListener() {
        return this.impl$chunkStatusListener;
    }

    @Override
    public boolean bridge$isLoaded() {
        if (this.bridge$isFake()) {
            return false;
        }
        net.minecraft.world.server.ServerWorld world = this.shadow$func_73046_m().func_71218_a(this.shadow$func_234923_W_());
        if (world == null) {
            return false;
        }
        return world == this;
    }

    @Override
    public void bridge$adjustDimensionLogic(DimensionType dimensionType) {
        if (this.bridge$isFake()) {
            return;
        }
        super.bridge$adjustDimensionLogic(dimensionType);
    }

    @Override
    public CustomServerBossInfoManager bridge$getBossBarManager() {
        if (this.impl$bossBarManager == null) {
            this.impl$bossBarManager = World.field_234918_g_.equals(this.shadow$func_234923_W_()) || this.bridge$isFake() ? this.shadow$func_73046_m().func_201300_aS() : new CustomServerBossInfoManager();
        }
        return this.impl$bossBarManager;
    }

    @Override
    public void bridge$addEntityRotationUpdate(Entity entity, Vector3d rotation) {
        this.impl$rotationUpdates.put(entity, rotation);
    }

    @Override
    public void bridge$updateRotation(Entity entityIn) {
        Vector3d rotationUpdate = this.impl$rotationUpdates.get(entityIn);
        if (rotationUpdate != null) {
            entityIn.field_70125_A = (float)rotationUpdate.getX();
            entityIn.field_70177_z = (float)rotationUpdate.getY();
        }
        this.impl$rotationUpdates.remove(entityIn);
    }

    @Override
    public void bridge$triggerExplosion(org.spongepowered.api.world.explosion.Explosion explosion) {
        if (ShouldFire.EXPLOSION_EVENT_PRE) {
            ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(PhaseTracker.getCauseStackManager().getCurrentCause(), explosion, (ServerWorld)((Object)this));
            if (SpongeCommon.postEvent(event)) {
                return;
            }
            explosion = event.getExplosion();
        }
        Explosion mcExplosion = (Explosion)explosion;
        try (Object ignored = GeneralPhase.State.EXPLOSION.createPhaseContext(PhaseTracker.SERVER).explosion((Explosion)explosion).source(explosion.getSourceExplosive().isPresent() ? explosion.getSourceExplosive() : this);){
            ((PhaseContext)ignored).buildAndSwitch();
            boolean shouldBreakBlocks = explosion.shouldBreakBlocks();
            mcExplosion.func_77278_a();
            mcExplosion.func_77279_a(true);
            if (!shouldBreakBlocks) {
                mcExplosion.func_180342_d();
            }
        }
    }

    @Override
    public void bridge$setManualSave(boolean state) {
        this.impl$isManualSave = state;
    }

    @Override
    public RegistryHolder bridge$registries() {
        return this.impl$registerHolder;
    }

    @Override
    public BlockSnapshot bridge$createSnapshot(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!World.func_175701_a((BlockPos)pos)) {
            return BlockSnapshot.empty();
        }
        if (!this.func_217354_b(x >> 4, z >> 4)) {
            return BlockSnapshot.empty();
        }
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        builder.world((net.minecraft.world.server.ServerWorld)this).position(new Vector3i(x, y, z));
        Chunk chunk = this.shadow$func_175726_f(pos);
        BlockState state = chunk.func_180495_p(pos);
        builder.blockState(state);
        TileEntity blockEntity = chunk.func_177424_a(pos, Chunk.CreateEntityType.CHECK);
        if (blockEntity != null) {
            TrackingUtil.addTileEntityToBuilder(blockEntity, builder);
        }
        ((ChunkBridge)chunk).bridge$getBlockCreatorUUID(pos).ifPresent(builder::creator);
        ((ChunkBridge)chunk).bridge$getBlockNotifierUUID(pos).ifPresent(builder::notifier);
        builder.flag(BlockChangeFlags.NONE);
        return builder.build();
    }

    @Override
    public ResourceKey bridge$getKey() {
        return (ResourceKey)this.shadow$func_234923_W_().func_240901_a_();
    }

    @Redirect(method={"saveLevelData"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorldData()Lnet/minecraft/world/storage/IServerConfiguration;"))
    private IServerConfiguration impl$usePerWorldLevelDataForDragonFight(MinecraftServer server) {
        return (IServerConfiguration)this.shadow$func_72912_H();
    }

    @Redirect(method={"setDefaultSpawnPos"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerChunkProvider;addRegionTicket(Lnet/minecraft/world/server/TicketType;Lnet/minecraft/util/math/ChunkPos;ILjava/lang/Object;)V"))
    private void impl$respectKeepSpawnLoaded(ServerChunkProvider serverChunkProvider, TicketType<Object> p_217228_1_, ChunkPos p_217228_2_, int p_217228_3_, Object p_217228_4_) {
        if (((ServerWorldProperties)this.shadow$func_72912_H()).performsSpawnLogic()) {
            serverChunkProvider.func_217228_a(p_217228_1_, p_217228_2_, p_217228_3_, p_217228_4_);
        }
    }

    @Overwrite
    public void func_217445_a(@Nullable IProgressUpdate progress, boolean flush, boolean skipSave) {
        ServerWorldInfo levelData = (ServerWorldInfo)this.shadow$func_72912_H();
        ServerChunkProvider chunkProvider = ((net.minecraft.world.server.ServerWorld)this).func_72863_F();
        if (!skipSave) {
            boolean canManuallySave;
            SerializationBehavior behavior = ((ServerWorldInfoBridge)levelData).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
            if (progress != null) {
                progress.func_200210_a((ITextComponent)new TranslationTextComponent("menu.savingLevel"));
            }
            if (behavior != SerializationBehavior.NONE) {
                this.shadow$func_73042_a();
                levelData.func_230393_a_(this.func_175723_af().func_235927_t_());
                levelData.func_230414_b_(this.bridge$getBossBarManager().func_201380_c());
                this.bridge$getLevelSave().func_237288_a_(SpongeCommon.getServer().func_244267_aX(), (IServerConfiguration)((ServerWorldInfo)this.shadow$func_72912_H()), this.shadow$func_234923_W_() == World.field_234918_g_ ? SpongeCommon.getServer().func_184103_al().func_72378_q() : null);
            }
            if (progress != null) {
                progress.func_200209_c((ITextComponent)new TranslationTextComponent("menu.savingChunks"));
            }
            boolean canAutomaticallySave = !this.impl$isManualSave && behavior == SerializationBehavior.AUTOMATIC;
            boolean bl = canManuallySave = this.impl$isManualSave && behavior == SerializationBehavior.MANUAL;
            if (canAutomaticallySave || canManuallySave) {
                chunkProvider.func_217210_a(flush);
            }
        }
        this.impl$isManualSave = false;
    }

    public String toString() {
        return new StringJoiner(",", net.minecraft.world.server.ServerWorld.class.getSimpleName() + "[", "]").add("key=" + this.shadow$func_234923_W_()).add("worldType=" + ((WorldType)this.shadow$func_230315_m_()).key(RegistryTypes.WORLD_TYPE)).toString();
    }
}

