/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.spawner;

import net.minecraft.entity.EntityClassification;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.spawner.WorldEntitySpawner_EntityDensityManagerAccessor;
import org.spongepowered.common.bridge.world.spawner.WorldEntitySpawner_EntityDensityManagerBridge;
import org.spongepowered.common.bridge.world.storage.ServerWorldInfoBridge;
import org.spongepowered.common.config.inheritable.SpawnerCategory;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={WorldEntitySpawner.class})
public abstract class WorldEntitySpawnerMixin {
    @Shadow
    @Final
    private static EntityClassification[] field_234961_c_;

    @Shadow
    public static void func_234967_a_(EntityClassification p_234967_0_, ServerWorld p_234967_1_, Chunk p_234967_2_, WorldEntitySpawner.IDensityCheck p_234967_3_, WorldEntitySpawner.IOnSpawnDensityAdder p_234967_4_) {
    }

    @Overwrite
    public static void func_234979_a_(ServerWorld world, Chunk chunk, WorldEntitySpawner.EntityDensityManager manager, boolean spawnFriendlies, boolean spawnEnemies, boolean doMobSpawning) {
        world.func_217381_Z().func_76320_a("spawner");
        for (EntityClassification entityclassification : field_234961_c_) {
            if (!spawnFriendlies && entityclassification.func_75599_d() || !spawnEnemies && !entityclassification.func_75599_d() || !doMobSpawning && entityclassification.func_82705_e() || !WorldEntitySpawnerMixin.impl$usePerWorldSpawnRules(manager, entityclassification, world)) continue;
            WorldEntitySpawnerMixin.func_234967_a_(entityclassification, world, chunk, (p_234969_1_, p_234969_2_, p_234969_3_) -> ((WorldEntitySpawner_EntityDensityManagerAccessor)manager).invoker$canSpawn(p_234969_1_, p_234969_2_, p_234969_3_), (p_234970_1_, p_234970_2_) -> ((WorldEntitySpawner_EntityDensityManagerAccessor)manager).invoker$afterSpawn(p_234970_1_, p_234970_2_));
        }
        world.func_217381_Z().func_76319_b();
    }

    private static boolean impl$usePerWorldSpawnRules(WorldEntitySpawner.EntityDensityManager manager, EntityClassification classification, ServerWorld world) {
        int tick = WorldEntitySpawnerMixin.impl$getSpawningTickRate(classification, world);
        if (tick == 0) {
            return false;
        }
        return world.func_82737_E() % (long)tick == 0L && ((WorldEntitySpawner_EntityDensityManagerBridge)manager).bridge$canSpawnForCategoryInWorld(classification, world);
    }

    private static int impl$getSpawningTickRate(EntityClassification classification, ServerWorld world) {
        SpawnerCategory.TickRatesSubCategory tickRates = ((WorldConfig)((ServerWorldInfoBridge)world.func_72912_H()).bridge$configAdapter().get()).spawner.tickRates;
        switch (classification) {
            case MONSTER: {
                return tickRates.monster;
            }
            case CREATURE: {
                return tickRates.creature;
            }
            case AMBIENT: {
                return tickRates.ambient;
            }
            case WATER_CREATURE: {
                return tickRates.aquaticCreature;
            }
            case WATER_AMBIENT: {
                return tickRates.aquaticAmbient;
            }
        }
        throw new IllegalStateException("Unexpected value: " + classification);
    }
}

