/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.storage.PlayerData;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;

@Mixin(value={PlayerData.class})
public abstract class PlayerDataMixin {
    @Shadow
    @Final
    private File field_237333_c_;
    private @Nullable Exception impl$capturedException;

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;load(Lnet/minecraft/nbt/CompoundNBT;)V"))
    private void impl$readSpongePlayerData(PlayerEntity playerEntity, CompoundNBT compound) throws IOException {
        playerEntity.func_70020_e(compound);
        Path file = new File(this.field_237333_c_, playerEntity.func_189512_bd() + ".dat").toPath();
        Instant creationTime = Files.exists(file, new LinkOption[0]) ? Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant() : null;
        ((SpongeServer)SpongeCommon.getServer()).getPlayerDataManager().readPlayerData(compound, null, creationTime);
    }

    @Inject(method={"save"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompressedStreamTools;writeCompressed(Lnet/minecraft/nbt/CompoundNBT;Ljava/io/File;)V", shift=At.Shift.AFTER)})
    private void impl$saveSpongePlayerData(PlayerEntity player, CallbackInfo callbackInfo) {
        ((SpongeServer)Sponge.getServer()).getPlayerDataManager().saveSpongePlayerData(player.func_110124_au());
    }

    @Inject(method={"save"}, at={@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void impl$trackExceptionForLogging(PlayerEntity player, CallbackInfo ci, Exception exception) {
        this.impl$capturedException = exception;
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false))
    private void impl$useStoredException(Logger logger, String message, Object param) {
        logger.warn(message, param, (Object)this.impl$capturedException);
        this.impl$capturedException = null;
    }
}

