/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollision.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.world.World;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.entitycollision.CollisionCapabilityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.storage.ServerWorldInfoBridge;
import org.spongepowered.common.config.inheritable.EntityCollisionCategory;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={Entity.class}, priority=1002)
public abstract class EntityMixin_EntityCollision
implements CollisionCapabilityBridge {
    private ResourceKey entityCollision$key;
    private int entityCollision$maxCollisions = 8;
    private boolean entityCollision$refreshCache = false;

    @Shadow
    public abstract World shadow$func_130014_f_();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void collisions$InjectActivationInformation(EntityType<?> type, World world, CallbackInfo ci) {
        if (world != null && !((WorldBridge)world).bridge$isFake() && ((ServerWorldInfoBridge)world.func_72912_H()).bridge$valid()) {
            if ((Entity)this instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)this;
                net.minecraft.item.ItemStack itemstack = item.func_92059_d();
                if (!itemstack.func_190926_b()) {
                    this.entityCollision$key = Sponge.getGame().registries().registry(RegistryTypes.ITEM_TYPE).valueKey(((ItemStack)itemstack).getType());
                }
            } else {
                this.entityCollision$key = Sponge.getGame().registries().registry(RegistryTypes.ENTITY_TYPE).valueKey(((org.spongepowered.api.entity.Entity)((Object)this)).getType());
            }
            if (!this.shadow$func_130014_f_().func_201670_d()) {
                this.collision$initializeCollisionState(this.shadow$func_130014_f_());
            }
        }
    }

    @Override
    public ResourceKey collision$getKey() {
        return this.entityCollision$key;
    }

    @Override
    public int collision$getMaxCollisions() {
        return this.entityCollision$maxCollisions;
    }

    @Override
    public void collision$setMaxCollisions(int max) {
        this.entityCollision$maxCollisions = max;
    }

    @Override
    public void collision$initializeCollisionState(World world) {
        InheritableConfigHandle<WorldConfig> worldConfigAdapter = ((ServerWorldInfoBridge)world.func_72912_H()).bridge$configAdapter();
        ConfigHandle<CommonConfig> globalConfigAdapter = SpongeConfigs.getCommon();
        EntityCollisionCategory.ModSubCategory worldCollMod = worldConfigAdapter.getOrCreateValue(s2 -> s2.entityCollision.mods.get(this.entityCollision$key.getNamespace()), c -> {
            EntityCollisionCategory.ModSubCategory globalCollision = new EntityCollisionCategory.ModSubCategory(this.entityCollision$key.getNamespace());
            c.entityCollision.mods.put(this.entityCollision$key.getNamespace(), globalCollision);
            globalCollision.entities.put(this.entityCollision$key.getNamespace(), this.collision$getMaxCollisions());
        }, ((WorldConfig)worldConfigAdapter.get()).entityCollision.autoPopulate);
        EntityCollisionCategory worldCollCat = ((WorldConfig)worldConfigAdapter.get()).entityCollision;
        this.collision$setMaxCollisions(worldCollCat.maxEntitiesWithinAABB);
        boolean requiresSave = false;
        if (worldCollMod != null) {
            if (!worldCollMod.enabled) {
                this.collision$setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = worldCollMod.entityDefault;
            if (modCollisionMax != null) {
                this.collision$setMaxCollisions(modCollisionMax);
            }
            Integer entityMaxCollision = null;
            if ((Entity)this instanceof ItemEntity) {
                entityMaxCollision = worldCollMod.entities.get(this.entityCollision$key.getValue());
            }
            if (entityMaxCollision == null) {
                entityMaxCollision = worldCollMod.entities.get(this.entityCollision$key.getValue());
            }
            if (entityMaxCollision == null && worldCollCat.autoPopulate) {
                requiresSave = true;
            } else if (entityMaxCollision != null) {
                this.collision$setMaxCollisions(entityMaxCollision);
            }
        }
        if (this.collision$getMaxCollisions() <= 0) {
            return;
        }
        if (requiresSave) {
            globalConfigAdapter.save();
        }
    }

    @Override
    public void collision$requiresCollisionsCacheRefresh(boolean flag) {
        this.entityCollision$refreshCache = flag;
    }

    @Override
    public boolean collision$requiresCollisionsCacheRefresh() {
        return this.entityCollision$refreshCache;
    }

    @Override
    public boolean collision$isRunningCollideWithNearby() {
        return false;
    }
}

