/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.inventory.container;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={WorkbenchContainer.class})
public abstract class WorkbenchContainerMixin_Inventory {
    @Inject(method={"slotChangedCraftingGrid"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/CraftResultInventory;setItem(ILnet/minecraft/item/ItemStack;)V")})
    private static void beforeSlotChangedCraftingGrid(int p_217066_0_, World p_217066_1_, PlayerEntity p_217066_2_, net.minecraft.inventory.CraftingInventory p_217066_3_, CraftResultInventory p_217066_4_, CallbackInfo ci, ServerPlayerEntity serverPlayerEntity, ItemStack itemStack) {
        TrackedInventoryBridge trackedContainer = (TrackedInventoryBridge)p_217066_2_.field_71070_bA;
        TrackedContainerBridge container = (TrackedContainerBridge)p_217066_2_.field_71070_bA;
        if (trackedContainer.bridge$capturingInventory()) {
            List<SlotTransaction> craftPreviewTransactions = container.bridge$getPreviewTransactions();
            craftPreviewTransactions.clear();
            ItemStackSnapshot orig = ItemStackUtil.snapshotOf(p_217066_4_.func_70301_a(0));
            ItemStackSnapshot repl = ItemStackUtil.snapshotOf(itemStack);
            Slot slot = ((InventoryAdapter)p_217066_2_.field_71070_bA).inventoryAdapter$getSlot(0).get();
            craftPreviewTransactions.add(new SlotTransaction(slot, orig, repl));
        }
    }

    @Inject(method={"slotChangedCraftingGrid"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;send(Lnet/minecraft/network/IPacket;)V")})
    private static void afterSlotChangedCraftingGrid(int p_217066_0_, World world, PlayerEntity player, net.minecraft.inventory.CraftingInventory craftingInventory, CraftResultInventory output, CallbackInfo ci) {
        TrackedContainerBridge container = (TrackedContainerBridge)player.field_71070_bA;
        List<SlotTransaction> craftPreviewTransactions = container.bridge$getPreviewTransactions();
        if (container.bridge$firePreview() && !craftPreviewTransactions.isEmpty()) {
            for (net.minecraft.inventory.container.Slot slot : player.field_71070_bA.field_75151_b) {
            }
            Inventory inv = ((Inventory)player.field_71070_bA).query(QueryTypes.INVENTORY_TYPE.get().of(CraftingInventory.class));
            if (!(inv instanceof CraftingInventory)) {
                SpongeCommon.getLogger().warn("Detected crafting but Sponge could not get a CraftingInventory for " + player.field_71070_bA.getClass().getName());
                return;
            }
            SlotTransaction previewTransaction = craftPreviewTransactions.get(craftPreviewTransactions.size() - 1);
            ICraftingRecipe recipe = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, world).orElse(null);
            InventoryEventFactory.callCraftEventPre(player, (CraftingInventory)inv, previewTransaction, (CraftingRecipe)recipe, player.field_71070_bA, craftPreviewTransactions);
            craftPreviewTransactions.clear();
        }
    }
}

