/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.impl.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.inventory.InventoryBridge;
import org.spongepowered.common.bridge.inventory.LensGeneratorBridge;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.LensRegistrar;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_EquipmentFabric_Inventory
implements Fabric,
InventoryBridge,
LensGeneratorBridge {
    private static final EquipmentSlotType[] SLOTS;
    private static final int MAX_STACK_SIZE = 64;

    @Shadow
    public abstract ItemStack shadow$func_184582_a(EquipmentSlotType var1);

    @Shadow
    public abstract void shadow$func_184201_a(EquipmentSlotType var1, ItemStack var2);

    @Override
    public Collection<InventoryBridge> fabric$allInventories() {
        return Collections.singleton(this);
    }

    @Override
    public InventoryBridge fabric$get(int index) {
        return this;
    }

    @Override
    public ItemStack fabric$getStack(int index) {
        return this.shadow$func_184582_a(SLOTS[index]);
    }

    @Override
    public void fabric$setStack(int index, ItemStack stack) {
        this.shadow$func_184201_a(SLOTS[index], stack);
    }

    @Override
    public int fabric$getMaxStackSize() {
        return 64;
    }

    @Override
    public int fabric$getSize() {
        return SLOTS.length;
    }

    @Override
    public void fabric$clear() {
        for (EquipmentSlotType slot : SLOTS) {
            this.shadow$func_184201_a(slot, ItemStack.field_190927_a);
        }
    }

    @Override
    public void fabric$markDirty() {
    }

    @Override
    public SlotLensProvider lensGeneratorBridge$generateSlotLensProvider() {
        return new LensRegistrar.BasicSlotLensProvider(this.fabric$getSize());
    }

    @Override
    public Lens lensGeneratorBridge$generateLens(SlotLensProvider slotLensProvider) {
        LinkedHashMap<EquipmentType, SlotLens> equipmentLenses = new LinkedHashMap<EquipmentType, SlotLens>();
        int slotsLength = SLOTS.length;
        for (int i = 0; i < slotsLength; ++i) {
            EquipmentSlotType slot = SLOTS[i];
            equipmentLenses.put((EquipmentType)slot, slotLensProvider.getSlotLens(i));
        }
        return new EquipmentInventoryLens(equipmentLenses);
    }

    static {
        EquipmentSlotType[] values = EquipmentSlotType.values();
        SLOTS = new EquipmentSlotType[values.length];
        EquipmentSlotType[] equipmentSlotTypeArray = values;
        int n = equipmentSlotTypeArray.length;
        for (int i = 0; i < n; ++i) {
            EquipmentSlotType slot;
            LivingEntityMixin_EquipmentFabric_Inventory.SLOTS[slot.func_188454_b()] = slot = equipmentSlotTypeArray[i];
        }
    }
}

