/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.MissingImplementationException;

public class CorePlugin
implements IMixinConfigPlugin {
    private static final Map<String, BiConsumer<ClassNode, IMixinInfo>> SUPERCLASS_TRANSFORMATIONS;
    private static final Map<String, Consumer<ClassNode>> INCOMPATIBILITY_DETECTION_ERRORS;
    private static final List<String> MUTABLE_BLOCK_POS_FIELDS;

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        BiConsumer<ClassNode, IMixinInfo> superTransformer;
        Consumer<ClassNode> classNodeConsumer = INCOMPATIBILITY_DETECTION_ERRORS.get(mixinClassName);
        if (classNodeConsumer != null) {
            classNodeConsumer.accept(targetClass);
        }
        if ((superTransformer = SUPERCLASS_TRANSFORMATIONS.get(targetClassName)) != null) {
            superTransformer.accept(targetClass, mixinInfo);
        }
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static void printFoamFixAndShutDown() {
        new PrettyPrinter(60).add("!!! FoamFix Incompatibility !!!").centre().hr().addWrapped("Hello! You are running SpongeForge and \"likely\" FoamFix on the same server, and we've discoverd a missing field that would otherwise cause some of Sponge not to work, because foamfix removes that field. As the issue stands, it's not possible to \"patch fix\", but we can suggest the configuration option change in foamfix's config to allow your game to start! Please change the following options in foamfix'es config.", new Object[0]).add().add("In config/foamfix.cfg, change these values: ").add("B:optimizedBlockPos=false").add("B:patchChunkSerialization=false").add().addWrapped("We at Sponge appreciate your patience as this can be frustrating when the game doesn't start right away, or that SpongeForge isn't an easy drop-in-and-get-running sometimes. Thank you for your consideration, and have a nice day!", new Object[0]).add().add((Throwable)new IncompatibleClassChangeError("FoamFix Incompatibility Detected")).log(SpongeCommon.getLogger(), Level.FATAL);
        throw new MissingImplementationException("SpongeCommon", "forceEarlyExit");
    }

    static {
        ConcurrentHashMap transformers = new ConcurrentHashMap();
        SUPERCLASS_TRANSFORMATIONS = Collections.unmodifiableMap(transformers);
        INCOMPATIBILITY_DETECTION_ERRORS = new ConcurrentHashMap<String, Consumer<ClassNode>>();
        MUTABLE_BLOCK_POS_FIELDS = ImmutableList.builder().add((Object)"x:field_177997_b").add((Object)"y:field_177998_c").add((Object)"z:field_177996_d").build();
    }
}

